/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.rsm.sr.unallocate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.filter.FilterKeyValueCollection;
import kd.bos.entity.filter.FilterKeyValueCollections;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseList;
import kd.tsc.tsirm.business.domain.rsm.sr.helper.AssignPositionHelper;
import kd.tsc.tsirm.business.domain.rsm.unallocate.UnAllocateRsmHelper;
import kd.tsc.tsrbd.business.domain.label.service.LabelDataHelper;
import kd.tsc.tsrbd.common.enums.DatePeriodEnum;
import kd.tsc.tsrbd.common.enums.LabelTagObjTypeEnum;
import kd.tsc.tsrbd.common.kdstring.TSCBaseKDString;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsrbs.common.utils.ListViewUtils;
import kd.tsc.tsrbs.common.utils.TSCBaseUtils;

public class UnAllocateRsmList
extends HRCoreBaseList
implements BeforeFilterF7SelectListener {
    private static final String AI_LABEL_SUFFIX = "(AI)";
    private static final String KEY_DISTYIPOSITION = "distyiposition";
    private static final String CURR_PRJ_NAME = "tsc-tsirm-formplugin";
    private static final Map<String, String> DATE_ENUM_MAP = Maps.newHashMap();
    private final Map<String, List<Object>> filterDataMap = Maps.newHashMap();
    private Set<Long> inBlackListIdSet;

    public void filterColumnSetFilter(SetFilterEvent args) {
        if (this.filterDataMap.isEmpty()) {
            this.handleFilterValues();
        }
    }

    public void beforePackageData(BeforePackageDataEvent ee) {
        this.inBlackListIdSet = UnAllocateRsmHelper.getBlackListSet(ee.getPageData().stream().map(dyo -> (Long)dyo.getPkValue()).collect(Collectors.toList()));
    }

    public void packageData(PackageDataEvent ee) {
        DynamicObject rowData = ee.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)ee.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if ("workingyears".equals(fieldKey)) {
            int workMonths = rowData.getInt("workingyears");
            ee.setFormatValue((Object)ResumeAnalysisHelper.getWorkYearShow((int)workMonths));
        } else if ("blackliststatus".equals(fieldKey) && this.inBlackListIdSet.contains(rowData.getPkValue())) {
            ee.setFormatValue((Object)"1");
        }
        if ("portrait".equals(fieldKey)) {
            ee.setFormatValue((Object)"1");
        }
    }

    private void handleFilterValues() {
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        FilterKeyValueCollections otherFilterValues = fc.getCachedFilterValues().getOtherFilterValues();
        if (otherFilterValues != null) {
            for (FilterKeyValueCollection filterKeyValueCollection : otherFilterValues.getFilterValueCollection()) {
                List filterKeyValues = filterKeyValueCollection.getFilterKeyValues();
                ListViewUtils.handleFilterKeyValue((List)filterKeyValues, this.filterDataMap);
            }
        }
    }

    public void registerListener(EventObject ee) {
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        if (fc != null) {
            fc.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
        }
    }

    public void customEvent(CustomEventArgs ee) {
        String eventName = ee.getEventName();
        if ("showtip".equals(eventName)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("tsirm_unallocatersmtip");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        this.addLabelFilterColumn(args);
        this.setCommonFilterColumnsDefaultValue(args);
    }

    private void setCommonFilterColumnsDefaultValue(FilterContainerInitArgs args) {
        List commonFilterColumns = args.getCommonFilterColumns();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String deliverTimeFilterParam = TSCBaseUtils.getString((String)((String)formShowParameter.getCustomParam("timeRangeType")));
        if (HRStringUtils.isNotEmpty((String)deliverTimeFilterParam)) {
            for (FilterColumn commonFilterColumn : commonFilterColumns) {
                String defaultDeliverTime;
                if (!commonFilterColumn.getFieldName().equals("delivery.applytime") || !HRStringUtils.isNotEmpty((String)(defaultDeliverTime = DATE_ENUM_MAP.get(deliverTimeFilterParam)))) continue;
                commonFilterColumn.setDefaultValues(new Object[]{DATE_ENUM_MAP.get(deliverTimeFilterParam)});
            }
        }
    }

    private void addLabelFilterColumn(FilterContainerInitArgs args) {
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        CommonBaseDataFilterColumn labelColumn = new CommonBaseDataFilterColumn();
        labelColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6807\u7b7e", (String)"UnAllocateRsmList_3", (String)CURR_PRJ_NAME, (Object[])new Object[0])));
        labelColumn.setFieldName("label");
        labelColumn.setEntityField(false);
        labelColumn.setMulti(true);
        labelColumn.setDefaultValue("");
        ArrayList tagObjTypeIds = Lists.newArrayList((Object[])new Long[]{LabelTagObjTypeEnum.IN_RESUME.getId()});
        DynamicObject[] labels = LabelDataHelper.getLabelsByObjType((List)tagObjTypeIds, (QFilter)new QFilter("labelcategory", "=", (Object)"C"));
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(labels.length);
        for (DynamicObject label : labels) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(label.getString("name") + AI_LABEL_SUFFIX));
            item.setValue(label.getString("id"));
            combos.add(item);
        }
        labelColumn.setComboItems(combos);
        labelColumn.setType("enum");
        commonFilterColumns.add(labelColumn);
    }

    public void setFilter(SetFilterEvent ee) {
        this.handleSchemeFilter(ee);
        this.handleCommonFilter(ee);
        this.setQFilter(ee);
        ee.setOrderBy("delivery.applytime DESC");
    }

    private void setQFilter(SetFilterEvent ee) {
        ee.getQFilters().add(UnAllocateRsmHelper.getUnAllocatedQFilter());
    }

    private void handleSchemeFilter(SetFilterEvent ee) {
        for (int i = 0; i < ee.getQFilters().size(); ++i) {
            QFilter qFilter = (QFilter)ee.getQFilters().get(i);
            if ("label.name".equals(qFilter.getProperty())) {
                ee.getQFilters().set(i, UnAllocateRsmHelper.getSchemaLabelQFilter((QFilter)qFilter));
                continue;
            }
            if ("educationform.name".equals(qFilter.getProperty())) {
                ee.getQFilters().set(i, new QFilter("id", "in", (Object)this.getEduFormQFilter(qFilter)));
                continue;
            }
            if ("lastposcat.name".equals(qFilter.getProperty()) || "lastindustrytype.name".equals(qFilter.getProperty())) {
                ee.getQFilters().set(i, this.getLastPosCatOrLastIndustryTypeQFilter(qFilter));
                continue;
            }
            if ("linkway".equals(qFilter.getProperty())) {
                ee.getQFilters().set(i, UnAllocateRsmHelper.handleLinkWayFilter((Object)qFilter.getValue()));
                continue;
            }
            if (!"postposition".equals(qFilter.getProperty())) continue;
            qFilter.__setProperty("delivery.postposition");
        }
    }

    private QFilter getEduFormQFilter(QFilter qFilter) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_srrsmeduexp");
        DynamicObjectCollection eduExpColl = helper.queryOriginalCollection("rsm", qFilter.toArray());
        return new QFilter("id", "in", eduExpColl.stream().map(dyo -> dyo.getLong("rsm")).collect(Collectors.toSet()));
    }

    private QFilter getLastPosCatOrLastIndustryTypeQFilter(QFilter qFilter) {
        qFilter.__setProperty(qFilter.getProperty().substring(4));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_srrsmworkexp");
        DynamicObjectCollection workExpColl = helper.queryOriginalCollection("rsm", qFilter.toArray());
        return new QFilter("id", "in", workExpColl.stream().map(dyo -> dyo.getLong("rsm")).collect(Collectors.toSet()));
    }

    private void handleCommonFilter(SetFilterEvent ee) {
        List<Object> rsmLabels = this.filterDataMap.get("label");
        if (rsmLabels != null && !rsmLabels.isEmpty() && !rsmLabels.get(0).toString().isEmpty()) {
            UnAllocateRsmHelper.setCommonLabelQFilter((SetFilterEvent)ee, rsmLabels);
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent f7SelectEvent) {
        if (f7SelectEvent.getFieldName().startsWith("label")) {
            f7SelectEvent.getQfilters().add(LabelDataHelper.getLabelQfilter((List)Lists.newArrayList((Object[])new Long[]{LabelTagObjTypeEnum.IN_RESUME.getId()})).and(new QFilter("labelcategory", "=", (Object)"C")));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (KEY_DISTYIPOSITION.equals(evt.getItemKey()) || "discardpos".equals(evt.getOperationKey())) {
            evt.setCancel(UnAllocateRsmHelper.validateIsRsmDelete(this.getSelectedRowsID(), (IFormView)this.getView(), (String)TSCBaseKDString.dataChangedTip()));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if (KEY_DISTYIPOSITION.equals(evt.getItemKey())) {
            boolean checkPermission = AssignPositionHelper.checkPermission((String)"tsirm", (String)"tsirm_rsm_unallocated", (String)"2/52S4X1O0ZK");
            if (!checkPermission) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5f85\u5206\u914d\u7b80\u5386\u201d\u7684\u201c\u5206\u914d\u804c\u4f4d\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"UnAllocateRsmEdit_2", (String)CURR_PRJ_NAME, (Object[])new Object[0]));
                return;
            }
            UnAllocateRsmHelper.assignPosition(this.getSelectedRowsID(), (AbstractFormPlugin)this);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if ("blackliststatus".equals(args.getFieldName())) {
            this.showBlackListInfoPage(args);
        }
        if ("portrait".equals(args.getFieldName())) {
            args.setCancel(true);
            Long rsmId = (Long)((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentListAllRowCollection().get(args.getRowIndex()).getPrimaryKeyValue();
            LabelDataHelper.showAppRsmPortraitPage((IFormView)this.getView(), (Long)rsmId, (Long)LabelTagObjTypeEnum.IN_RESUME.getId());
        }
    }

    private void showBlackListInfoPage(HyperLinkClickArgs args) {
        args.setCancel(true);
        Long rsmId = (Long)((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentListAllRowCollection().get(args.getRowIndex()).getPrimaryKeyValue();
        UnAllocateRsmHelper.showBlackListDetailPage((Long)rsmId, (IFormView)this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        UnAllocateRsmHelper.handleClosedCallback((AbstractFormPlugin)this, (ClosedCallBackEvent)closedCallBackEvent);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate && "discardpos".equals((source = (FormOperate)args.getSource()).getOperateKey())) {
            args.setCancel(UnAllocateRsmHelper.validateIsRsmDelete(this.getSelectedRowsID(), (IFormView)this.getView(), (String)TSCBaseKDString.dataChangedTip()));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        Integer count = this.getSelectedRowsID().size();
        if ("execallocrule".equals(operateKey)) {
            String message = String.format(ResManager.loadKDString((String)"\u5206\u914d\u4efb\u52a1\u6b63\u5728\u540e\u53f0\u6267\u884c\u4e2d\uff0c\u5171%s\u4efd\u7b80\u5386\uff0c\u9884\u8ba1\u9700\u8981%s\u79d2\u5de6\u53f3", (String)"UnAllocateRsmList_1", (String)CURR_PRJ_NAME, (Object[])new Object[0]), count, 30);
            this.getView().showConfirm(message, MessageBoxOptions.OK);
        } else if ("discardpos".equals(operateKey)) {
            this.clearSelection();
            this.reload();
        } else if ("savetalent".equals(afterDoOperationEventArgs.getOperateKey())) {
            List selectPkIds = ListViewUtils.getSelectPkIds((AbstractListPlugin)this);
            String pageNumber = ((ListView)this.getView()).getBillFormId();
            UnAllocateRsmHelper.validateTalentRight((AbstractFormPlugin)this, (List)selectPkIds, (String)pageNumber, (String)"savetalent");
        }
    }

    private List<Long> getSelectedRowsID() {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        ArrayList<Long> selectedIdList = new ArrayList<Long>(primaryKeyValues.length);
        Arrays.stream(primaryKeyValues).forEach(obj -> selectedIdList.add((Long)obj));
        return selectedIdList;
    }

    static {
        DATE_ENUM_MAP.put(DatePeriodEnum.TODAY.getCode(), "13");
        DATE_ENUM_MAP.put(DatePeriodEnum.THIS_WEEK.getCode(), "10");
        DATE_ENUM_MAP.put(DatePeriodEnum.THIS_MONTH.getCode(), "63");
        DATE_ENUM_MAP.put(DatePeriodEnum.PAST_THREE_MONTH.getCode(), "24");
        DATE_ENUM_MAP.put(DatePeriodEnum.PAST_ONE_YEAR.getCode(), "68");
    }
}

