/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.stdrsm.bill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsirm.business.domain.cert.CertService;
import kd.tsc.tsirm.business.domain.stdrsm.helper.ResumeFormHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.ResumeValidateHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.service.StdRsmCommonService;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.oprecord.TalentPoolOperateRecordService;
import kd.tsc.tsirm.business.domain.talentpool.entity.TalentPoolFallMessage;
import kd.tsc.tsirm.business.domain.talentpool.service.CheckPermissionHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentListFunService;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtHelper;
import kd.tsc.tsirm.common.constants.talentpool.TSTPMTalentPoolConstants;
import kd.tsc.tsrbd.business.application.external.person.BizHRPIEmployeeService;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tsrbs.common.utils.GenerateFormShowParamUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CandidateDetailPagePlugin
extends HRDynamicFormBasePlugin {
    private static final String VIEW_DELIVERY = "viewdelivery";
    private static final HashMap<String, Consumer<Map<String, Object>>> CLICK_MAP = new HashMap(8);
    private static final String TOOL_TOOLBARAP = "toolbarap";

    public CandidateDetailPagePlugin() {
        CLICK_MAP.put("storetotalentpool", map -> this.judgeIsEjectTips("storetotalentpool"));
        CLICK_MAP.put("recommendtoposition", map -> this.judgeIsEjectTips("recommendtoposition"));
        CLICK_MAP.put("btn_sendntfc", map -> this.judgeIsEjectTips("btn_sendntfc"));
        CLICK_MAP.put("btn_invite", map -> this.judgeIsEjectTips("btn_invite"));
        CLICK_MAP.put("btn_invitedelivery", map -> this.judgeIsEjectTips("btn_invitedelivery"));
        CLICK_MAP.put("btn_share", map -> this.judgeIsEjectTips("btn_share"));
        CLICK_MAP.put("btn_add_blacklist", map -> this.judgeIsEjectTips("btn_add_blacklist"));
        CLICK_MAP.put("btn_remove_blacklist", map -> this.judgeIsEjectTips("btn_remove_blacklist"));
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        FormShowParameter parameter = args.getFormShowParameter();
        String validate = ResumeValidateHelper.stdRsmDetailOpenValidate((FormShowParameter)parameter);
        if (HRStringUtils.isNotEmpty((String)validate)) {
            args.setCancel(true);
            args.setCancelMessage(validate);
            return;
        }
        Long stdRsmId = Long.parseLong(parameter.getCustomParam("id").toString());
        DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmByMid((String)"tsirm_stdrsm", (Long)stdRsmId);
        String dataStatus = stdRsmDy.getString("datastatus");
        parameter.setCustomParam("datastatus", (Object)dataStatus);
        parameter.setCustomParam("id", stdRsmDy.get("id"));
        String isSimpleStdRsm = (String)args.getFormShowParameter().getCustomParam("isSimpleStdRsm");
        String fullName = stdRsmDy.getString("fullname");
        if (fullName.length() > 8) {
            fullName = fullName.substring(0, 8) + "...";
        }
        if (ResumeHisDataStatusEnum.BLACK_LIST.getStatus().equals(dataStatus) && null == isSimpleStdRsm) {
            args.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u9ed1\u540d\u5355-{0}", (String)"CandidateDetailPagePlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{fullName}));
        } else {
            args.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6807\u51c6\u7b80\u5386-{0}", (String)"CandidateDetailPagePlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{fullName}));
        }
        Long sourceVid = stdRsmDy.getLong("sourcevid");
        parameter.setCustomParam("sourcevid", (Object)sourceVid);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOL_TOOLBARAP, "toolbarap1"});
    }

    public void afterBindData(EventObject e) {
        IFormView view = this.getView();
        ResumeFormHelper.loadPage((IFormView)view, (String)"tsirm_head_template", (String)"flex_head");
        ResumeFormHelper.loadPage((IFormView)view, (String)"tsirm_stdrsm_detail", (String)"tabdetail");
        ResumeFormHelper.loadRightDownPage((IFormView)view);
        this.setVisible();
        this.getView().addClientCallBack(this.getModel().getDataEntityType().getName(), Integer.valueOf(100));
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        if ("tsirm_stdrsm_dimi".equals(formId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"selectposition"});
        }
    }

    private void setVisible() {
        String dataStatus = (String)this.getView().getFormShowParameter().getCustomParam("datastatus");
        String isSimpleStdRsm = (String)this.getView().getFormShowParameter().getCustomParam("isSimpleStdRsm");
        if (null == isSimpleStdRsm) {
            if (ResumeHisDataStatusEnum.EFFECTING.getStatus().equals(dataStatus)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btn_remove_blacklist"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"tabap3", "savetalent", "selectposition", "btn_sendntfc", "btn_invite", "btn_invitedelivery", "btn_share", "attention", "btn_add_blacklist", "bardelete", "flexpanelcard", "rightdown"});
            }
        } else if (StringUtils.equals((CharSequence)"1", (CharSequence)isSimpleStdRsm)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabtalent", "tabemploy", "tabap2", "tabpageap8", "savetalent", "selectposition", "btn_sendntfc", "btn_invite", "btn_invitedelivery", "btn_share", "attention", "btn_add_blacklist", "bardelete", "btn_remove_blacklist", "tabtrail", "tabpageapor"});
        }
    }

    public void clientCallBack(ClientCallBackEvent event) {
        if (this.getModel().getDataEntityType().getName().equals(event.getName())) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            long stdRsmId = (Long)parameter.getCustomParam("id");
            this.loadSubPage();
            ResumeFormHelper.showResumeORForm((IFormView)this.getView(), (Long)stdRsmId);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object stdRsmId = this.getView().getFormShowParameter().getCustomParams().get("id");
        if (stdRsmId == null) {
            return;
        }
        Long stdId = Long.parseLong(stdRsmId.toString());
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("storetotalentpool".equals(operateKey) || "recommendtoposition".equals(operateKey)) {
            if (this.validateParentRight(operateKey, stdId)) {
                args.setCancel(true);
                return;
            }
            this.checkLeaveError(stdId, args);
        }
    }

    private boolean validateParentRight(String operateKey, Long stdId) {
        OperationResult operationResult;
        if (("storetotalentpool".equals(operateKey) || "storetotalentpoolright".equals(operateKey)) && null != (operationResult = OperationServiceHelper.executeOperate((String)"storetotalentpooldetailright", (String)"tsirm_stdrsm", (Object[])new Object[]{stdId}, (OperateOption)OperateOption.create())) && !operationResult.isSuccess()) {
            this.getView().showOperationResult(operationResult);
            return true;
        }
        if (("recommendtoposition".equals(operateKey) || "recommendtopositionright".equals(operateKey)) && null != (operationResult = OperationServiceHelper.executeOperate((String)"recommdtopositiondetailright", (String)"tsirm_stdrsm", (Object[])new Object[]{stdId}, (OperateOption)OperateOption.create())) && !operationResult.isSuccess()) {
            this.getView().showOperationResult(operationResult);
            return true;
        }
        return false;
    }

    private boolean checkLeaveError(Long stdId, BeforeDoOperationEventArgs args) {
        DynamicObject stdDynamic = StandardResumeDataHelper.queryOne((Long)stdId);
        long empid = stdDynamic.getLong("empid");
        ArrayList<Long> empIdList = new ArrayList<Long>();
        empIdList.add(empid);
        Map result = BizHRPIEmployeeService.getEmployeeStatus(empIdList);
        DynamicObject dynamicObject = (DynamicObject)result.get(empid);
        boolean isOutWork = null == dynamicObject || dynamicObject.getLong("labrelstatusprd_id") == Long.parseLong("1020");
        Object formId = this.getView().getFormShowParameter().getCustomParam("formId");
        boolean equals = "tsirm_stdrsm_onjob".equals(formId);
        if (isOutWork && equals) {
            String errorMessage = ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5df2\u79bb\u804c\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"TalentListFunService_15", (String)"tsc-tsirm-business", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMessage);
            if (null != args) {
                args.setCancel(true);
            }
            return true;
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        boolean success = args.getOperationResult().isSuccess();
        if (success && CollectionUtils.isEmpty((Collection)args.getOperationResult().getAllErrorOrValidateInfo())) {
            Optional.ofNullable(CLICK_MAP.get(operateKey)).ifPresent(con -> con.accept(new HashMap(0)));
            if (VIEW_DELIVERY.equals(operateKey)) {
                this.showDelivery();
            }
        }
    }

    private void showDelivery() {
        FormShowParameter childPageParameter = new FormShowParameter();
        childPageParameter.setFormId("tsirm_delivery_record");
        childPageParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        long stdRsmId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        childPageParameter.setCustomParam("id", (Object)stdRsmId);
        childPageParameter.setCustomParam("datastatus", this.getView().getFormShowParameter().getCustomParam("datastatus"));
        long sourceId = (Long)this.getView().getFormShowParameter().getCustomParam("sourcevid");
        childPageParameter.setCustomParam("sourcevid", (Object)sourceId);
        this.getView().showForm(childPageParameter);
        this.getView().getPageCache().put("tsirm_delivery_recordpageid", childPageParameter.getPageId());
    }

    private void loadSubPage() {
        String dataStatus = (String)this.getView().getFormShowParameter().getCustomParam("datastatus");
        String isSimpleStdRsm = (String)this.getView().getFormShowParameter().getCustomParam("isSimpleStdRsm");
        if (null == isSimpleStdRsm && ResumeHisDataStatusEnum.EFFECTING.getStatus().equals(dataStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_remove_blacklist"});
            this.loadCompleteDetailPage();
        }
    }

    private void loadCompleteDetailPage() {
        IFormView view = this.getView();
        ResumeFormHelper.loadPage((IFormView)view, (String)"tsirm_stdrsmhis_record", (String)"tabhis");
        ResumeFormHelper.loadPage((IFormView)view, (String)"tsirm_reserverelist", (String)"tabtalent");
        ResumeFormHelper.loadPage((IFormView)view, (String)"tsirm_applyrecord_list", (String)"applyrecord");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (HRObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "savetalent": {
                this.operateReserveRecord(actionId, returnData);
                this.voidupdatePageView("tsirm_reserverelist");
                break;
            }
            case "selectposition": {
                this.recommend2Position(returnData);
                this.voidupdatePageView("tsirm_applyrecord_list");
                break;
            }
        }
    }

    private void voidupdatePageView(String page) {
        String pageID = this.getPageCache().get(page + "pageid");
        this.getView().getView(pageID).invokeOperation("refresh");
        this.getView().sendFormAction(this.getView().getView(pageID));
    }

    private void recommend2Position(Object returnData) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long stdRsmId = Long.parseLong(parameter.getCustomParam("id").toString());
        ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
        ArrayList<Long> positionIds = new ArrayList<Long>(listSelectedRows.size());
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            Long positionId = (Long)listSelectedRow.getPrimaryKeyValue();
            positionIds.add(positionId);
        }
        ArrayList<Long> candidateIds = new ArrayList<Long>(1);
        candidateIds.add(stdRsmId);
        String oprationCode = "recommendtopositionright";
        if (this.validateParentRight(oprationCode, stdRsmId)) {
            return;
        }
        boolean changeWithDataPermisson = this.isChangeWithDataPermisson(candidateIds);
        if (!changeWithDataPermisson) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u5019\u9009\u4eba\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"CandidateDetailPagePlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.checkLeaveError(stdRsmId, null)) {
            return;
        }
        if (!CertService.getInstance().verifyCertByPid(stdRsmId, this.getView())) {
            return;
        }
        TalentPoolFallMessage talentPoolFallMessage = TalentListFunService.saveAppFile(candidateIds, positionIds);
        if (talentPoolFallMessage.getFlag()) {
            this.getView().showSuccessNotification(talentPoolFallMessage.getTitleMsg());
            return;
        }
        if (HRStringUtils.isEmpty((String)talentPoolFallMessage.getErrorMsgTotal())) {
            this.getView().showErrorNotification(talentPoolFallMessage.getTitleMsg());
            return;
        }
        FormShowParameter formShowParameter = GenerateFormShowParamUtils.generateBosOperationResultFormShowParam((Object)talentPoolFallMessage.getTitleMsg(), (Object)talentPoolFallMessage.getErrorMsgTotal(), (boolean)false);
        this.getView().showForm(formShowParameter);
    }

    private void operateReserveRecord(String actionId, Object returnData) {
        if (!"savetalent".equals(actionId)) {
            return;
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long stdRsmId = Long.parseLong(parameter.getCustomParam("id").toString());
        ArrayList<Long> candidateIds = new ArrayList<Long>(1);
        candidateIds.add(stdRsmId);
        ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
        ArrayList<Long> talentPoolIds = new ArrayList<Long>(listSelectedRows.size());
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            Long talentPoolId = (Long)listSelectedRow.getPrimaryKeyValue();
            talentPoolIds.add(talentPoolId);
        }
        String oprationCode = "storetotalentpoolright";
        if (this.validateParentRight(oprationCode, stdRsmId)) {
            return;
        }
        boolean changeWithDataPermisson = this.isChangeWithDataPermisson(candidateIds);
        if (!changeWithDataPermisson) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u5019\u9009\u4eba\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"CandidateDetailPagePlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return;
        }
        List notExistsIds = TalentPoolMgtHelper.getInstance().getNotExistsIds(talentPoolIds);
        if (notExistsIds.size() == talentPoolIds.size()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u4eba\u624d\u5e93\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TALENTLIST_22", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] addReserveDtArrays = TalentListFunService.saveReserveRecord(talentPoolIds, candidateIds);
        if (HRArrayUtils.isEmpty((Object[])addReserveDtArrays)) {
            return;
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("formId", (String)this.getView().getFormShowParameter().getCustomParam("formId"));
        OperationResult addOperationResult = SaveServiceHelper.saveOperate((String)"save", (String)"tsirm_reservere", (DynamicObject[])addReserveDtArrays, (OperateOption)operateOption);
        StandardResumeDataHelper.updateStdRsmTalentPool(candidateIds);
        int totalCount = talentPoolIds.size() * candidateIds.size();
        int errorCount = addOperationResult.getValidateResult().errorSize();
        if (totalCount > 1) {
            if (errorCount > 0 || !notExistsIds.isEmpty()) {
                Map returnMap = TalentListFunService.showReserveRecordMessageTalentPool((DynamicObject[])addReserveDtArrays, (OperationResult)addOperationResult, talentPoolIds, (List)notExistsIds, candidateIds);
                if (returnMap.isEmpty()) {
                    return;
                }
                this.getView().showForm(GenerateFormShowParamUtils.generateBosOperationResultFormShowParam(returnMap.get("titleMsg"), returnMap.get("errorMsgTotal"), (boolean)false));
            } else {
                TalentListFunService.showPageNotification((IFormView)this.getView(), (boolean)true, (String)"savetalent");
            }
        } else {
            boolean isDimi = false;
            String dimiMessage = "";
            if (errorCount == 1) {
                String errorMessage = ((IOperateInfo)addOperationResult.getAllErrorOrValidateInfo().get(0)).getMessage();
                dimiMessage = ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5df2\u79bb\u804c\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"TalentListFunService_15", (String)"tsc-tsirm-business", (Object[])new Object[0]);
                if (dimiMessage.equals(errorMessage)) {
                    isDimi = true;
                }
            }
            if (isDimi) {
                this.getView().showErrorNotification(dimiMessage);
            } else {
                TalentListFunService.showPageNotification((IFormView)this.getView(), (errorCount <= 0 ? 1 : 0) != 0, (String)"savetalent");
            }
        }
        StandardResumeDataHelper.updateModifyTime(candidateIds);
        if (errorCount <= 0) {
            String formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
            Long allocatedTPId = 0L;
            if ("tsirm_stdrsm_onjob".equals(formId)) {
                allocatedTPId = TSTPMTalentPoolConstants.ON_JOB_TP_ALLOCATED;
            } else if ("tsirm_stdrsm_dimi".equals(formId)) {
                allocatedTPId = TSTPMTalentPoolConstants.DIMI_TP_ALLOCATED;
            }
            ArrayList<Long> unClassifiedCTalentPools = new ArrayList<Long>(1);
            unClassifiedCTalentPools.add(allocatedTPId);
            TalentListFunService.removeReserveRecord(unClassifiedCTalentPools, candidateIds);
        }
        TalentPoolOperateRecordService.getInstance().reserveOpRecord((DynamicObject[])addReserveDtArrays, addOperationResult);
    }

    private void judgeIsEjectTips(String key) {
        Object stdRsmId = this.getView().getFormShowParameter().getCustomParams().get("id");
        if (stdRsmId == null) {
            return;
        }
        Long stdId = Long.parseLong(stdRsmId.toString());
        ArrayList<Long> candidateIds = new ArrayList<Long>(1);
        candidateIds.add(stdId);
        switch (key) {
            case "storetotalentpool": {
                String btnName = ResManager.loadKDString((String)"\u50a8\u5907\u5230\u4eba\u624d\u5e93", (String)"CandidateDetailPagePlugin_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                this.selectTalentPool();
                break;
            }
            case "recommendtoposition": {
                String btnName = ResManager.loadKDString((String)"\u63a8\u8350\u5230\u804c\u4f4d", (String)"CandidateDetailPagePlugin_5", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                if (!this.setPromptInfo(key, candidateIds, btnName) || !CertService.getInstance().verifyCertByPid(stdId, this.getView())) break;
                this.selectPositions();
                break;
            }
        }
    }

    private boolean setPromptInfo(String key, List<Long> candidateIds, String btnName) {
        String pageNumber = "tsirm_stdrsm";
        List checkButtonIds = CheckPermissionHelper.getInstance().getCurTalentAuth(key, candidateIds, pageNumber);
        if (checkButtonIds.isEmpty()) {
            String message = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709{0}\u7684\u6743\u9650", (String)"CandidateDetailPagePlugin_8", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{btnName});
            this.getView().showErrorNotification(message);
            return false;
        }
        return true;
    }

    private void selectTalentPool() {
        ListShowParameter listShowParameter = new ListShowParameter();
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        if ("tsirm_stdrsm_onjob".equals(formId)) {
            listShowParameter.setBillFormId("tsirm_talentpoolmgt_onjob");
            listShowParameter.setCustomParam("formId", (Object)"tsirm_talentpoolmgt_onjob");
        } else if ("tsirm_stdrsm_dimi".equals(formId)) {
            listShowParameter.setBillFormId("tsirm_talentpoolmgt_dimi");
            listShowParameter.setCustomParam("formId", (Object)"tsirm_talentpoolmgt_dimi");
        }
        listShowParameter.setFormId("tsirm_talenttreelistf7");
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u50a8\u5907\u5230\u4eba\u624d\u5e93", (String)"CandidateDetailPagePlugin_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        listShowParameter.getOpenStyle().setInlineStyleCss(css);
        listShowParameter.setMultiSelect(true);
        listShowParameter.setShowTitle(false);
        listShowParameter.setLookUp(true);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "savetalent"));
        listShowParameter.setCustomParam("pageNumber", (Object)"tsirm_stdrsm");
        listShowParameter.setCustomParam("permissionItem", (Object)"1Y+/5TTR4HPX");
        listShowParameter.setHasRight(Boolean.TRUE.booleanValue());
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void selectPositions() {
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        ListShowParameter positionListShow = new ListShowParameter();
        positionListShow.setBillFormId("tsirm_position_f7view");
        positionListShow.setFormId("tsirm_positionlistf7");
        positionListShow.getOpenStyle().setInlineStyleCss(css);
        positionListShow.setMultiSelect(true);
        positionListShow.setShowTitle(false);
        positionListShow.setLookUp(true);
        QFilter statusFilter = new QFilter("positionstatus", "in", (Object)new String[]{"A", "C"});
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
        qFilterList.add(statusFilter);
        positionListShow.getListFilterParameter().setQFilters(qFilterList);
        positionListShow.getOpenStyle().setShowType(ShowType.Modal);
        positionListShow.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectposition"));
        this.getView().showForm((FormShowParameter)positionListShow);
    }

    private boolean isChangeWithDataPermisson(List<Long> stdRsmIdList) {
        Map longBooleanMap = StdRsmCommonService.getInstance().queryStdRsmViewPermission(stdRsmIdList);
        AtomicBoolean isChange = new AtomicBoolean(false);
        longBooleanMap.forEach((key, value) -> {
            if (value.booleanValue()) {
                isChange.set(true);
            }
        });
        return isChange.get();
    }
}

