/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.stdrsm.bill;

import java.util.EventObject;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.BeforeUploadEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsirm.business.domain.rsm.common.mservice.AppFileMService;
import kd.tsc.tsirm.business.domain.stdrsm.detail.PreviewResumeHeaderService;
import kd.tsc.tsirm.business.domain.stdrsm.detail.StdRsmHeadService;
import kd.tsc.tsirm.business.domain.stdrsm.detail.UnAllocateRsmHeaderService;
import kd.tsc.tsirm.business.domain.stdrsm.helper.ResumeValidateHelper;
import kd.tsc.tsirm.common.enums.MainPageTypeEnum;
import kd.tsc.tsrbd.business.domain.headtemplate.HeaderService;
import kd.tsc.tsrbd.common.utils.PageUtils;
import org.apache.commons.lang3.StringUtils;

public class HeadTemplatePlugin
extends HRDynamicFormBasePlugin
implements UploadListener {
    private HeaderService headService = null;

    public void registerListener(EventObject e) {
        this.initHeadService();
        Image candPic = (Image)this.getControl("photo");
        candPic.addUploadListener((UploadListener)this);
        this.addClickListeners(this.headService.getClickListeners().toArray(new String[0]));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.FALSE, this.headService.getHideItemList(this.getView()).toArray(new String[0]));
    }

    public void afterCreateNewData(EventObject e) {
        this.initHeadService();
        this.headService.initData(this.getView());
    }

    public void click(EventObject evt) {
        if (!this.checkStdRsmDataStatus(this.getView())) {
            return;
        }
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        this.initHeadService();
        this.headService.click(this.getView(), key);
    }

    public void beforeUpload(BeforeUploadEvent evt) {
        if (!this.checkStdRsmDataStatus(this.getView())) {
            return;
        }
    }

    public void afterUpload(UploadEvent evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)"photo", (CharSequence)key)) {
            Image candPic = (Image)control;
            if (evt.getUrls().length > 0) {
                String url = (String)evt.getUrls()[0];
                this.initHeadService();
                Long objId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
                this.headService.savePhoto((Object)objId, url);
                candPic.setUrl(HRImageUrlUtil.getImageFullUrl((String)url));
            }
        }
    }

    private void initHeadService() {
        String headServiceString = this.getPageCache().get("HeaderService");
        if (headServiceString == null) {
            String pageType = (String)this.getView().getFormShowParameter().getCustomParam("page_type");
            if (MainPageTypeEnum.APP_FILE.getType().equals(pageType)) {
                this.headService = AppFileMService.getAppFileHeaderService((String)pageType);
            } else if (MainPageTypeEnum.STD_RSM.getType().equals(pageType)) {
                this.headService = new StdRsmHeadService();
            } else if (MainPageTypeEnum.PREVIEW_RSM.getType().equals(pageType)) {
                this.headService = new PreviewResumeHeaderService();
            } else if (MainPageTypeEnum.UN_ALLOCATE.getType().equals(pageType)) {
                this.headService = new UnAllocateRsmHeaderService();
            }
            this.getView().getFormShowParameter().setCustomParam("HeaderService", (Object)this.headService);
        } else {
            this.headService = (HeaderService)this.getView().getFormShowParameter().getCustomParam("HeaderService");
        }
    }

    private boolean checkStdRsmDataStatus(IFormView view) {
        if (StringUtils.equals((CharSequence)"tsirm_candidate_detail", (CharSequence)view.getFormShowParameter().getFormId())) {
            String dataStatus = (String)view.getFormShowParameter().getCustomParam("datastatus");
            long stdRsmId = (Long)view.getFormShowParameter().getCustomParam("id");
            String validate = ResumeValidateHelper.validateResumeDetailStatus((Long)stdRsmId, (String)dataStatus);
            if (HRStringUtils.isNotEmpty((String)validate)) {
                PageUtils.showErrorNotificationAndClosePage((IFormView)view.getMainView(), (IFormView)view, (IFormView)view, (String)validate);
                return false;
            }
        }
        return true;
    }
}

