/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.stdrsm.bill;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsirm.business.domain.stdrsm.helper.SimilarServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tsirm.business.domain.stdrsm.sendmessage.pojo.Recipient;
import kd.tsc.tsirm.business.domain.stdrsm.sendmessage.service.ISendMessage;
import kd.tsc.tsirm.business.domain.stdrsm.sendmessage.service.SendMessageFactory;
import kd.tsc.tsirm.common.enums.stdrsm.MsgSceneEnum;
import kd.tsc.tsirm.common.util.talentpool.ViewUtils;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMsgFormService;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMsgTemplateHelper;
import kd.tsc.tsrbd.common.constants.CfgMsgTemplateConstants;
import kd.tsc.tsrbd.common.enums.CfmMsgChannel;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeUtilsHelper;
import org.apache.commons.lang3.StringUtils;

public class SendMessagePlugin
extends HRDynamicFormBasePlugin {
    private boolean isConfirmClose = false;
    public static final String NEED_CHECK_YZJ_SCENES = "ABC";
    public static final String NEED_CHECK_EMAIL_SCENES = "BC";
    private static final String SHARE_RECIPIENTS = "mulbasedatafield";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterBindData(EventObject e) {
        this.loadPage();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        MsgSceneEnum msgSceneEnum = MsgSceneEnum.valueOf((String)((String)this.getView().getFormShowParameter().getCustomParams().get("cfgMsgScene")));
        if ("btn_send".equals(itemKey)) {
            IFormView recipientView;
            DynamicObjectCollection collection;
            if (HRStringUtils.equals((String)"C", (String)msgSceneEnum.getValue()) && (collection = (DynamicObjectCollection)(recipientView = this.getView().getView(this.getView().getPageCache().get("tsirm_recipients"))).getModel().getValue(SHARE_RECIPIENTS)).size() == 0) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5206\u4eab\u6536\u4ef6\u4eba\u201d\u3002", (String)"SendMessagePlugin_10", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                recipientView.showFieldTip(ResumeUtilsHelper.createFieldTip((String)ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"SendMessagePlugin_11", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), (String)SHARE_RECIPIENTS));
                this.getView().sendFormAction(recipientView);
            }
            if (StringUtils.equals((CharSequence)"D", (CharSequence)msgSceneEnum.getValue())) {
                this.doCheckInviteDelivery(evt);
            } else {
                if (NEED_CHECK_YZJ_SCENES.contains(msgSceneEnum.getValue()) && !this.checkYZJ(evt)) {
                    return;
                }
                if (NEED_CHECK_EMAIL_SCENES.contains(msgSceneEnum.getValue())) {
                    this.checkEmail(evt);
                }
            }
            this.checkChannelEnable(evt);
        }
    }

    private void checkChannelEnable(BeforeItemClickEvent evt) {
        IFormView msgIntegrateView = this.getView().getView(this.getPageCache().get("cfgmsgintegrate_pageid"));
        String msgChannelStr = msgIntegrateView.getModel().getDataEntity().getString("msgchannellist");
        if (msgChannelStr == null || msgChannelStr.isEmpty()) {
            return;
        }
        String[] msgChannels = msgChannelStr.split(",");
        Map channelEnableMap = Maps.newHashMapWithExpectedSize((int)1);
        if (msgChannels.length > 0) {
            List msgChannelIdList = Arrays.stream(msgChannels).filter(msgChannel -> !msgChannel.isEmpty()).map(Long::parseLong).collect(Collectors.toList());
            channelEnableMap = CfgMsgTemplateHelper.batchQueryChannelEnable(msgChannelIdList);
        }
        StringBuilder disabledChannelNameSB = new StringBuilder();
        for (Map.Entry entry : channelEnableMap.entrySet()) {
            Long channelId = (Long)entry.getKey();
            Boolean enable = (Boolean)entry.getValue();
            if (enable.booleanValue()) continue;
            String channelName = CfmMsgChannel.getNameByChannelId((Long)channelId);
            if (disabledChannelNameSB.length() < 1) {
                disabledChannelNameSB.append(channelName);
                continue;
            }
            disabledChannelNameSB.append('\u3001');
            disabledChannelNameSB.append(channelName);
        }
        if (disabledChannelNameSB.length() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u901a\u77e5\u65b9\u5f0f{0}\u5df2\u7981\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SendMessagePlugin_9", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{disabledChannelNameSB.toString()}));
            evt.setCancel(true);
        }
    }

    private void doCheckInviteDelivery(BeforeItemClickEvent evt) {
        if (!this.checkFieldValue(evt)) {
            evt.setCancel(true);
            return;
        }
        this.checkSimilar(evt);
    }

    private boolean checkYZJ(BeforeItemClickEvent evt) {
        IFormView msgIntegrateView = this.getView().getView(this.getPageCache().get("cfgmsgintegrate_pageid"));
        boolean validMsgChannel = CfgMsgFormService.validMsgChannelContainsYZJ((IFormView)msgIntegrateView);
        if (validMsgChannel) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u901a\u77e5\u65b9\u5f0f\u201d\u3002", (String)"SendMessagePlugin_12", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkEmail(BeforeItemClickEvent evt) {
        IFormView msgIntegrateView = this.getView().getView(this.getPageCache().get("cfgmsgintegrate_pageid"));
        boolean validMsgChannel = CfgMsgFormService.validMsgChannel((IFormView)msgIntegrateView);
        if (validMsgChannel) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u901a\u77e5\u65b9\u5f0f\u201d\u3002", (String)"SendMessagePlugin_12", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void checkSimilar(BeforeItemClickEvent evt) {
        IFormView recipientView = this.getView().getView(this.getView().getPageCache().get("tsirm_recipients"));
        List recipientList = JSON.parseArray((String)recipientView.getPageCache().get("recipients"), Recipient.class);
        List stdRsmIdList = recipientList.stream().map(recipient -> recipient.getId()).collect(Collectors.toList());
        Map stdRsmMap = StandardResumeDataHelper.batchQueryStdRsmToMap(stdRsmIdList);
        Map similarListEachOther = SimilarServiceHelper.querySimilarListEachOther(stdRsmIdList);
        String title = ResManager.loadKDString((String)"\u4ee5\u4e0b\u4e3a\u7591\u4f3c\u5019\u9009\u4eba\uff0c\u53d1\u9001\u540e\u53ef\u80fd\u4f1a\u9020\u6210\u91cd\u590d\u9080\u8bf7\uff0c\u662f\u5426\u7ee7\u7eed\u53d1\u9001\uff1f", (String)"SendMessagePlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
        String msgDetailTitle = ResManager.loadKDString((String)"\u4e92\u4e3a\u7591\u4f3c\u5019\u9009\u4eba", (String)"SendMessagePlugin_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
        ArrayList msgDetailList = Lists.newArrayListWithExpectedSize((int)(stdRsmMap.size() * 2));
        for (Map.Entry entry : similarListEachOther.entrySet()) {
            msgDetailList.add(msgDetailTitle + ":");
            Long key = (Long)entry.getKey();
            List value = (List)entry.getValue();
            value.add(0, key);
            StringBuilder similarMsg = new StringBuilder();
            for (int i = 0; i < value.size(); ++i) {
                DynamicObject stdRsm = (DynamicObject)stdRsmMap.get(value.get(i));
                String name = stdRsm.getString("fullname");
                String number = stdRsm.getString("number");
                similarMsg.append(name).append('(').append(number).append(')');
                if (i == value.size() - 1) {
                    similarMsg.append('\uff1b');
                    continue;
                }
                similarMsg.append('\u3001');
            }
            msgDetailList.add(similarMsg.toString());
        }
        if (!similarListEachOther.isEmpty()) {
            evt.setCancel(true);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "similarbox");
            ViewUtils.openOptionBox((IFormView)this.getView(), (CloseCallBack)closeCallBack, (String)title, (List)msgDetailList, (MessageBoxOptions)MessageBoxOptions.OKCancel);
        }
    }

    private boolean checkFieldValue(BeforeItemClickEvent evt) {
        IFormView recipientView = this.getView().getView(this.getView().getPageCache().get("tsirm_recipients"));
        String position = (String)recipientView.getModel().getValue("addposition");
        if (StringUtils.isEmpty((CharSequence)position)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6dfb\u52a0\u804c\u4f4d\u201d\u3002", (String)"SendMessagePlugin_13", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            recipientView.showFieldTip(ResumeUtilsHelper.createFieldTip((String)ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"SendMessagePlugin_14", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), (String)"addposition"));
            this.getView().sendFormAction(recipientView);
            return false;
        }
        if (!this.checkYZJ(evt)) {
            return false;
        }
        return this.checkEmail(evt);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)"btn_send", (CharSequence)itemKey)) {
            this.sendMessage();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (StringUtils.equals((CharSequence)"similarbox", (CharSequence)actionId)) {
            if (null != returnData) {
                this.sendMessage();
            }
        } else if (StringUtils.equals((CharSequence)"inprocessbox", (CharSequence)actionId)) {
            this.isConfirmClose = true;
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (this.isConfirmClose) {
            return;
        }
        String msgTemplatePageId = this.getPageCache().get("cfgmsgintegrate_pageid");
        String recipientsPageId = this.getPageCache().get("tsirm_recipients");
        IDataModel recipientsModel = this.getView().getView(recipientsPageId).getModel();
        IDataModel msgTemplateModel = this.getView().getView(msgTemplatePageId).getModel();
        boolean recipientsDataChanged = recipientsModel.getDataChanged();
        boolean msgTemplateDataChanged = msgTemplateModel.getDataChanged();
        String msgDetail = "";
        StringBuilder changeDescRecipientView = new StringBuilder();
        if (recipientsDataChanged) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            MsgSceneEnum msgSceneEnum = MsgSceneEnum.valueOf((String)((String)customParams.get("cfgMsgScene")));
            String changedFields = this.getView().getView(recipientsPageId).getPageCache().get("datachangedfields");
            if (changedFields.contains("candidate")) {
                changeDescRecipientView.append('\uff1a').append(msgSceneEnum.getCandidateFlexName().loadKDString().replace("(%s)", ""));
            }
            if (changedFields.contains("addposition")) {
                if (changeDescRecipientView.length() > 0) {
                    changeDescRecipientView.append('\uff0c');
                } else {
                    changeDescRecipientView.append('\uff1a');
                }
                changeDescRecipientView.append(recipientsModel.getProperty("addposition").getDisplayName());
            }
        }
        if (recipientsDataChanged && msgTemplateDataChanged) {
            changeDescRecipientView.append('\uff0c');
            msgDetail = msgTemplateModel.getChangeDesc().replaceAll("\uff1a", changeDescRecipientView.toString());
        } else if (recipientsDataChanged && !msgTemplateDataChanged) {
            changeDescRecipientView.insert(0, ResManager.loadKDString((String)"\u5355\u636e\u5934\u53d8\u52a8\u5b57\u6bb5", (String)"SendMessagePlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            msgDetail = changeDescRecipientView.toString();
        } else if (!recipientsDataChanged && msgTemplateDataChanged) {
            msgDetail = msgTemplateModel.getChangeDesc();
        }
        if (StringUtils.isNotEmpty((CharSequence)msgDetail)) {
            e.setCancel(true);
            this.showDataChangedConfirm(msgDetail);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        String resultValue = messageBoxClosedEvent.getResultValue();
        if (StringUtils.equals((CharSequence)"datachanged", (CharSequence)callBackId)) {
            if (StringUtils.equals((CharSequence)"Yes", (CharSequence)resultValue)) {
                this.isConfirmClose = true;
                this.getView().close();
            }
        } else if (StringUtils.equals((CharSequence)"resultMsg", (CharSequence)callBackId) && StringUtils.equals((CharSequence)"Cancel", (CharSequence)resultValue)) {
            this.isConfirmClose = true;
            this.getView().close();
        }
    }

    private void sendMessage() {
        ISendMessage sendMessage = (ISendMessage)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("isendmessage"));
        MsgSceneEnum msgSceneEnum = MsgSceneEnum.valueOf((String)((String)this.getView().getFormShowParameter().getCustomParams().get("cfgMsgScene")));
        boolean sendSuccess = sendMessage.send(this.getView());
        if (sendSuccess) {
            this.updateStdRsmActivationInfo(msgSceneEnum);
            IFormView msgIntegrateView = this.getView().getView(this.getPageCache().get("cfgmsgintegrate_pageid"));
            String sendRecentlyIds = msgIntegrateView.getPageCache().get("sendRecently");
            String inProcessMsgTitle = this.getView().getPageCache().get("inProcessMsgTitle");
            if (null != inProcessMsgTitle || StringUtils.isNotEmpty((CharSequence)sendRecentlyIds)) {
                this.showInProcessMsgBox(inProcessMsgTitle, sendRecentlyIds);
            } else {
                IFormView parentView = this.getView().getParentView();
                parentView.showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u9001\u6210\u529f", (String)"SendMessagePlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                this.isConfirmClose = true;
                this.getView().sendFormAction(parentView);
                this.getView().close();
            }
        }
    }

    private void updateStdRsmActivationInfo(MsgSceneEnum msgSceneEnum) {
        String recipientsPageId = this.getView().getPageCache().get("tsirm_recipients");
        IFormView recipientsView = this.getView().getView(recipientsPageId);
        List recipientList = JSON.parseArray((String)recipientsView.getPageCache().get("recipients"), Recipient.class);
        List stdRsmIds = recipientList.stream().map(recipient -> recipient.getId()).distinct().collect(Collectors.toList());
        StandardResumeDataHelper.updateStdRsmActivationInfo((String)msgSceneEnum.getBtnNum(), stdRsmIds);
    }

    private void showInProcessMsgBox(String inProcessMsgTitle, String sendRecentlyIds) {
        String inProcessMsgDetailTitle2 = ResManager.loadKDString((String)"\u4ee5\u4e0b\u6536\u4ef6\u4eba\u5bf9\u5e94\u7684\u804c\u4f4d\uff0c\u62db\u8058\u8fdb\u884c\u4e2d\u6216\u88ab\u6dd8\u6c70", (String)"SendMessagePlugin_6", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
        String inProcessMsgDetailTitle3 = ResManager.loadKDString((String)"1min\u5185\u8bf7\u52ff\u91cd\u590d\u53d1\u9001\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"SendMessagePlugin_7", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
        String inProcessMsgDetail = this.getView().getPageCache().get("inProcessMsgDetail");
        String msgTitle = "";
        ArrayList msgDetaiList = Lists.newArrayListWithExpectedSize((int)5);
        msgDetaiList.add(ResManager.loadKDString((String)"\u53d1\u9001\u5931\u8d25\u539f\u56e0", (String)"SendMessagePlugin_5", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        String title = ResManager.loadKDString((String)"\u5171\u53d1\u9001%s\u4e2a\u5019\u9009\u4eba\uff0c\u53d1\u9001\u6210\u529f%s\u6761\uff0c\u53d1\u9001\u5931\u8d25%s\u6761\u3002", (String)"SendMessagePlugin_8", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
        int totalNum = Integer.parseInt(this.getView().getPageCache().get("totalNum"));
        if (null != inProcessMsgTitle && StringUtils.isNotEmpty((CharSequence)sendRecentlyIds)) {
            int inProcessNum = Integer.parseInt(this.getView().getPageCache().get("inProcessNum"));
            String[] split = sendRecentlyIds.split(",");
            int length = split.length;
            msgTitle = String.format(title, totalNum, totalNum - (inProcessNum + length), inProcessNum + length);
            msgDetaiList.add(inProcessMsgDetailTitle2);
            msgDetaiList.add(inProcessMsgDetail);
            msgDetaiList.add(inProcessMsgDetailTitle3);
            msgDetaiList.add(this.getSendRecentlyMsgDetail(sendRecentlyIds));
        } else if (null != inProcessMsgTitle) {
            int inProcessNum = Integer.parseInt(this.getView().getPageCache().get("inProcessNum"));
            msgTitle = String.format(title, totalNum, totalNum - inProcessNum, inProcessNum);
            msgDetaiList.add(inProcessMsgDetailTitle2);
            msgDetaiList.add(inProcessMsgDetail);
        } else if (StringUtils.isNotEmpty((CharSequence)sendRecentlyIds)) {
            String[] split = sendRecentlyIds.split(",");
            int length = split.length;
            msgTitle = String.format(title, totalNum, totalNum - length, length);
            msgDetaiList.add(inProcessMsgDetailTitle3);
            msgDetaiList.add(this.getSendRecentlyMsgDetail(sendRecentlyIds));
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "inprocessbox");
        ViewUtils.openOptionBox((IFormView)this.getView(), (CloseCallBack)closeCallBack, (String)msgTitle, (List)msgDetaiList, (MessageBoxOptions)MessageBoxOptions.OK);
    }

    private String getSendRecentlyMsgDetail(String sendRecentlyIds) {
        String[] sendRecentlyIdArray = sendRecentlyIds.split(",");
        ArrayList sendRecentlyIdList = Lists.newArrayListWithCapacity((int)sendRecentlyIdArray.length);
        for (String sendRecentlyId : sendRecentlyIdArray) {
            sendRecentlyIdList.add(Long.valueOf(sendRecentlyId));
        }
        Map stdRsmMap = StandardResumeDataHelper.batchQueryStdRsmToMap((List)sendRecentlyIdList);
        StringBuilder msgDetail = new StringBuilder();
        for (int i = 0; i < sendRecentlyIdList.size(); ++i) {
            DynamicObject stdRsm = (DynamicObject)stdRsmMap.get(sendRecentlyIdList.get(i));
            String name = stdRsm.getString("fullname");
            String number = stdRsm.getString("number");
            msgDetail.append(name).append('(').append(number).append(')');
            if (i == sendRecentlyIdList.size() - 1) {
                msgDetail.append('\u3002');
                continue;
            }
            msgDetail.append('\u3001');
        }
        return msgDetail.toString();
    }

    private void loadPage() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        MsgSceneEnum msgSceneEnum = MsgSceneEnum.valueOf((String)((String)customParams.get("cfgMsgScene")));
        List stdRsmIdList = (List)customParams.get("stdRsmIdList");
        ArrayList stdRsmList = Lists.newArrayListWithCapacity((int)stdRsmIdList.size());
        DynamicObject[] dysTemp = StandardResumeDataHelper.batchQuerySelectFieldsyById((List)stdRsmIdList, (String)"fullname, phone, photo, email");
        stdRsmIdList.forEach(stdRsmId -> Arrays.stream(dysTemp).filter(dynamicObject -> stdRsmId.longValue() == dynamicObject.getLong("id")).forEach(dynamicObject -> stdRsmList.add(dynamicObject)));
        this.loadRecipientsPage(stdRsmList, msgSceneEnum);
        this.loadMessageTempatePage(msgSceneEnum);
    }

    private void loadRecipientsPage(List<DynamicObject> stdRsmList, MsgSceneEnum msgSceneEnum) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("flexpanelap");
        formShowParameter.setFormId(msgSceneEnum.getRecipientFormId());
        ArrayList recipientList = Lists.newArrayListWithExpectedSize((int)stdRsmList.size());
        stdRsmList.forEach(dynamicObject -> this.createRecipient(recipientList, (DynamicObject)dynamicObject));
        this.getPageCache().put("recipients", JSON.toJSONString((Object)recipientList));
        formShowParameter.setCustomParam("recipients", (Object)recipientList);
        this.getView().getPageCache().put("tsirm_recipients", formShowParameter.getPageId());
        this.getView().showForm(formShowParameter);
    }

    private void createRecipient(List<Recipient> recipientList, DynamicObject dynamicObject) {
        String name = dynamicObject.getString("fullname");
        Long id = dynamicObject.getLong("id");
        String photo = dynamicObject.getString("photo");
        String phone = dynamicObject.getString("phone");
        String email = dynamicObject.getString("email");
        recipientList.add(new Recipient(photo, name, id.longValue(), phone, email));
    }

    private void loadMessageTempatePage(MsgSceneEnum msgSceneEnum) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("flexpanelap1");
        formShowParameter.setFormId(CfgMsgTemplateConstants.MSG_TEMPLATE_INTEGRATE);
        ISendMessage sendMessage = SendMessageFactory.createMsgScene((MsgSceneEnum)msgSceneEnum);
        this.getPageCache().put("isendmessage", SerializationUtils.serializeToBase64((Object)sendMessage));
        Map paramMap = sendMessage.setParam(this.getView());
        formShowParameter.setCustomParams(paramMap);
        String pageId = formShowParameter.getPageId();
        this.getPageCache().put("cfgmsgintegrate_pageid", pageId);
        this.getView().showForm(formShowParameter);
    }

    private void showDataChangedConfirm(String msgDetail) {
        HashMap btnNameMaps = Maps.newHashMapWithExpectedSize((int)2);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"BillView_0", (String)"bos-form-mvc", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"BillView_1", (String)"bos-form-mvc", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("datachanged", (IFormPlugin)this);
        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f{0}\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SendMessagePlugin_15", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{"\r\n"});
        this.getView().showConfirm(msg, msgDetail, options, ConfirmTypes.Save, confirmCallBacks, (Map)btnNameMaps);
    }
}

