/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.stdrsm.bill;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tsirm.common.util.talentpool.TalentPoolDeseUtil;

public class ShareCandidatesEdit
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    private static final String SHARE_RECIPIENTS = "mulbasedatafield";
    private static final String SHARE_MARK = "textareafield";
    private static final String SHARE_CALLBACK = "userListCloseCallBack";

    public void afterCreateNewData(EventObject e) {
        this.getModel().getValue(SHARE_RECIPIENTS);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit userEdit = (MulBasedataEdit)this.getView().getControl(SHARE_RECIPIENTS);
        userEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (HRStringUtils.equals((String)name, (String)SHARE_MARK)) {
            String str = this.getView().getParentView().getPageCache().get("cfgmsgintegrate_pageid");
            IFormView view = this.getView().getView(str);
            view.getFormShowParameter().setCustomParam("sharemark", changeData.getNewValue());
            view.cacheFormShowParameter();
        }
        if (HRStringUtils.equals((String)name, (String)SHARE_RECIPIENTS)) {
            DynamicObjectCollection collection = (DynamicObjectCollection)this.getModel().getValue(SHARE_RECIPIENTS);
            String str = this.getView().getParentView().getPageCache().get("cfgmsgintegrate_pageid");
            IFormView view = this.getView().getView(str);
            FormShowParameter msgTplParameter = view.getFormShowParameter();
            if (collection.isEmpty()) {
                msgTplParameter.setCustomParam("receivername", (Object)ResManager.loadKDString((String)"{\u5206\u4eab\u6536\u4ef6\u4eba\u59d3\u540d}", (String)"ShareCandidatesEdit_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            } else {
                msgTplParameter.setCustomParam("receivername", (Object)((DynamicObject)collection.get(0)).getDynamicObject("fbasedataid").getString("name"));
                String email = ((DynamicObject)collection.get(0)).getDynamicObject("fbasedataid").getString("email");
                msgTplParameter.setCustomParam("receiveremail", (Object)TalentPoolDeseUtil.replaceEmailX((String)email));
            }
            view.cacheFormShowParameter();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter formShowPatameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if ("bos_usertreelistf7".equals(formShowPatameter.getFormId())) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SHARE_CALLBACK);
            formShowPatameter.setCloseCallBack(closeCallBack);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)SHARE_CALLBACK)) {
            ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (listSelectedRows == null || listSelectedRows.isEmpty()) {
                return;
            }
            if (listSelectedRows.size() > 10) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u900910\u4e2a\u6536\u4ef6\u4eba", (String)"ShareCandidatesEdit_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<Long> userIds = new ArrayList<Long>();
            for (ListSelectedRow listSelectedRow : listSelectedRows) {
                long userFid = (Long)listSelectedRow.getPrimaryKeyValue();
                userIds.add(userFid);
            }
            DynamicObject[] dynamicObjects = StandardResumeDataHelper.queryBosUserByQFilter(userIds);
            ArrayList stdRsmList = Lists.newArrayListWithCapacity((int)userIds.size());
            userIds.forEach(stdRsmId -> Arrays.stream(dynamicObjects).filter(dynamicObject -> stdRsmId.longValue() == dynamicObject.getLong("id")).forEach(stdRsmList::add));
            String str = this.getView().getParentView().getPageCache().get("cfgmsgintegrate_pageid");
            IFormView view = this.getView().getView(str);
            FormShowParameter msgTplParameter = view.getFormShowParameter();
            msgTplParameter.setCustomParam("receivername", (Object)((DynamicObject)stdRsmList.get(0)).getString("name"));
            String email = ((DynamicObject)stdRsmList.get(0)).getString("email");
            msgTplParameter.setCustomParam("receiveremail", (Object)TalentPoolDeseUtil.replaceEmailX((String)email));
            view.cacheFormShowParameter();
            DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
            Collections.addAll(dynamicObjectCollection, dynamicObjects);
            this.getModel().setValue(SHARE_RECIPIENTS, (Object)dynamicObjectCollection);
        }
    }
}

