/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.stdrsm.bill;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tsirm.business.domain.stdrsm.enums.ModelType;
import kd.tsc.tsirm.business.domain.stdrsm.factory.RsmPrototypeFactory;
import kd.tsc.tsirm.business.domain.stdrsm.helper.ResumeValidateHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmBusiAppHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmDetailHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.resume.IResumeService;
import kd.tsc.tsirm.business.domain.stdrsm.util.ResumeUtil;
import kd.tsc.tsirm.common.util.talentpool.ViewUtils;
import kd.tsc.tsrbd.business.domain.label.service.LabelDataHelper;
import kd.tsc.tsrbd.common.entity.label.AiInsightParamEntity;
import kd.tsc.tsrbd.common.enums.LabelTagObjTypeEnum;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tsrbd.common.utils.PageUtils;
import kd.tsc.tsrbd.common.utils.ResumeDyUtil;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeUtilsHelper;
import org.apache.commons.lang3.StringUtils;

public class StdRsmDetailPlugin
extends HRCoreBaseBillEdit {
    private static final List<String> CHECK_FIELDS = ImmutableList.of((Object)"rgstprmtrsd", (Object)"currentresidence");
    private static final List<Long> ADMINDIVISION_ID_LIST = ImmutableList.of((Object)1005772187937808386L, (Object)1005772187937808385L, (Object)1005772187937808384L);
    private static List<String> personalInfoKeys;
    private static List<String> contactInfoKeys;
    private static List<String> jobIntentionKeys;
    private static List<String> selfEvlutInfoKeys;
    boolean personalInfoIsExit = false;
    boolean contactInfoIsExit = false;
    boolean jobIntentionIsExit = false;
    boolean selfEvlutIsExit = false;

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"advcontoolbarap", "advcontoolbarap1", "advcontoolbarap2", "advcontoolbarap3", "buttonap", "labelap", "labelap1"});
        this.addClickListeners(new String[]{"addedulbl", "deledulbl", "editedulbl"});
        this.addClickListeners(new String[]{"addworklbl", "editworklbl", "delworklbl"});
        this.addClickListeners(new String[]{"addprjlbl", "editprjlbl", "delprjlbl"});
        this.addClickListeners(new String[]{"addlanglbl", "editlanglbl", "dellanglbl"});
        this.addClickListeners(new String[]{"addrelationlbl", "editrelationlbl", "delrelationlbl"});
    }

    public void beforeBindData(EventObject e) {
        long vid;
        super.beforeBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Long resumeId = (Long)showParameter.getCustomParam("id");
        Long ee = (Long)showParameter.getCustomParam("vid");
        if (Objects.nonNull(ee)) {
            vid = ee;
            this.getModel().setValue("vid", (Object)ee);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"personalinfoedit", "contactinfoedit", "jobintentionedit", "flexpanelap1", "flexpanelap11", "flexpanelap111", "flexpanelap112", "flexpanelap113", "advcontoolbarap3"});
        } else {
            DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmDy((Long)resumeId);
            vid = stdRsmDy.getLong("sourcevid");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"personalinfosave", "personalinfocancel", "contactinfocancel", "contactinfosave", "jobintentioncancel", "jobintentionsave", "selfevlutcancel", "selfevlutsave"});
        }
        String pageParam = (String)showParameter.getCustomParam("version");
        if (HRStringUtils.isNotEmpty((String)pageParam)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"toolbarap"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"toolbarap"});
        }
        this.getView().getPageCache().put("stdRsmId", resumeId.toString());
        IResumeService resumeService = (IResumeService)RsmPrototypeFactory.getResumeService((ModelType)ModelType.MAIN_RSM_DEFAULT_SERVICE);
        resumeService.setMainEntryNumber("tsirm_stdrsm");
        Map stdRsmData = resumeService.getStdRsm(Long.valueOf(vid));
        StdRsmDetailHelper.initPageData((IFormView)this.getView(), (Map)stdRsmData);
        this.getModel().setValue("id", (Object)resumeId);
        this.getModel().setDataChanged(false);
        CardEntry cardEntry = (CardEntry)this.getView().getControl("posorgrelentry");
        DynamicObjectCollection posorgrelEntry = this.getModel().getEntryEntity("posorgrelentry");
        for (int index = 0; index < posorgrelEntry.size(); ++index) {
            DynamicObject postype = ((DynamicObject)posorgrelEntry.get(index)).getDynamicObject("postype");
            if (postype == null) {
                cardEntry.setChildVisible(false, index, new String[]{"postypelbl1", "postypelbl2", "postypelbl3"});
                continue;
            }
            if (postype.getLong("id") == 1010L) {
                cardEntry.setChildVisible(false, index, new String[]{"postypelbl2", "postypelbl3"});
                continue;
            }
            if (postype.getLong("id") == 1020L) {
                cardEntry.setChildVisible(false, index, new String[]{"postypelbl1", "postypelbl3"});
                continue;
            }
            this.getModel().setValue("postypelbl3", (Object)postype.getString("name"), index);
            cardEntry.setChildVisible(false, index, new String[]{"postypelbl1", "postypelbl2"});
        }
    }

    public void afterBindData(EventObject e) {
        Map allFields = this.getModel().getDataEntityType().getAllFields();
        Set fieldKeySet = allFields.keySet();
        this.getView().setEnable(Boolean.FALSE, fieldKeySet.toArray(new String[0]));
        this.initializeBlockKeys();
        PageUtils.setFlexCollapsible((List)ImmutableList.of((Object)"advconap", (Object)"flexpanelwork", (Object)"flexpanelap3", (Object)"flexpanelap", (Object)"stdlangabl", (Object)"advconap2", (Object)"advconap1", (Object)"stdrelationwork", (Object)"advconap3"), (boolean)false, (IFormView)this.getView());
        Long resumeId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        List attachments = AttachmentServiceHelper.getAttachments((String)"tsirm_stdrsm", (Object)resumeId, (String)"attachmentpanelap");
        AttachmentPanel panel = (AttachmentPanel)this.getControl("attachmentpanelap");
        panel.bindData(attachments);
    }

    private void initializeBlockKeys() {
        Container personalInfoBlock = (Container)this.getControl("personalinfo");
        List personalInfoItems = personalInfoBlock.getItems();
        personalInfoKeys = personalInfoItems.stream().map(Control::getKey).collect(Collectors.toList());
        Container contactInfoBlock = (Container)this.getControl("contactinfo");
        List contactInfoItems = contactInfoBlock.getItems();
        contactInfoKeys = contactInfoItems.stream().map(Control::getKey).collect(Collectors.toList());
        Container jobIntentionBlock = (Container)this.getControl("jobintention");
        List jobIntentionItems = jobIntentionBlock.getItems();
        jobIntentionKeys = jobIntentionItems.stream().map(Control::getKey).collect(Collectors.toList());
        Container selfEvlutBlock = (Container)this.getControl("selfevlut");
        List selfEvlutItems = selfEvlutBlock.getItems();
        selfEvlutInfoKeys = selfEvlutItems.stream().map(Control::getKey).collect(Collectors.toList());
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (!this.checkStdRsmDataStatus()) {
            evt.setCancel(true);
            return;
        }
        String itemKey = evt.getItemKey();
        if ("personalinfosave".equals(itemKey)) {
            this.checkData(evt);
        } else if ("contactinfosave".equals(itemKey)) {
            this.checkContactInfo(evt);
        }
        if (itemKey.contains("save")) {
            Object oldValue;
            Object newValue;
            Control blockItem;
            String name;
            Long id = Long.valueOf(String.valueOf(this.getModel().getValue("id")));
            DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmDy((Long)id);
            DynamicObject dataEntity = this.getModel().getDataEntity();
            boolean flag = false;
            Container block = (Container)this.getControl(itemKey.replace("save", ""));
            List blockItems = block.getItems();
            Iterator iterator = blockItems.iterator();
            while (iterator.hasNext() && (HRStringUtils.equals((String)(name = (blockItem = (Control)iterator.next()).getKey()), (String)"showworkingyears") || HRStringUtils.equals((String)name, (String)"tracktime") || !(flag = ResumeDyUtil.isValueChanged((Object)(newValue = dataEntity.get(name)), (Object)(oldValue = stdRsmDy.get(name)))))) {
            }
            if (!flag) {
                evt.setCancel(Boolean.TRUE.booleanValue());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"IStdRsmService_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                String btnCancelKey = itemKey.replace("save", "cancel");
                String btnEditKey = itemKey.replace("save", "edit");
                this.getView().setVisible(Boolean.FALSE, new String[]{itemKey, btnCancelKey});
                this.getView().setVisible(Boolean.TRUE, new String[]{btnEditKey});
                this.setBlockEnable(this.getView(), itemKey.replace("save", ""), Boolean.FALSE);
            }
        }
    }

    private void setBlockEnable(IFormView view, String blockKey, Boolean isEnable) {
        Container block = (Container)view.getControl(blockKey);
        List items = block.getItems();
        for (Control item : items) {
            view.setEnable(isEnable, new String[]{item.getKey()});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        StdRsmDetailHelper.clickEntryEvent((AbstractBillPlugIn)this, (String)itemKey);
        String stdRsmId = this.getView().getPageCache().get("stdRsmId");
        if (HRStringUtils.isEmpty((String)stdRsmId)) {
            return;
        }
        String message = ResumeValidateHelper.stdRsmDeleteDataStatusValidate((IFormView)this.getView(), (long)Long.parseLong(stdRsmId));
        if (HRStringUtils.isNotEmpty((String)message)) {
            return;
        }
        if (itemKey.contains("save")) {
            String headTemplatePageId = this.getView().getParentView().getPageCache().get("tsirm_head_templatepageid");
            IFormView headTemplateView = this.getView().getView(headTemplatePageId);
            headTemplateView.invokeOperation("refresh");
            this.getView().sendFormAction(headTemplateView);
            this.refreshLabelShow();
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String operateKey = source.getKey();
        if (operateKey.startsWith("del")) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(operateKey, (IFormPlugin)this);
            String msg = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684{0}\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\r\n\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"AbstractListView_1", (String)"bos-form-mvc", (Object[])new Object[0]).replace("{0}", "1");
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBacks);
        } else {
            StdRsmDetailHelper.clickEntryEvent((AbstractBillPlugIn)this, (String)operateKey);
        }
    }

    private void refreshLabelShow() {
        IFormView parentView = this.getView().getParentView();
        if (null != parentView) {
            String isSimpleStdRsm = (String)parentView.getFormShowParameter().getCustomParam("isSimpleStdRsm");
            long stdRsmId = (Long)parentView.getFormShowParameter().getCustomParam("id");
            DynamicObject stdRsmDy = StandardResumeDataHelper.queryOne((Long)stdRsmId);
            Long sourceVid = stdRsmDy.getLong("sourcevid");
            AiInsightParamEntity aiInsightParamEntity = new AiInsightParamEntity();
            aiInsightParamEntity.setAppRsmId(sourceVid);
            aiInsightParamEntity.setTargetKey("flexpanelap2");
            aiInsightParamEntity.setTypeId(LabelTagObjTypeEnum.IN_STDRSM.getId());
            aiInsightParamEntity.setShowMyLabel(Boolean.valueOf(true));
            aiInsightParamEntity.setCanEditLabel(Boolean.valueOf(true));
            aiInsightParamEntity.setFold(Boolean.valueOf(false));
            String dataStatus = (String)this.getView().getFormShowParameter().getCustomParam("datastatus");
            if (ResumeHisDataStatusEnum.BLACK_LIST.getStatus().equals(dataStatus) && isSimpleStdRsm == null) {
                aiInsightParamEntity.setCanEditLabel(Boolean.valueOf(false));
            }
            if (null != isSimpleStdRsm) {
                aiInsightParamEntity.setCanEditLabel(Boolean.valueOf(false));
            }
            LabelDataHelper.showAppRsmDefaultLabelPage((IFormView)parentView, (AiInsightParamEntity)aiInsightParamEntity);
            this.getView().sendFormAction(parentView);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        if (!this.checkStdRsmDataStatus()) {
            evt.setCancel(true);
        }
    }

    private boolean checkStdRsmDataStatus() {
        String stdRsmId = this.getView().getPageCache().get("stdRsmId");
        String checkResult = StdRsmBusiAppHelper.checkStdRsmDataStatus((long)Long.parseLong(stdRsmId));
        if (checkResult.trim().length() > 0) {
            IFormView mainView = this.getView().getMainView();
            mainView.showErrorNotification(checkResult);
            this.getView().sendFormAction(mainView);
            this.getView().getParentView().close();
            this.getView().sendFormAction(this.getView().getParentView());
            return false;
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String stdRsmId = this.getView().getPageCache().get("stdRsmId");
        if (HRStringUtils.isEmpty((String)stdRsmId)) {
            return;
        }
        String headTemplatePageId = this.getView().getParentView().getPageCache().get("tsirm__head_templatepageid");
        IFormView headTemplateView = this.getView().getView(headTemplatePageId);
        headTemplateView.invokeOperation("refresh");
        this.getView().sendFormAction(headTemplateView);
        this.getView().invokeOperation("refresh");
        this.refreshLabelShow();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String resultValue = messageBoxClosedEvent.getResultValue();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((CharSequence)"Yes", (CharSequence)resultValue)) {
            if (callBackId.contains("cancel")) {
                String blockKey = callBackId.replace("cancel", "");
                String replace = callBackId.replace("cancel", "_changeDec");
                this.getView().getPageCache().put(replace, null);
                if ("personalinfo".equals(blockKey)) {
                    this.personalInfoIsExit = true;
                } else if ("contactinfo".equals(blockKey)) {
                    this.contactInfoIsExit = true;
                } else if ("jobintention".equals(blockKey)) {
                    this.jobIntentionIsExit = true;
                } else if ("selfevlut".equals(blockKey)) {
                    this.selfEvlutIsExit = true;
                }
                String btnEditKey = callBackId.replace("cancel", "edit");
                String btnSaveKey = callBackId.replace("cancel", "save");
                this.getView().setVisible(Boolean.FALSE, new String[]{callBackId, btnSaveKey});
                this.getView().setVisible(Boolean.TRUE, new String[]{btnEditKey});
                Container block = (Container)this.getControl(blockKey);
                List items = block.getItems();
                Long stdRsmId = Long.valueOf(this.getView().getPageCache().get("stdRsmId"));
                DynamicObject stdRsmDy = StandardResumeDataHelper.queryOne((Long)stdRsmId);
                for (Control item : items) {
                    String itemKey = item.getKey();
                    this.getView().setEnable(Boolean.FALSE, new String[]{itemKey});
                    if ("showworkingyears".equals(itemKey)) {
                        StdRsmDetailHelper.setWorkingYears((IDataModel)this.getModel(), (DynamicObject)stdRsmDy);
                        continue;
                    }
                    this.getModel().setValue(itemKey, stdRsmDy.get(itemKey));
                }
            } else if (callBackId.startsWith("del")) {
                IFormView view = this.getView();
                FormShowParameter parameter = this.getView().getFormShowParameter();
                String dataStatus = (String)parameter.getCustomParam("datastatus");
                Long stdRsmId = (Long)parameter.getCustomParam("id");
                String validate = ResumeValidateHelper.validateResumeDetailStatus((Long)stdRsmId, (String)dataStatus);
                if (HRStringUtils.isNotEmpty((String)validate)) {
                    PageUtils.showErrorNotificationAndClosePage((IFormView)view.getMainView(), (IFormView)view, (IFormView)view.getParentView(), (String)validate);
                    return;
                }
                StdRsmDetailHelper.clickEntryEvent((AbstractBillPlugIn)this, (String)callBackId);
                String headTemplatePageId = this.getView().getParentView().getPageCache().get("tsirm__head_templatepageid");
                IFormView headTemplateView = this.getView().getView(headTemplatePageId);
                headTemplateView.invokeOperation("refresh");
                this.getView().sendFormAction(headTemplateView);
                this.refreshLabelShow();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String email;
        this.recordPropertyChangedDesc(e);
        String propertyName = e.getProperty().getName();
        if ("birthday".equals(propertyName)) {
            Date newBirthday = (Date)e.getChangeSet()[0].getNewValue();
            int newAge = ResumeUtil.calculateAge((Date)newBirthday);
            this.getModel().setValue("age", (Object)newAge);
        } else if ("partwt".equals(propertyName)) {
            Date newPartwt = (Date)e.getChangeSet()[0].getNewValue();
            int newWorkingYears = ResumeAnalysisHelper.calMonthByStartDate((Date)newPartwt);
            this.getModel().setValue("workingyears", (Object)newWorkingYears);
            this.getModel().setValue("showworkingyears", (Object)ResumeAnalysisHelper.getWorkYearShow((int)newWorkingYears));
        } else if ("phone".equals(propertyName)) {
            String phone = (String)e.getChangeSet()[0].getNewValue();
            if (StringUtils.isNotEmpty((CharSequence)phone)) {
                if (!ResumeUtil.checkPhone((String)phone)) {
                    String message = ResManager.loadKDString((String)"\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"StdRsmDetailPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                    this.getView().showFieldTip(ResumeUtilsHelper.createFieldTip((String)message, (String)"phone"));
                } else if (phone.length() > 46) {
                    String message = ResManager.loadKDString((String)"\u8f93\u5165\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7%s\u5b57\u7b26", (String)"StdRsmDetailPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                    this.getView().showFieldTip(ResumeUtilsHelper.createFieldTip((String)String.format(Locale.ROOT, message, 50), (String)"phone"));
                }
            }
        } else if ("email".equals(propertyName) && (email = (String)e.getChangeSet()[0].getNewValue()) != null && email.length() > 100) {
            String message = ResManager.loadKDString((String)"\u8f93\u5165\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7%s\u5b57\u7b26", (String)"StdRsmDetailPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            this.getView().showFieldTip(ResumeUtilsHelper.createFieldTip((String)String.format(Locale.ROOT, message, 100), (String)"email"));
        }
    }

    private void recordPropertyChangedDesc(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        String changeName = e.getProperty().getDisplayName().toString();
        if (personalInfoKeys.contains(key) && !this.personalInfoIsExit) {
            String personalInfoChangeDec = this.getView().getPageCache().get("personalinfo_changeDec");
            if (personalInfoChangeDec == null) {
                personalInfoChangeDec = changeName;
            } else if (!personalInfoChangeDec.contains(changeName)) {
                personalInfoChangeDec = personalInfoChangeDec + '\uff0c' + changeName;
            }
            this.getView().getPageCache().put("personalinfo_changeDec", personalInfoChangeDec);
        } else if (contactInfoKeys.contains(key) && !this.contactInfoIsExit) {
            String contactInfoChangeDec = this.getView().getPageCache().get("contactinfo_changeDec");
            if (contactInfoChangeDec == null) {
                contactInfoChangeDec = changeName;
            } else if (!contactInfoChangeDec.contains(changeName)) {
                contactInfoChangeDec = contactInfoChangeDec + '\uff0c' + changeName;
            }
            this.getView().getPageCache().put("contactinfo_changeDec", contactInfoChangeDec);
        } else if (jobIntentionKeys.contains(key) && !this.jobIntentionIsExit) {
            String jobIntentionChangeDec = this.getView().getPageCache().get("jobintention_changeDec");
            if (jobIntentionChangeDec == null) {
                jobIntentionChangeDec = changeName;
            } else if (!jobIntentionChangeDec.contains(changeName)) {
                jobIntentionChangeDec = jobIntentionChangeDec + '\uff0c' + changeName;
            }
            this.getView().getPageCache().put("jobintention_changeDec", jobIntentionChangeDec);
        } else if (selfEvlutInfoKeys.contains(key) && !this.selfEvlutIsExit) {
            String selfEvlutChangeDec = this.getView().getPageCache().get("selfevlut_changeDec");
            if (selfEvlutChangeDec == null) {
                selfEvlutChangeDec = changeName;
            } else if (!selfEvlutChangeDec.contains(changeName)) {
                selfEvlutChangeDec = selfEvlutChangeDec + '\uff0c' + changeName;
            }
            this.getView().getPageCache().put("selfevlut_changeDec", selfEvlutChangeDec);
        }
    }

    private void checkData(BeforeItemClickEvent args) {
        ArrayList fieldList = Lists.newArrayListWithExpectedSize((int)2);
        for (String fieldKey : CHECK_FIELDS) {
            HRBaseServiceHelper helper;
            DynamicObject admindivision;
            DynamicObject adminDivisionLv;
            int level;
            Long id = this.getModel().getDataEntity().getLong(fieldKey);
            if (id == null || id <= 0L || ADMINDIVISION_ID_LIST.contains(id) || ResumeUtil.getCountrys().contains(String.valueOf(id)) || (level = (adminDivisionLv = (admindivision = (helper = new HRBaseServiceHelper("bd_admindivision")).loadSingle((Object)id)).getDynamicObject("basedatafield")).getInt("level")) >= 2 || admindivision.getBoolean("iscity")) continue;
            fieldList.add(this.getModel().getProperty(fieldKey).getDisplayName().getLocaleValue());
        }
        if (fieldList.size() > 0) {
            args.setCancel(Boolean.TRUE.booleanValue());
            StringBuilder messageStringBuilder = new StringBuilder();
            for (int i = 0; i < fieldList.size(); ++i) {
                if (i == fieldList.size() - 1) {
                    messageStringBuilder.append("\u201c");
                    messageStringBuilder.append((String)fieldList.get(i));
                    messageStringBuilder.append("\u201c");
                    continue;
                }
                messageStringBuilder.append("\u201c");
                messageStringBuilder.append((String)fieldList.get(i));
                messageStringBuilder.append("\u201c");
                messageStringBuilder.append("\u3001");
            }
            messageStringBuilder.append(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u81f3\u5e02\u7ea7\u3002", (String)"StdRsmDetailPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            this.getView().showTipNotification(messageStringBuilder.toString());
        }
    }

    private void checkContactInfo(BeforeItemClickEvent args) {
        String phone = this.getModel().getDataEntity().getString("phone");
        String email = this.getModel().getDataEntity().getString("email");
        ArrayList checkFailedFieldList = Lists.newArrayListWithExpectedSize((int)2);
        if (phone != null && !phone.isEmpty()) {
            if (!ResumeUtil.checkPhone((String)phone)) {
                checkFailedFieldList.add(this.getModel().getProperty("phone").getDisplayName().toString());
            } else if (phone.length() > 46) {
                checkFailedFieldList.add(this.getModel().getProperty("phone").getDisplayName().toString());
            }
        }
        if (email != null && email.length() > 100) {
            checkFailedFieldList.add(this.getModel().getProperty("email").getDisplayName().toString());
        }
        if (checkFailedFieldList.size() > 0) {
            args.setCancel(Boolean.TRUE.booleanValue());
            String commonTipNotification = ViewUtils.getCommonTipNotification((List)checkFailedFieldList);
            this.getView().showTipNotification(commonTipNotification);
        }
    }
}

