/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.stdrsm.bill;

import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RsmHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.ResumeValidateHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StandardEducationExpDataHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StandardProjectExpDataHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StandardWorkExpDataHelper;
import kd.tsc.tsirm.business.domain.stdrsm.util.ResumeUtil;
import kd.tsc.tsirm.common.constants.stdrsm.TSTPMStdRsmBizAppConstants;
import kd.tsc.tsirm.common.enums.stdrsm.ResumeEntryFieldEnum;
import kd.tsc.tsrbd.common.utils.PageUtils;
import kd.tsc.tsrbd.common.utils.ResumeDyUtil;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeUtilsHelper;
import org.apache.commons.lang3.StringUtils;

public class StdRsmEntryEdit
extends HRCoreBaseBillEdit {
    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object stdRsmIdObj = formShowParameter.getCustomParam("id");
        Long stdRsmId = stdRsmIdObj == null ? null : Long.valueOf(Long.parseLong(stdRsmIdObj.toString()));
        this.getModel().setValue("stdrsm", (Object)stdRsmId);
    }

    public void afterBindData(EventObject e) {
        ResumeUtil.setPromptInfo((IFormView)this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("endingdate".equals(name)) {
            Date endingDate = (Date)e.getChangeSet()[0].getNewValue();
            Date startDate = this.getModel().getDataEntity().getDate("startdate");
            RsmHelper.setDataControlMinMax((Date)startDate, (Date)endingDate, (IFormView)this.getView());
        } else if ("startdate".equals(name)) {
            Date startDate = (Date)e.getChangeSet()[0].getNewValue();
            Date endingDate = this.getModel().getDataEntity().getDate("endingdate");
            RsmHelper.setDataControlMinMax((Date)startDate, (Date)endingDate, (IFormView)this.getView());
        } else if (StringUtils.equals((CharSequence)"schoolname", (CharSequence)name)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            long id = newValue.getLong("id");
            TextEdit othschname = (TextEdit)this.getControl("othschname");
            if (TSTPMStdRsmBizAppConstants.OTHER_SCHOOL_ID.equals(id)) {
                othschname.setMustInput(Boolean.TRUE.booleanValue());
            } else {
                othschname.setMustInput(Boolean.FALSE.booleanValue());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        IFormView view = this.getView();
        FormShowParameter parameter = this.getView().getParentView().getFormShowParameter();
        String dataStatus = (String)parameter.getCustomParam("datastatus");
        Long stdRsmId = (Long)parameter.getCustomParam("id");
        String validate = ResumeValidateHelper.validateResumeDetailStatus((Long)stdRsmId, (String)dataStatus);
        if (HRStringUtils.isNotEmpty((String)validate)) {
            PageUtils.showErrorNotificationAndClosePage((IFormView)view.getMainView(), (IFormView)view, (IFormView)view.getParentView().getParentView(), (String)validate);
            args.setCancel(true);
            return;
        }
        Date startDate = this.getModel().getDataEntity().getDate("startdate");
        Date endingDate = this.getModel().getDataEntity().getDate("endingdate");
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey)) {
            long id;
            String changePageName = this.getModel().getDataEntity().getDynamicObjectType().getName();
            if (HRStringUtils.equals((String)changePageName, (String)"tsirm_stdeduexp")) {
                id = Long.parseLong(String.valueOf(this.getModel().getValue("id")));
                if (id != 0L) {
                    Object oldValue;
                    IDataEntityProperty property;
                    String name;
                    Object newValue;
                    DynamicObject stdEduExp = StandardEducationExpDataHelper.findStdEduExp((Long)id);
                    DynamicObject dataEntity = this.getModel().getDataEntity();
                    DataEntityPropertyCollection properties = this.getModel().getDataEntity().getDynamicObjectType().getProperties();
                    boolean flag = false;
                    Iterator iterator = properties.iterator();
                    while (iterator.hasNext() && !(flag = ResumeDyUtil.isValueChanged((Object)(newValue = dataEntity.get(name = (property = (IDataEntityProperty)iterator.next()).getName())), (Object)(oldValue = stdEduExp.get(name))))) {
                    }
                    if (!flag) {
                        args.setCancel(Boolean.TRUE.booleanValue());
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"IStdRsmService_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                        this.getModel().setDataChanged(false);
                        this.getView().close();
                    }
                }
            } else if (HRStringUtils.equals((String)changePageName, (String)"tsirm_stdprjexp")) {
                id = Long.parseLong(String.valueOf(this.getModel().getValue("id")));
                if (id != 0L) {
                    Object oldValue;
                    IDataEntityProperty property;
                    String name;
                    Object newValue;
                    DynamicObject stdPrjExp = StandardProjectExpDataHelper.findStdPrjExp((Long)id);
                    DynamicObject dataEntity = this.getModel().getDataEntity();
                    DataEntityPropertyCollection properties = this.getModel().getDataEntity().getDynamicObjectType().getProperties();
                    boolean flag = false;
                    Iterator iterator = properties.iterator();
                    while (iterator.hasNext() && !(flag = ResumeDyUtil.isValueChanged((Object)(newValue = dataEntity.get(name = (property = (IDataEntityProperty)iterator.next()).getName())), (Object)(oldValue = stdPrjExp.get(name))))) {
                    }
                    if (!flag) {
                        args.setCancel(Boolean.TRUE.booleanValue());
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"IStdRsmService_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                        this.getModel().setDataChanged(false);
                        this.getView().close();
                    }
                }
            } else if (HRStringUtils.equals((String)changePageName, (String)"tsirm_stdworkexp") && (id = Long.parseLong(String.valueOf(this.getModel().getValue("id")))) != 0L) {
                Object oldValue;
                IDataEntityProperty property;
                String name;
                Object newValue;
                DynamicObject stdWorkExp = StandardWorkExpDataHelper.findStdWorkExp((Long)id);
                DynamicObject dataEntity = this.getModel().getDataEntity();
                DataEntityPropertyCollection properties = this.getModel().getDataEntity().getDynamicObjectType().getProperties();
                boolean flag = false;
                Iterator iterator = properties.iterator();
                while (iterator.hasNext() && !(flag = ResumeDyUtil.isValueChanged((Object)(newValue = dataEntity.get(name = (property = (IDataEntityProperty)iterator.next()).getName())), (Object)(oldValue = stdWorkExp.get(name))))) {
                }
                if (!flag) {
                    args.setCancel(Boolean.TRUE.booleanValue());
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"IStdRsmService_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                    this.getModel().setDataChanged(false);
                    this.getView().close();
                }
            }
        }
        if (null != startDate && null != endingDate) {
            this.checkEndingDate(startDate, endingDate, Boolean.TRUE);
            if (!ResumeUtil.comPareDate((Date)startDate, (Date)endingDate).booleanValue()) {
                args.setCancel(Boolean.TRUE.booleanValue());
            }
            int totalDay = ResumeUtil.calculateDuration((Date)startDate, (Date)endingDate);
            String field = ResumeEntryFieldEnum.getFieldKeyByPageKey((String)this.getView().getFormShowParameter().getFormId());
            if (HRStringUtils.isNotEmpty((String)field)) {
                this.getModel().setValue(field, (Object)totalDay);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        List successPkIds;
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey) && (successPkIds = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds()) != null && successPkIds.size() > 0) {
            Long stdRsmId = this.getModel().getDataEntity().getLong("stdrsm");
            String headTemplatePageId = this.getView().getParentView().getParentView().getPageCache().get("tsirm_head_templatepageid");
            IFormView headTemplateView = this.getView().getView(headTemplatePageId);
            headTemplateView.invokeOperation("refresh");
            this.getView().sendFormAction(headTemplateView);
            this.getView().close();
        }
    }

    private void checkEndingDate(Date startDate, Date endingDate, Boolean isShowTip) {
        Boolean startDateIsBeforeEndingDate = ResumeUtil.comPareDate((Date)startDate, (Date)endingDate);
        if (!startDateIsBeforeEndingDate.booleanValue()) {
            this.getView().showFieldTip(ResumeUtilsHelper.createFieldTip((String)ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u65f6\u95f4", (String)"StdRsmEntryEdit_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), (String)"endingdate"));
            if (isShowTip.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7ed3\u675f\u65f6\u95f4\u201d\u3002", (String)"StdRsmEntryEdit_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            }
        } else {
            FieldTip fieldTip = new FieldTip();
            fieldTip.setFieldKey("endingdate");
            fieldTip.setSuccess(Boolean.TRUE.booleanValue());
            this.getView().showFieldTip(fieldTip);
        }
    }
}

