/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.stdrsm.list;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsirm.business.domain.rsm.common.mservice.PositionMService;
import kd.tsc.tsirm.business.domain.stdrsm.helper.ResumeValidateHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmBusiAppHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.service.StdRsmCommonService;
import kd.tsc.tsrbd.common.utils.PageUtils;

public class ApplyRecordPlugin
extends HRDynamicFormBasePlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object stdRsmIdObj = this.getView().getFormShowParameter().getCustomParam("id");
        Long stdRsmId = stdRsmIdObj == null ? null : Long.valueOf(Long.parseLong(stdRsmIdObj.toString()));
        Object parentPageId = this.getView().getFormShowParameter().getCustomParam("parent");
        if (!HRObjectUtils.isEmpty((Object)parentPageId)) {
            DynamicObject[] midStdRsmIds = StdRsmServiceHelper.getMidStdRsmIds((Long)stdRsmId);
            List<Long> stdRsmIds = Arrays.stream(midStdRsmIds).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            this.entryDataInit(stdRsmId, stdRsmIds);
            this.getView().setVisible(Boolean.FALSE, new String[]{"ismerge"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"checkappfile"});
        } else {
            this.entryDataInit(stdRsmId, null);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("ismerge".equals(e.getProperty().getName())) {
            Boolean merge = (Boolean)this.getModel().getValue("ismerge");
            Long stdRsmId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
            if (merge.booleanValue()) {
                DynamicObject[] midStdRsmIds = StdRsmServiceHelper.getMidStdRsmIds((Long)stdRsmId);
                List<Long> stdRsmIds = Arrays.stream(midStdRsmIds).map(dy -> dy.getLong("id")).collect(Collectors.toList());
                this.entryDataInit(stdRsmId, stdRsmIds);
            } else {
                this.entryDataInit(stdRsmId, null);
            }
        }
    }

    private void entryDataInit(Long mainStdRsmId, List<Long> mergeIds) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        model.beginInit();
        TableValueSetter tableValueSetter = StdRsmBusiAppHelper.getMainStdRsmApplyRecordList((Long)mainStdRsmId, mergeIds);
        model.batchCreateNewEntryRow("entryentity", tableValueSetter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        IFormView view = this.getView();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String dataStatus = (String)parameter.getCustomParam("datastatus");
        Long stdRsmId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        boolean hasStdRsmViewPermission = StdRsmCommonService.getInstance().queryStdRsmViewPermission(stdRsmId);
        if (!hasStdRsmViewPermission) {
            this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u5019\u9009\u4eba\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"ApplyRecordPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        String validate = ResumeValidateHelper.validateResumeDetailStatus((Long)stdRsmId, (String)dataStatus);
        if (HRStringUtils.isNotEmpty((String)validate)) {
            PageUtils.showErrorNotificationAndClosePage((IFormView)view.getMainView(), (IFormView)view, (IFormView)view.getParentView(), (String)validate);
            return;
        }
        String fieldName = evt.getFieldName();
        int rowIndex = evt.getRowIndex();
        IDataModel entryOperate = this.getModel();
        DynamicObject rowEntity = entryOperate.getEntryRowEntity("entryentity", rowIndex);
        Long positionId = rowEntity.getLong("positionid");
        if (HRStringUtils.equals((String)"applyposition", (String)fieldName)) {
            this.openPositionPageByPermissions(positionId);
        }
        if (HRStringUtils.equals((String)"checkappfile", (String)fieldName)) {
            Long appFileId = rowEntity.getLong("appfileid");
            this.openAppFilePageByPermissions(appFileId);
        }
    }

    private void openAppFilePageByPermissions(Long appFileId) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("tsirm_appfile_viewm");
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setPkId((Object)appFileId);
        billShowParameter.setStatus(OperationStatus.EDIT);
        billShowParameter.setPageId(PageUtils.getPageId((String)appFileId.toString(), (String)this.getView().getFormShowParameter().getAppId(), (String)"tsirm_appfile_viewm", (String)this.getView().getFormShowParameter().getRootPageId()));
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private void openPositionPageByPermissions(Long positionId) {
        boolean haveAuthority = PositionMService.hasPositionPerm((Long)positionId);
        if (!haveAuthority) {
            IFormView parentView = this.getView().getParentView();
            if (null == parentView) {
                return;
            }
            parentView.showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6682\u65e0\u8be5\u804c\u4f4d\u7684\u67e5\u770b\u6743\u9650\uff0c\u53ef\u8054\u7cfb\u804c\u4f4d\u8d1f\u8d23\u4eba", (String)"ApplyRecordPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(parentView);
            return;
        }
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("tsirm_position_view");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setPkId((Object)positionId);
        baseShowParameter.setPageId(PageUtils.getPageId((String)positionId.toString(), (String)this.getView().getFormShowParameter().getAppId(), (String)"tsirm_position_view", (String)this.getView().getFormShowParameter().getRootPageId()));
        baseShowParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }
}

