/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.stdrsm.list;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsirm.business.domain.stdrsm.helper.ResumeValidateHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmBusiAppHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.service.StdRsmCommonService;
import kd.tsc.tsrbd.common.utils.PageUtils;

public class DeliveryRecordListPlugin
extends HRDynamicFormBasePlugin
implements HyperLinkClickListener {
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_VIEW_RESUME = "viewresume";
    private static final String KEY_DELIVERY = "rdelivery";
    public static final String KEY_IS_MERGE = "ismerge";
    private static final String BUTTON_VIEW = "viewbutton";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (KEY_IS_MERGE.equals(e.getProperty().getName())) {
            Boolean merge = (Boolean)this.getModel().getValue(KEY_IS_MERGE);
            Long stdRsmId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
            if (merge.booleanValue()) {
                DynamicObject[] midStdRsmIds = StdRsmServiceHelper.getMidStdRsmIds((Long)stdRsmId);
                List<Long> stdRsmIds = Arrays.stream(midStdRsmIds).map(dy -> dy.getLong("id")).collect(Collectors.toList());
                this.entryDataInit(stdRsmId, stdRsmIds);
            } else {
                this.entryDataInit(stdRsmId, null);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        Long stdRsmId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        this.entryDataInit(Long.valueOf(stdRsmId.toString()), null);
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        IFormView view = this.getView();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String dataStatus = (String)parameter.getCustomParam("datastatus");
        Long stdRsmId = (Long)parameter.getCustomParam("id");
        boolean hasStdRsmViewPermission = StdRsmCommonService.getInstance().queryStdRsmViewPermission(stdRsmId);
        if (!hasStdRsmViewPermission) {
            this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u5019\u9009\u4eba\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"DeliveryRecordListPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        String validate = ResumeValidateHelper.validateResumeDetailStatus((Long)stdRsmId, (String)dataStatus);
        if (HRStringUtils.isNotEmpty((String)validate)) {
            PageUtils.showErrorNotificationAndClosePage((IFormView)view.getMainView(), (IFormView)view, (IFormView)view.getParentView(), (String)validate);
            return;
        }
        if (HRStringUtils.equals((String)KEY_VIEW_RESUME, (String)arg0.getFieldName())) {
            int rowIndex = arg0.getRowIndex();
            IDataModel entryOperate = this.getModel();
            DynamicObject entity = entryOperate.getEntryRowEntity(KEY_ENTRY_ENTITY, rowIndex);
            this.getView().getPageCache().put("currentClickRowData", SerializationUtils.toJsonString((Object)entity));
            this.getView().invokeOperation(BUTTON_VIEW);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult().isSuccess() && BUTTON_VIEW.equals(operateKey) && !HRStringUtils.isBlank((CharSequence)this.getPageCache().get("currentClickRowData"))) {
            JSONObject jsonObject = (JSONObject)SerializationUtils.fromJsonString((String)this.getPageCache().get("currentClickRowData"), JSONObject.class);
            this.showDeliveryDetail(jsonObject);
        }
    }

    private void showDeliveryDetail(JSONObject jsonObject) {
        JSONObject rDelivery = jsonObject.getJSONObject(KEY_DELIVERY);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("tsirm_rdeliverydetails");
        formShowParameter.getOpenStyle().setPlaceholder(false);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("60%");
        formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        formShowParameter.getOpenStyle().setShowType(ShowType.PageDrawer);
        formShowParameter.getOpenStyle().setFloatingDirection(FloatingDirection.RightCenter);
        formShowParameter.setCustomParam("id", (Object)rDelivery.getLong("id"));
        String msg = ResManager.loadKDString((String)"\u7b80\u5386", (String)"DeliveryRecordListPlugin_0", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
        formShowParameter.setCaption(jsonObject.getString("name") + msg);
        formShowParameter.setShowTitle(true);
        this.getView().showForm(formShowParameter);
    }

    private void entryDataInit(Long mainStdRsmId, List<Long> mergeIds) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(KEY_ENTRY_ENTITY);
        model.beginInit();
        TableValueSetter tableValueSetter = StdRsmBusiAppHelper.getMainStdRsmDeliveryRecordList((Long)mainStdRsmId, mergeIds);
        model.batchCreateNewEntryRow(KEY_ENTRY_ENTITY, tableValueSetter);
        model.endInit();
        this.getView().updateView(KEY_ENTRY_ENTITY);
        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_ENTRY_ENTITY});
    }
}

