/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.stdrsm.list;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.stdrsm.helper.HistoryServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.util.CandidateDetailPageHelper;
import kd.tsc.tsirm.common.util.talentpool.CandidateSortUtil;
import kd.tsc.tsrbs.business.domain.rsm.service.AdminDivisionHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;

public class ExperiencesShowPlugin
extends AbstractFormPlugin {
    private static final Map<String, String> IS_RELATION_WORK = new HashMap<String, String>(2);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"allopen", "allclose", "cur_work_open", "cur_work_close", "false_work_open", "false_work_close", "cur_item_open", "cur_item_close", "false_item_open", "false_item_close", "suspositiondown", "suspositionright", "curpositiondown", "curpositionright", "susedudown", "suseduright", "curedudown", "cureduright"});
    }

    public void afterCreateNewData(EventObject e) {
        Long stdRsmId = (Long)this.getView().getFormShowParameter().getCustomParam("stdRsmId");
        DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmDy((Long)Long.valueOf(stdRsmId.toString()));
        long mid = stdRsmDy.getLong("mid");
        this.fillResumeData(mid);
        this.getView().setVisible(Boolean.FALSE, new String[]{"suspositionright", "curpositionright", "suseduright", "cureduright"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        String key = ((Control)source).getKey();
        if (key.contains("open") || key.contains("close")) {
            this.clickFlodDetails(key);
        }
        switch (key) {
            case "suspositiondown": {
                this.downRight("susposition", "down");
                break;
            }
            case "suspositionright": {
                this.downRight("susposition", "right");
                break;
            }
            case "curpositiondown": {
                this.downRight("curposition", "down");
                break;
            }
            case "curpositionright": {
                this.downRight("curposition", "right");
                break;
            }
            case "susedudown": {
                this.downRight("susedu", "down");
                break;
            }
            case "suseduright": {
                this.downRight("susedu", "right");
                break;
            }
            case "curedudown": {
                this.downRight("curedu", "down");
                break;
            }
            case "cureduright": {
                this.downRight("curedu", "right");
                break;
            }
        }
    }

    public void downRight(String key, String type) {
        if ("down".equals(type)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{key + type, key + "flex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{key + "right"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{key + "down", key + "flex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{key + type});
        }
    }

    private void clickFlodDetails(String key) {
        String value;
        String string = value = key.contains("open") ? "0" : "1";
        if (key.contains("all")) {
            this.getModel().setValue("cur_work_isflod", (Object)value);
            this.getModel().setValue("false_work_isflod", (Object)value);
            this.getModel().setValue("cur_item_isflod", (Object)value);
            this.getModel().setValue("false_item_isflod", (Object)value);
        } else if (key.contains("work")) {
            this.getModel().setValue("cur_work_isflod", (Object)value);
            this.getModel().setValue("false_work_isflod", (Object)value);
        } else {
            this.getModel().setValue("cur_item_isflod", (Object)value);
            this.getModel().setValue("false_item_isflod", (Object)value);
        }
    }

    private void fillResumeData(Long stdRsmId) {
        this.clickFlodDetails("close");
        DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmDy((Long)stdRsmId);
        long sourceId = stdRsmDy.getLong("sourcevid");
        this.fillResumeDy(stdRsmDy, "cur");
        this.fillJobIntentionEntry(stdRsmDy, "cur");
        DynamicObject[] stdPositionDys = HistoryServiceHelper.getStdRsmHis((String)"tsirm_stdposorgrel", (Long)sourceId);
        this.fillPositionEntry(stdPositionDys, "cur");
        DynamicObject[] stdEduDys = HistoryServiceHelper.getStdRsmHis((String)"tsirm_stdeduexp", (Long)sourceId);
        this.fillEduEntry(stdEduDys, "cur");
        DynamicObject[] stdWorkDys = HistoryServiceHelper.getStdRsmHis((String)"tsirm_stdworkexp", (Long)sourceId);
        this.fillWorkEntry(stdWorkDys, "cur");
        DynamicObject[] stdPrjDys = HistoryServiceHelper.getStdRsmHis((String)"tsirm_stdprjexp", (Long)sourceId);
        this.fillProjectEntry(stdPrjDys, "cur");
        DynamicObject[] stdLangAbl = HistoryServiceHelper.getStdRsmHis((String)"tsirm_stdlangabl", (Long)sourceId);
        this.fillLanguageEntry(stdLangAbl, "cur");
        DynamicObject[] stdRelationWork = HistoryServiceHelper.getStdRsmHis((String)"tsirm_stdrelationwork", (Long)sourceId);
        this.fillRelationEntry(stdRelationWork, "cur");
        Long vid = (Long)this.getView().getFormShowParameter().getCustomParam("vid");
        DynamicObject hisStdDy = StdRsmServiceHelper.getStdRsmDy((Long)vid);
        this.fillResumeDy(hisStdDy, "sus");
        this.fillJobIntentionEntry(hisStdDy, "sus");
        DynamicObject[] hisStdPositionDys = HistoryServiceHelper.getStdRsmHis((String)"tsirm_stdposorgrel", (Long)vid);
        this.fillPositionEntry(hisStdPositionDys, "sus");
        DynamicObject[] hisStdEduDys = HistoryServiceHelper.getStdRsmHis((String)"tsirm_stdeduexp", (Long)vid);
        this.fillEduEntry(hisStdEduDys, "sus");
        DynamicObject[] hisStdWorkDys = HistoryServiceHelper.getStdRsmHis((String)"tsirm_stdworkexp", (Long)vid);
        this.fillWorkEntry(hisStdWorkDys, "sus");
        DynamicObject[] hisStdPrjDys = HistoryServiceHelper.getStdRsmHis((String)"tsirm_stdprjexp", (Long)vid);
        this.fillProjectEntry(hisStdPrjDys, "sus");
        DynamicObject[] hisStdLangAbl = HistoryServiceHelper.getStdRsmHis((String)"tsirm_stdlangabl", (Long)vid);
        this.fillLanguageEntry(hisStdLangAbl, "sus");
        DynamicObject[] hisStdRelationWork = HistoryServiceHelper.getStdRsmHis((String)"tsirm_stdrelationwork", (Long)vid);
        this.fillRelationEntry(hisStdRelationWork, "sus");
    }

    private void fillResumeDy(DynamicObject dy, String type) {
        String photoUrl = dy.getString("photo");
        if (photoUrl != null && photoUrl.length() > 0) {
            Image image = (Image)this.getControl("image_" + type);
            image.setUrl(HRImageUrlUtil.getImageFullUrl((String)photoUrl));
        }
        DynamicObject cvDy = StdRsmServiceHelper.getCVDy((Long)dy.getLong("id"));
        Container control = (Container)this.getControl(this.getTitle("personinfo", type));
        List<String> list = this.parseContainer(control, type);
        block13: for (String key : list) {
            String[] split = key.split("_");
            String prop = split[1];
            if (prop.contains("icon")) continue;
            Object obj = null;
            if ("company".equals(prop)) {
                obj = "sus".equals(type) ? CandidateDetailPageHelper.getCompany((Long)dy.getLong("id")) : CandidateDetailPageHelper.getCompany((Long)dy.getLong("sourcevid"));
            } else if ("recentposition".equals(prop)) {
                obj = "sus".equals(type) ? CandidateDetailPageHelper.getRecentPosition((Long)dy.getLong("id")) : CandidateDetailPageHelper.getRecentPosition((Long)dy.getLong("sourcevid"));
            } else if ("workexp".equals(prop)) {
                obj = ResumeAnalysisHelper.getWorkYearShow((int)Integer.parseInt(dy.getString("workingyears")));
            } else if ("employeenum".equals(prop)) {
                if (cvDy != null) {
                    obj = cvDy.get(prop);
                }
            } else {
                obj = dy.get(prop);
            }
            String str = Optional.ofNullable(obj).map(Object::toString).orElse("");
            if (obj instanceof DynamicObject) {
                String name = dy.getString(prop + ".name");
                if (HRStringUtils.isEmpty((String)name)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{key});
                    continue;
                }
                this.getModel().setValue(key, (Object)name);
                continue;
            }
            switch (prop) {
                case "politicsstatus": 
                case "natreg": 
                case "jobstatus": {
                    if (!Objects.isNull(obj)) continue block13;
                    this.getView().setVisible(Boolean.FALSE, new String[]{key});
                    continue block13;
                }
                case "nativeplace": 
                case "rgstprmtrsd": {
                    String fullName = "";
                    if (!HRStringUtils.isNotEmpty((String)str)) continue block13;
                    fullName = AdminDivisionHelper.fullName((long)Long.parseLong(str));
                    this.getModel().setValue(key, (Object)fullName);
                    continue block13;
                }
                case "workingyears": {
                    if (!HRStringUtils.isNotEmpty((String)str)) continue block13;
                    this.getModel().setValue(key, (Object)ResumeAnalysisHelper.getWorkYearShow((int)Integer.parseInt(str)));
                    continue block13;
                }
            }
            this.getModel().setValue(key, obj);
        }
    }

    private List<String> parseContainer(Container control, String type) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        List items = control.getItems();
        for (Control item : items) {
            if (item instanceof Container) {
                List<String> list = this.parseContainer((Container)item, type);
                result.addAll(list);
                continue;
            }
            String key = item.getKey();
            if (!key.startsWith(type)) continue;
            result.add(item.getKey());
        }
        return result;
    }

    private String getTitle(String titleName, String type) {
        return type.equals("cur") ? titleName : type + "_" + titleName;
    }

    private void fillPositionEntry(DynamicObject[] stdPositionDys, String type) {
        if (stdPositionDys.length == 0) {
            return;
        }
        String entryNumber = this.getTitle("pos_entry", type);
        List<DynamicObject> sortPositionDys = ExperiencesShowPlugin.getEntryDysOrdered(stdPositionDys);
        this.getModel().deleteEntryData(entryNumber);
        this.getModel().batchCreateNewEntryRow(entryNumber, sortPositionDys.size());
        CardEntry cardEntry = (CardEntry)this.getView().getControl(entryNumber);
        int index = 0;
        for (DynamicObject dy : sortPositionDys) {
            DynamicObject posType;
            DynamicObject position;
            DynamicObject adminOrg;
            String timeSlot = this.timeSlotHandle(dy);
            this.setTextValue("positionlot", timeSlot, type, index);
            int month = ResumeAnalysisHelper.calMonthByStartDate((Date)dy.getDate("startdate"), (Date)dy.getDate("endingdate"));
            this.setTextValue("lengthofposition", ResumeAnalysisHelper.getWorkYearShow((int)month), type, index);
            DynamicObject company = (DynamicObject)dy.get("company");
            if (company != null) {
                this.setTextValue("poscompany", company.getString("name"), type, index);
            }
            if ((adminOrg = (DynamicObject)dy.get("adminorg")) != null) {
                this.setTextValue("adminorg", adminOrg.getString("name"), type, index);
            }
            if ((position = (DynamicObject)dy.get("position")) != null) {
                this.setTextValue("posposition", position.getString("name"), type, index);
            }
            if ((posType = (DynamicObject)dy.get("postype")) != null) {
                this.setTextValue("postype", posType.getString("name"), type, index);
            }
            if (sortPositionDys.size() > 1) {
                Boolean isShowGuide = index == sortPositionDys.size() - 1 ? Boolean.FALSE : Boolean.TRUE;
                cardEntry.setChildVisible(isShowGuide.booleanValue(), index, new String[]{this.getTitle("position_guideline", type)});
            }
            ++index;
        }
    }

    private void fillEduEntry(DynamicObject[] stdEduDys, String type) {
        if (stdEduDys.length == 0) {
            return;
        }
        String entryNumber = this.getTitle("edu_entry", type);
        List<DynamicObject> sortEduDys = ExperiencesShowPlugin.getEntryDysOrdered(stdEduDys);
        this.getModel().deleteEntryData(entryNumber);
        this.getModel().batchCreateNewEntryRow(entryNumber, sortEduDys.size());
        CardEntry cardEntry = (CardEntry)this.getView().getControl(entryNumber);
        int index = 0;
        for (DynamicObject dy : sortEduDys) {
            DynamicObject educationForm;
            String timeSlot = this.timeSlotHandle(dy);
            this.setTextValue("edutimeslot", timeSlot, type, index);
            int month = ResumeAnalysisHelper.calMonthByStartDate((Date)dy.getDate("startdate"), (Date)dy.getDate("endingdate"));
            this.setTextValue("lengthofstudy", ResumeAnalysisHelper.getWorkYearShow((int)month), type, index);
            DynamicObject school = (DynamicObject)dy.get("schoolname");
            if (school != null) {
                if (HRStringUtils.equals((String)school.getString("number"), (String)"30000010_S")) {
                    this.setTextValue("schoolname", dy.getString("othschname"), type, index);
                } else {
                    this.setTextValue("schoolname", school.getString("name"), type, index);
                }
            }
            this.setTextValue("specialtyname", dy.getString("specialtyname"), type, index);
            DynamicObject education = (DynamicObject)dy.get("education");
            if (education != null) {
                this.setTextValue("education", education.getString("name"), type, index);
            }
            if ((educationForm = (DynamicObject)dy.get("educationform")) != null) {
                this.setTextValue("educationform", educationForm.getString("name"), type, index);
            }
            this.setTextValue("ishighestedu", dy.getString("ishighestedu"), type, index);
            if (sortEduDys.size() > 1) {
                Boolean isShowGuide = index == sortEduDys.size() - 1 ? Boolean.FALSE : Boolean.TRUE;
                cardEntry.setChildVisible(isShowGuide.booleanValue(), index, new String[]{this.getTitle("edu_guideline", type)});
            }
            ++index;
        }
    }

    private void fillWorkEntry(DynamicObject[] stdRsmWorkDys, String type) {
        if (stdRsmWorkDys.length == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{this.getTitle("jobbutton", type)});
            return;
        }
        String entryNumber = this.getTitle("job_entry", type);
        this.getModel().deleteEntryData(entryNumber);
        List<DynamicObject> sortWorkDys = ExperiencesShowPlugin.getEntryDysOrdered(stdRsmWorkDys);
        if (sortWorkDys.size() > 0) {
            this.getModel().batchCreateNewEntryRow(entryNumber, sortWorkDys.size());
            CardEntry cardEntry = (CardEntry)this.getView().getControl(entryNumber);
            int index = 0;
            for (DynamicObject dy : sortWorkDys) {
                String timeSlot = this.timeSlotHandle(dy);
                this.setTextValue("jobtimeslot", timeSlot, type, index);
                int month = ResumeAnalysisHelper.calMonthByStartDate((Date)dy.getDate("startdate"), (Date)dy.getDate("endingdate"));
                this.setTextValue("lengthofwork", ResumeAnalysisHelper.getWorkYearShow((int)month), type, index);
                this.setTextValue("companyname", dy.getString("companyname"), type, index);
                this.setTextValue("positionname", dy.getString("positionname"), type, index);
                this.setTextValue("workresponsibility", dy.getString("workresponsibility"), type, index);
                Boolean isShowGuide = index == sortWorkDys.size() - 1 ? Boolean.FALSE : Boolean.TRUE;
                cardEntry.setChildVisible(isShowGuide.booleanValue(), index, new String[]{entryNumber});
                ++index;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{this.getTitle("jobbutton", type)});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{this.getTitle("jobbutton", type)});
        }
    }

    private void fillProjectEntry(DynamicObject[] stdRsmPrjDys, String type) {
        if (stdRsmPrjDys.length == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{this.getTitle("probutton", type)});
            return;
        }
        String entryNumber = this.getTitle("pro_entry", type);
        this.getModel().deleteEntryData(entryNumber);
        List<DynamicObject> sortPrjDys = ExperiencesShowPlugin.getEntryDysOrdered(stdRsmPrjDys);
        this.getModel().batchCreateNewEntryRow(entryNumber, sortPrjDys.size());
        CardEntry cardEntry = (CardEntry)this.getView().getControl(entryNumber);
        int index = 0;
        for (DynamicObject dy : sortPrjDys) {
            String timeSlot = this.timeSlotHandle(dy);
            this.setTextValue("protimeslot", timeSlot, type, index);
            int month = ResumeAnalysisHelper.calMonthByStartDate((Date)dy.getDate("startdate"), (Date)dy.getDate("endingdate"));
            this.setTextValue("projectduration", ResumeAnalysisHelper.getWorkYearShow((int)month), type, index);
            this.setTextValue("projectname", dy.getString("projectname"), type, index);
            this.setTextValue("projectjob", dy.getString("projectjob"), type, index);
            this.setTextValue("projectresp", dy.getString("projectresp"), type, index);
            Boolean isShowGuide = index == sortPrjDys.size() - 1 ? Boolean.FALSE : Boolean.TRUE;
            cardEntry.setChildVisible(isShowGuide.booleanValue(), index, new String[]{this.getTitle("pro_guideline", type)});
            ++index;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{this.getTitle("probutton", type)});
    }

    private void fillLanguageEntry(DynamicObject[] stdRsmLangDys, String type) {
        if (stdRsmLangDys.length == 0) {
            return;
        }
        String entryNumber = this.getTitle("lang_entry", type);
        this.getModel().deleteEntryData(entryNumber);
        this.getModel().batchCreateNewEntryRow(entryNumber, stdRsmLangDys.length);
        int index = 0;
        for (DynamicObject dy : stdRsmLangDys) {
            this.setTextValue("languagename", dy.getDynamicObject("languagename") != null ? dy.getDynamicObject("languagename").getString("name") : null, type, index);
            this.setTextValue("listandspkabl", dy.getDynamicObject("listandspkabl") != null ? dy.getDynamicObject("listandspkabl").getString("name") : null, type, index);
            this.setTextValue("literacy", dy.getDynamicObject("literacy") != null ? dy.getDynamicObject("literacy").getString("name") : null, type, index);
            this.setTextValue("spoken", dy.getDynamicObject("spoken") != null ? dy.getDynamicObject("spoken").getString("name") : null, type, index);
            this.setTextValue("read", dy.getDynamicObject("read") != null ? dy.getDynamicObject("read").getString("name") : null, type, index);
            this.setTextValue("languagecert", dy.getDynamicObject("languagecert") != null ? dy.getDynamicObject("languagecert").getString("name") : null, type, index);
            this.setTextValue("certificatetitle", dy.getString("certificatetitle"), type, index);
            String langScore = dy.getBigDecimal("langcertscore") != null ? dy.getBigDecimal("langcertscore").stripTrailingZeros().toPlainString() : null;
            String showLangScore = "0".equals(langScore) ? null : langScore;
            this.setTextValue("langcertscore", showLangScore, type, index);
            ++index;
        }
    }

    private void fillRelationEntry(DynamicObject[] stdRsmLangDys, String type) {
        if (stdRsmLangDys.length == 0) {
            return;
        }
        String entryNumber = this.getTitle("relation_entry", type);
        this.getModel().deleteEntryData(entryNumber);
        this.getModel().batchCreateNewEntryRow(entryNumber, stdRsmLangDys.length);
        int index = 0;
        for (DynamicObject dy : stdRsmLangDys) {
            this.setTextValue("relfullname", dy.getString("fullname"), type, index);
            this.setTextValue("relation", dy.getString("relation"), type, index);
            this.setTextValue("department", dy.getString("department"), type, index);
            this.setTextValue("relphone", dy.getString("phone"), type, index);
            ++index;
        }
    }

    private void fillJobIntentionEntry(DynamicObject stdRsmDys, String type) {
        if (stdRsmDys == null) {
            return;
        }
        this.setTextValue("isrelationwork", this.isYesOrNo(stdRsmDys.getString("isrelationwork")), type, -1);
        String entryNumber = this.getTitle("jobinte_entry", type);
        this.getModel().deleteEntryData(entryNumber);
        this.getModel().batchCreateNewEntryRow(entryNumber, 1);
        this.setTextValue("expccity", stdRsmDys.getDynamicObject("expccity") != null ? stdRsmDys.getDynamicObject("expccity").getString("name") : null, type, 0);
        this.setTextValue("expcfunction", stdRsmDys.getDynamicObject("expcfunction") != null ? stdRsmDys.getDynamicObject("expcfunction").getString("name") : null, type, 0);
        this.setTextValue("iscompemp", this.isYesOrNo(stdRsmDys.getString("iscompemp")), type, 0);
        this.setTextValue("accplacechange", this.isYesOrNo(stdRsmDys.getString("accplacechange")), type, 0);
    }

    private String timeSlotHandle(DynamicObject item) {
        String noVal;
        String start = noVal = ResManager.loadKDString((String)"\u672a\u77e5", (String)"SuspectedResumePlugin_5", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
        String end = noVal;
        if (item.get("startdate") != null) {
            String string = start = HRStringUtils.isEmpty((String)item.get("startdate").toString()) ? noVal : HRInteDateTimeUtil.formatDate((String)"tsirm_stdposorgrel", (String)"startdate", (Date)item.getDate("startdate"));
        }
        if (item.get("endingdate") != null) {
            String string = end = HRStringUtils.isEmpty((String)item.get("endingdate").toString()) ? noVal : HRInteDateTimeUtil.formatDate((String)"tsirm_stdposorgrel", (String)"endingdate", (Date)item.getDate("startdate"));
        }
        if (HRStringUtils.equals((String)start, (String)noVal) && HRStringUtils.equals((String)end, (String)noVal)) {
            return ResManager.loadKDString((String)"\u65f6\u95f4\u672a\u77e5", (String)"SuspectedResumePlugin_6", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
        }
        if (item.getDate("startdate") != null && item.getDate("startdate").getTime() > System.currentTimeMillis()) {
            return start + " " + ResManager.loadKDString((String)"\u81f3\u4eca", (String)"ExperiencesShowPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
        }
        return start + " " + ResManager.loadKDString((String)"\u81f3", (String)"SuspectedResumePlugin_7", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]) + " " + end;
    }

    private String isYesOrNo(String value) {
        if (Objects.isNull(value)) {
            return ResManager.loadKDString((String)"\u5426", (String)"SrRsmKDString_71", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
        }
        return IS_RELATION_WORK.get(value);
    }

    private void setTextValue(String titleName, String value, String type, int index) {
        if (HRStringUtils.isNotEmpty((String)value)) {
            if (index == -1) {
                this.getModel().setValue(this.getTitle(titleName, type), (Object)value);
            } else {
                this.getModel().setValue(this.getTitle(titleName, type), (Object)value, index);
            }
        }
    }

    public static List<DynamicObject> getEntryDysOrdered(DynamicObject[] dys) {
        List entryDysOrdered = Lists.newArrayListWithCapacity((int)dys.length);
        if (dys.length > 0) {
            entryDysOrdered = CandidateSortUtil.sortExperience((DynamicObject[])dys, (String)"startdate", (String)"endingdate", (String)"createtime");
        }
        return entryDysOrdered;
    }

    static {
        IS_RELATION_WORK.put("0", ResManager.loadKDString((String)"\u5426", (String)"SrRsmKDString_71", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        IS_RELATION_WORK.put("1", ResManager.loadKDString((String)"\u662f", (String)"SrRsmKDString_70", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
    }
}

