/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.talentpool;

import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsirm.common.util.talentpool.CandidateSortUtil;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.enums.LabelTagObjTypeEnum;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import org.apache.commons.lang3.StringUtils;

public class TalentPoolListDetailPlugin
extends HRDataBaseList
implements ClickListener {
    private static final String LABEL_PANEL = "label_panel";

    public void afterCreateNewData(EventObject eventObject) {
        String pkId = (String)this.getView().getFormShowParameter().getCustomParam("pkId");
        String childPagesStr = this.getView().getParentView().getPageCache().get("childpages");
        Map childPages = HRStringUtils.isNotEmpty((String)childPagesStr) ? (Map)SerializationUtils.fromJsonString((String)childPagesStr, Map.class) : Maps.newHashMap();
        if (!HRObjectUtils.equals(childPages.get(pkId), (Object)this.getView().getFormShowParameter().getPageId())) {
            childPages.put(pkId, this.getView().getFormShowParameter().getPageId());
            this.getView().getParentView().getPageCache().put("childpages", SerializationUtils.toJsonString(childPages));
        }
    }

    public void beforeBindData(EventObject eventObject) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String pkId = (String)parameter.getCustomParam("pkId");
        if (pkId == null) {
            return;
        }
        HRBaseServiceHelper stdServiceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_stdrsm");
        String selectStd = "id,photo,phone,email,sourcevid";
        QFilter stdFilter = new QFilter("id", "in", (Object)Long.parseLong(pkId));
        Object[] stdDynObj = stdServiceHelper.query("id,photo,phone,email,sourcevid", new QFilter[]{stdFilter});
        if (HRArrayUtils.isEmpty((Object[])stdDynObj)) {
            return;
        }
        String souId = stdDynObj[0].getString("sourcevid");
        if (souId == null) {
            return;
        }
        Image head = (Image)this.getControl("photo");
        if (stdDynObj[0].get("photo") != null && !"".equals(stdDynObj[0].get("photo"))) {
            head.setUrl(HRImageUrlUtil.getImageFullUrl((String)stdDynObj[0].get("photo").toString()));
        }
        this.setHigSchoolData(souId);
        this.setWorkExpData(souId);
        this.setLabelInfo(souId);
    }

    private void setHigSchoolData(String pkId) {
        QFilter degreeFilter;
        HRBaseServiceHelper eduServiceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_stdeduexp");
        String selectPro = "id,ishighestedu,schoolname,specialtyname,education";
        QFilter eduFilter = new QFilter("stdrsm", "=", (Object)Long.parseLong(pkId));
        Object[] dynObj = eduServiceHelper.query("id,ishighestedu,schoolname,specialtyname,education", new QFilter[]{eduFilter, degreeFilter = new QFilter("ishighestedu", "=", (Object)"1")});
        if (HRArrayUtils.isEmpty((Object[])dynObj)) {
            return;
        }
        for (Object dynamicObject : dynObj) {
            if (!((Boolean)dynamicObject.get("ishighestedu")).booleanValue()) continue;
            Label schoolLab = (Label)this.getControl("schoolname");
            schoolLab.setText(dynamicObject.get("schoolname") != null ? dynamicObject.getDynamicObject("schoolname").get("name").toString() : null);
            Label majorLab = (Label)this.getControl("specialtyname");
            Object object = dynamicObject.get("specialtyname");
            majorLab.setText(object != null ? object.toString() : null);
            Label degreeLab = (Label)this.getControl("education");
            degreeLab.setText(dynamicObject.get("education") != null ? dynamicObject.getDynamicObject("education").get("name").toString() : null);
        }
    }

    private void setWorkExpData(String pkId) {
        StringBuilder stringBuilder;
        String lengthOfWork;
        int workTime;
        Date endDate;
        Date startDate;
        HRBaseServiceHelper workServiceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_stdworkexp");
        String selectPro = "id,startdate,endingdate,createtime,companyname,positionname";
        QFilter workFilter = new QFilter("stdrsm", "=", (Object)Long.parseLong(pkId));
        DynamicObject[] dynObj = workServiceHelper.query("id,startdate,endingdate,createtime,companyname,positionname", new QFilter[]{workFilter});
        List objects = CandidateSortUtil.sortExperience((DynamicObject[])dynObj, (String)"startdate", (String)"endingdate", (String)"createtime");
        if (objects.size() > 0) {
            Label firstNameLab = (Label)this.getControl("companyfirstname");
            firstNameLab.setText(((DynamicObject)objects.get(0)).get("companyname") != null ? ((DynamicObject)objects.get(0)).get("companyname").toString() : null);
            Label firstPositionLab = (Label)this.getControl("companyfirstposition");
            firstPositionLab.setText(((DynamicObject)objects.get(0)).get("positionname") != null ? ((DynamicObject)objects.get(0)).get("positionname").toString() : null);
            startDate = ((DynamicObject)objects.get(0)).getDate("startdate");
            endDate = ((DynamicObject)objects.get(0)).getDate("endingdate");
            Label firstTimeLab = (Label)this.getControl("companyfirsttime");
            firstTimeLab.setText(this.formatDataInfo(startDate, endDate));
            workTime = ResumeAnalysisHelper.calMonthByStartDate((Date)startDate, (Date)endDate);
            lengthOfWork = ResumeAnalysisHelper.getWorkYearShow((int)workTime);
            stringBuilder = new StringBuilder();
            stringBuilder.append('(');
            stringBuilder.append(lengthOfWork);
            stringBuilder.append(')');
            lengthOfWork = StringUtils.isBlank((CharSequence)lengthOfWork) ? "" : stringBuilder.toString();
            Label firstCountLab = (Label)this.getControl("companyfirstcount");
            firstCountLab.setText(lengthOfWork);
        }
        if (objects.size() > 1) {
            Label secondNameLab = (Label)this.getControl("companysecondname");
            secondNameLab.setText(((DynamicObject)objects.get(1)).get("companyname") != null ? ((DynamicObject)objects.get(1)).get("companyname").toString() : null);
            Label secondPositionLab = (Label)this.getControl("companysecondposition");
            secondPositionLab.setText(((DynamicObject)objects.get(1)).get("positionname") != null ? ((DynamicObject)objects.get(1)).get("positionname").toString() : null);
            startDate = ((DynamicObject)objects.get(1)).getDate("startdate");
            endDate = ((DynamicObject)objects.get(1)).getDate("endingdate");
            Label secondTimeLab = (Label)this.getControl("companysecondtime");
            secondTimeLab.setText(this.formatDataInfo(startDate, endDate));
            workTime = ResumeAnalysisHelper.calMonthByStartDate((Date)startDate, (Date)endDate);
            lengthOfWork = ResumeAnalysisHelper.getWorkYearShow((int)workTime);
            stringBuilder = new StringBuilder();
            stringBuilder.append('(');
            stringBuilder.append(lengthOfWork);
            stringBuilder.append(')');
            lengthOfWork = StringUtils.isBlank((CharSequence)lengthOfWork) ? "" : stringBuilder.toString();
            Label secondCountLab = (Label)this.getControl("companysecondcount");
            secondCountLab.setText(lengthOfWork);
        }
    }

    private void setLabelInfo(String pkId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsrbd_label_show");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(LABEL_PANEL);
        showParameter.setCustomParam("id", (Object)pkId);
        showParameter.setCustomParam("type", (Object)String.valueOf(LabelTagObjTypeEnum.IN_STDRSM.getId()));
        showParameter.setCustomParam("isshowbutton", (Object)Boolean.FALSE);
        showParameter.setCustomParam("ishidemorebtn", (Object)Boolean.TRUE);
        showParameter.setCustomParam("pagetype", (Object)"detail");
        showParameter.setSendToClient(true);
        showParameter.setCustomParam("excludeCategorys", null);
        this.getView().showForm(showParameter);
    }

    private String formatDataInfo(Date startDate, Date endDate) {
        SimpleDateFormat yearMonthFormat = new SimpleDateFormat("yyyy-MM-dd");
        String startTime = "";
        String endTime = "";
        if (startDate == null && endDate == null) {
            return null;
        }
        if (startDate != null) {
            startTime = yearMonthFormat.format(startDate);
        }
        if (endDate != null) {
            endTime = yearMonthFormat.format(endDate);
        }
        return startTime + "~" + endTime;
    }
}

