/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.talentpool;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.ksql.util.StringUtil;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.list.AppFileListHelper;
import kd.tsc.tsirm.business.domain.cert.CertService;
import kd.tsc.tsirm.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.service.StdRsmCommonService;
import kd.tsc.tsirm.business.domain.talentpool.entity.TalentPoolFallMessage;
import kd.tsc.tsirm.business.domain.talentpool.helper.TalentPoolFunHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.CheckPermissionHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentListDaoHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentListFunService;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentListServiceHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtHelper;
import kd.tsc.tsirm.business.license.TSIRMCertCommonHelper;
import kd.tsc.tsirm.common.constants.appfile.AppFileListConstants;
import kd.tsc.tsirm.common.constants.talentpool.TSTPMTalentPoolConstants;
import kd.tsc.tsirm.formplugin.service.TalentPoolAsyncService;
import kd.tsc.tsirm.formplugin.service.TalentPoolService;
import kd.tsc.tsrbd.business.application.external.auth.TSCBizDataPermService;
import kd.tsc.tsrbd.business.application.external.person.BizHRPIEmployeeService;
import kd.tsc.tsrbd.business.domain.common.service.HRUserService;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tsrbd.common.kdstring.TSCBaseKDString;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsrbs.common.utils.GenerateFormShowParamUtils;
import kd.tsc.tsrbs.common.utils.TscTreeUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class TalentPoolListPlugin
extends AbstractTreeListPlugin {
    private static final int FULLNAMEMAXLENGTG = 40;
    private static final String CANDIDATEIDSWITHRIGHTS = "candidateidswithrights";
    private static final Log logger = LogFactory.getLog(TalentPoolListPlugin.class);
    private static final String CUSTOM_STYLE = "eyJ0eXBlIjowLCJjb250ZW50IjoiwqAvKiogXG4qIOagt+S+i1xuKiDmlK/mjIHljp/nlJ9jc3PmoLflvI/lhpnms5Vcbiog5b2T5YmN5YWD57Sg55qEY2xhc3NOYW1l5L2/55SoIFwiJFwiIOS7o+abv++8jOS4jeaUr+aMgeiHquWumuS5ieWFg+e0oGNsYXNzTmFtZVxuKiDnm67liY3mj5DkvpvkuInkuKrmoLfmnb/vvIzmiZPlvIDms6jph4rljbPlj6/kvb/nlKhcbiog5rOo6YeK5YaF5a655Lya6KKr6L+H5ruk5LiN5bGV56S6XG4qIOWmgumcgOS9v+eUqOW5s+WPsOS4u+mimOiJsu+8jOWPr+S7peS9v+eUqCd0aGVtZUNvbG9yJ+adpeS7o+aMh1xuICovXG4vKipcbiog5b2T5YmN5YWD57Sg6IOM5pmv6aKc6Imy6Lef6ZqP5Li76aKY6ImyXG4qL1xuLyoqXG4kIHtcbsKgwqBiYWNrZ3JvdW5kOid0aGVtZUNvbG9yJztcbsKgfVxuKi9cbsKgLyoqXG4qIOS/ruaUueW9k+WJjeWFg+e0oOiDjOaZr+minOiJslxuKi9cbi8qKlxuJCB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG7CoC8qKlxuKiDkv67mlLnlvZPliY3lhYPntKBob3ZlcuaViOaenFxuwqAgKi9cbi8qKlxuJDpob3ZlciB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG4vKipcbiAqIOS/ruaUueW9k+WJjeWFg+e0oOS4umRpduagh+etvuWtkOWFg+e0oFxuKi9cbi8qKlxuJCA+IGRpdiB7XG7CoGJhY2tncm91bmQ6cmVkO1xuwqB9XG4gKi9cbltjb2wtaWQ9J21lcmdlbGlzdGNvbHVtbmFwJ10gLkNlbGxDbGFzc19jb21iaW5lZEZpZWxkX3JlbmRlcl8yWGxxIC5DZWxsQ2xhc3NfY29tYmluZWRJdGVtXzIxVWkge1xub3ZlcmZsb3c6aGlkZGVuO1xuZmxleC1ncm93OiAwO1xufVxuW2NvbC1pZD0nbWVyZ2VsaXN0Y29sdW1uYXAnXSAuQ2VsbENsYXNzX2NvbWJpbmVkRmllbGRfcmVuZGVyXzJYbHEgLkNlbGxDbGFzc19jb21iaW5lZEl0ZW1fMjFVaTpudGgtY2hpbGQoMiksXG5bY29sLWlkPSdtZXJnZWxpc3Rjb2x1bW5hcCddIC5DZWxsQ2xhc3NfY29tYmluZWRGaWVsZF9yZW5kZXJfMlhscSAuQ2VsbENsYXNzX2NvbWJpbmVkSXRlbV8yMVVpOm50aC1jaGlsZCgzKSAge1xuZmxleC1zaHJpbms6IDA7XG5mbGV4LWdyb3c6IDA7XG59XG5bY29sLWlkPSdtZXJnZWxpc3Rjb2x1bW5hcCddIC5DZWxsQ2xhc3NfY29tYmluZWRGaWVsZF9yZW5kZXJfMlhscSAuQ2VsbENsYXNzX2NvbWJpbmVkSXRlbV8yMVVpOm50aC1jaGlsZCgyKSBpbWd7XG53aWR0aDogMTJweDtcbmhlaWdodDogMTJweDtcbm1hcmdpbi1yaWdodDogLTFweDtcbn0ifQ==";
    private static final String NOTBTNKEY = "<>";

    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{"filtercontainerap"});
        Search searchListener = (Search)this.getControl("searchap");
        searchListener.addEnterListener((SearchEnterListener)this);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        HashMap<String, String> ctrl = new HashMap<String, String>(1);
        ctrl.put("cstyles", CUSTOM_STYLE);
        this.getView().updateControlMetadata("splitpanelap1", ctrl);
        String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
        this.getView().setVisible(Boolean.valueOf(!StringUtils.equals((CharSequence)currentNodeId, (CharSequence)"1020") && !StringUtils.equals((CharSequence)currentNodeId, (CharSequence)"1030")), new String[]{"iscontainlower1"});
        this.cacheCurrentPage();
    }

    private void cacheCurrentPage() {
        ListSelectedRowCollection currentListAllRowCollection = this.getCurrentListAllRowCollection();
        Object[] primaryKeyValues = currentListAllRowCollection.getPrimaryKeyValues();
        List stdList = TsrbsHelper.selectByFilter((String)"id,talentpool.fbasedataid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)}, (String)"tsirm_stdrsm");
        HashMap stdReserveMap = Maps.newHashMapWithExpectedSize((int)stdList.size());
        stdList.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject.getDynamicObjectCollection("talentpool"))).forEach((stdId, dynamicObjectCollection) -> stdReserveMap.put(stdId, dynamicObjectCollection.stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList())));
        String preCache = this.getPageCache().get("currentNodeId");
        HashMap needUpdateMap = Maps.newHashMapWithExpectedSize((int)stdList.size());
        Map<Long, List> currentReserveMap = new HashMap();
        if (!HRStringUtils.isBlank((CharSequence)preCache)) {
            currentReserveMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("currentNodeId"));
            currentReserveMap.forEach((stdId, list) -> {
                List currentIdList = (List)stdReserveMap.get(stdId);
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)currentIdList)) {
                    return;
                }
                needUpdateMap.put(stdId, list);
                stdReserveMap.remove(stdId);
            });
        }
        currentReserveMap.putAll(stdReserveMap);
        currentReserveMap.putAll(needUpdateMap);
        this.getPageCache().put("currentNodeId", SerializationUtils.serializeToBase64(currentReserveMap));
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
        TreeListModel treeListModel = (TreeListModel)this.treeListView.getTreeModel();
        treeListModel.setGobackToRoot(false);
    }

    public void preOpenForm(PreOpenFormEventArgs preOpenFormEventArgs) {
        super.preOpenForm(preOpenFormEventArgs);
        if (!CheckPermissionHelper.getInstance().checkTstpmPermission()) {
            preOpenFormEventArgs.setCancel(true);
        }
        ListShowParameter parameter = (ListShowParameter)preOpenFormEventArgs.getSource();
        parameter.setFormId("tsirm_talentpool_treelist");
    }

    public void initializeTree(EventObject eventObject) {
        logger.info("TalentPoolListPlugin.initializeTree.start");
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        this.createTalentTree(treeView);
        logger.info("TalentPoolListPlugin.initializeTree.end");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.setHomePageJumpParam(args);
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        if (HRStringUtils.equals((String)"gender", (String)fieldName)) {
            QFilter qfilter = new QFilter("enable", "=", (Object)"1");
            args.getQFilters().add(qfilter);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        long sTime = System.currentTimeMillis();
        super.beforeCreateListDataProvider(args);
        long eTime = System.currentTimeMillis();
        logger.info("TalentPoolListPlugin.beforeCreateListDataProvider.duration->{}", (Object)(eTime - sTime));
    }

    public void search(SearchEnterEvent event) {
        super.search(event);
        String searchText = event.getText();
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        ITreeListView treeListView = this.getTreeListView();
        TscTreeUtils.searchTalentTree((String)searchText, (IFormView)view, (IPageCache)pageCache, (ITreeListView)treeListView);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent buildTreeListFilterEvent) {
        long sTime = System.currentTimeMillis();
        super.buildTreeListFilter(buildTreeListFilterEvent);
        String talentPoolId = (String)buildTreeListFilterEvent.getNodeId();
        this.treeListView.getTreeModel().getGroupProp();
        this.getView().getPageCache().put("OTHERS", ResumeHisDataStatusEnum.EFFECTING.getStatus());
        DynamicObject dynObj = TalentListDaoHelper.getInstance().getTalentPool(talentPoolId);
        if (dynObj == null || dynObj.get("number") == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u4eba\u624d\u5e93\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TALENTLIST_22", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            buildTreeListFilterEvent.addQFilter(new QFilter("id", "=", (Object)0));
            return;
        }
        long creator = -9999999999L;
        if (dynObj.getDynamicObject("creator") != null) {
            creator = dynObj.getDynamicObject("creator").getLong("id");
        }
        DynamicObject[] dynObjAllChild = TalentListDaoHelper.getInstance().getSubTalentPool(talentPoolId, dynObj, Long.valueOf(creator));
        ListShowParameter lsp = (ListShowParameter)this.getView().getFormShowParameter();
        DynamicObject[] hasPermTalentPools = CheckPermissionHelper.getInstance().selectComPerTalentPool("tsirm_stdrsm", "47150e89000000ac", lsp.getBillFormId());
        List<Long> hasPermTalentPoolIdList = new ArrayList<Long>();
        if (ObjectUtils.isNotEmpty((Object)hasPermTalentPools)) {
            hasPermTalentPoolIdList = Arrays.stream(hasPermTalentPools).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        }
        if (dynObjAllChild == null) {
            return;
        }
        this.buildTreeFilter(buildTreeListFilterEvent, dynObjAllChild, hasPermTalentPoolIdList, talentPoolId, sTime);
    }

    private void buildTreeFilter(BuildTreeListFilterEvent buildTreeListFilterEvent, DynamicObject[] dynObjAllChild, List<Long> hasPermTalentPoolIdList, String talentPoolId, long sTime) {
        boolean ifTalentPool;
        QFilter qFilter2;
        ArrayList childIdList = Lists.newArrayListWithCapacity((int)dynObjAllChild.length);
        for (DynamicObject dynamicObject : dynObjAllChild) {
            if (!hasPermTalentPoolIdList.contains(dynamicObject.getLong("id"))) continue;
            childIdList.add(dynamicObject.getLong("id"));
        }
        AuthorizedOrgResult authorizedOrgResult = TSCBizDataPermService.getUserAdminOrgsF7((Long)RequestContext.get().getCurrUserId(), (String)"tsirm", (String)"tsirm_stdrsm", (String)"47150e89000000ac", (String)"adminorg", null);
        List hasPermOrgs = authorizedOrgResult.getHasPermOrgs();
        boolean hasAllOrgPerm = authorizedOrgResult.isHasAllOrgPerm();
        QFilter qFilter1 = new QFilter("status", "=", (Object)"C").and("labrelstatuscls.id", "in", (Object)CheckPermissionHelper.dimLabRelStatusIdList);
        if (hasAllOrgPerm) {
            qFilter2 = new QFilter("status", "=", (Object)"B");
            qFilter2.and(new QFilter("rsmpubscope", "in", (Object)Lists.newArrayList((Object[])new String[]{"A", "B"})));
            qFilter1.or(qFilter2);
        } else if (ObjectUtils.isNotEmpty((Object)hasPermOrgs)) {
            qFilter2 = new QFilter("status", "=", (Object)"B");
            qFilter2.and(new QFilter("rsmpubscope", "=", (Object)"A"));
            if (hasPermOrgs.size() == 1) {
                qFilter2.and(new QFilter("currdepartment.id", "not in", (Object)hasPermOrgs));
            }
            qFilter2.or(new QFilter("status", "=", (Object)"B").and(new QFilter("rsmpubscope", "=", (Object)"B")).and(new QFilter("adminorgs.fbasedataid", "in", (Object)hasPermOrgs)));
            qFilter1.or(qFilter2);
        }
        boolean containLower = (Boolean)this.getModel().getValue("iscontainlower1");
        QFilter qFilter3 = new QFilter("talentpool.fbasedataid", "in", (Object)childIdList);
        boolean bl = ifTalentPool = "1020".equals(talentPoolId) || "0".equals(talentPoolId) || "1030".equals(talentPoolId);
        if (!containLower && !ifTalentPool) {
            qFilter3 = new QFilter("talentpool.fbasedataid", "=", (Object)Long.parseLong(talentPoolId));
        }
        String appId = BizAppServiceHelp.getAppIdByFormNum((String)"tsirm_stdrsm");
        QFilter dataRuleFilter = PermissionServiceHelper.getDataRule((long)RequestContext.get().getCurrUserId(), (String)appId, (String)"tsirm_stdrsm", (String)"47150e89000000ac");
        qFilter1.and(dataRuleFilter);
        qFilter3.and(qFilter1);
        buildTreeListFilterEvent.addQFilter(qFilter3);
        this.getView().setVisible(Boolean.valueOf(!ImmutableList.of((Object)TSTPMTalentPoolConstants.ON_JOB_TP_ALLOCATED, (Object)TSTPMTalentPoolConstants.DIMI_TP_ALLOCATED).contains((Object)Long.parseLong(talentPoolId))), new String[]{"removetalent"});
        long eTime = System.currentTimeMillis();
        logger.info("TalentPoolListPlugin.buildTreeListFilter.duration->{}", (Object)(eTime - sTime));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("iscontainlower1".equals(name)) {
            Object currentNodeId = this.getTreeModel().getCurrentNodeId();
            this.getTreeListView().refreshTreeNode(currentNodeId.toString());
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        logger.info("TalentPoolListPlugin.setFilter.start");
        long sTime = System.currentTimeMillis();
        setFilterEvent.setDataPermQFilters(new ArrayList());
        List filterList = setFilterEvent.getQFilters().stream().filter(qFilter -> AppFileListConstants.KEY_WORKINGYEARSCOMBO.equals(qFilter.getProperty())).collect(Collectors.toList());
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(filterList)) {
            AppFileListHelper.setWorkingYearsQFilterStdrsm((SetFilterEvent)setFilterEvent, (String)((QFilter)filterList.get(0)).getValue().toString());
        }
        setFilterEvent.getQFilters().removeIf(qFilter -> AppFileListConstants.KEY_WORKINGYEARSCOMBO.equals(qFilter.getProperty()));
        setFilterEvent.getQFilters().removeIf(qFilter -> "datastatus != '-1'".equals(qFilter.getProperty()));
        String status = this.getView().getPageCache().get("OTHERS");
        if (!ResumeHisDataStatusEnum.BLACK_LIST.getStatus().equals(status)) {
            setFilterEvent.setMainOrgQFilter(new QFilter("datastatus", "!=", (Object)ResumeHisDataStatusEnum.BLACK_LIST.getStatus()));
            setFilterEvent.setOrderBy("modifytime desc");
        }
        super.setFilter(setFilterEvent);
        long eTime = System.currentTimeMillis();
        logger.info("TalentPoolListPlugin.setFilter.duration->{}", (Object)(eTime - sTime));
    }

    private void setHomePageJumpParam(FilterContainerInitArgs args) {
        ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (parameter.isLookUp()) {
            return;
        }
        Map map = parameter.getCustomParams();
        if (map != null && map.size() > 0) {
            Object search = map.get("combofield");
            if (search == null) {
                return;
            }
            List fastFilterColumns = args.getFastFilterColumns();
            int index = Integer.parseInt(search.toString());
            ((FilterColumn)fastFilterColumns.get(index)).setDefaultValues(new Object[]{map.get("searchtext")});
        }
    }

    private void createTalentTree(TreeView treeView) {
        ListShowParameter lsp = (ListShowParameter)this.getView().getFormShowParameter();
        TreeNode root = TalentListServiceHelper.getInstance().createTalentTree(lsp.getBillFormId());
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setRootVisable(false);
        treeView.addNode(root);
        treeView.focusNode((TreeNode)root.getChildren().get(0));
        this.getPageCache().put(treeView.getKey(), SerializationUtils.toJsonString((Object)root));
        this.getTreeModel().setCurrentNodeId((Object)((TreeNode)root.getChildren().get(0)).getId());
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        long candidateId = (Long)billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        this.openStdRsmDetails(candidateId);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        args.setCancel(true);
        IListView listView = (IListView)this.getView();
        String candidateId = listView.getFocusRowPkId().toString();
        Long candiDateL = Long.parseLong(candidateId);
        switch (fieldName = args.getHyperLinkClickEvent().getFieldName()) {
            case "fullname": {
                long resumeId = Long.parseLong(candidateId);
                String appId = BizAppServiceHelp.getAppIdByFormNum((String)"tsirm_stdrsm");
                QFilter dataRuleFilter = PermissionServiceHelper.getDataRule((long)RequestContext.get().getCurrUserId(), (String)appId, (String)"tsirm_stdrsm", (String)"47150e89000000ac");
                boolean exists = StdRsmServiceHelper.isExists((QFilter[])new QFilter[]{new QFilter("id", "=", (Object)resumeId).and(dataRuleFilter)});
                if (!exists) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709[\u67e5\u770b][\u6807\u51c6\u7b80\u5386]\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TalentPoolListPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                boolean hasStdRsmViewPermission = StdRsmCommonService.getInstance().queryStdRsmViewPermission(candiDateL);
                if (!hasStdRsmViewPermission) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u5019\u9009\u4eba\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"TalentPoolListPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.openStdRsmDetails(resumeId);
                break;
            }
            case "positionnum": {
                this.showApplyPositionList(candidateId);
                break;
            }
            case "talentpoolnum": {
                this.showTalentPoolList(candidateId);
                break;
            }
        }
    }

    private void openStdRsmDetails(long candidateId) {
        String status = this.getView().getPageCache().get("OTHERS");
        DynamicObject[] stdRsmStatusData = TalentListDaoHelper.getInstance().getStdRsmStatusData(Long.valueOf(candidateId), status);
        if (stdRsmStatusData != null && stdRsmStatusData.length > 0) {
            if (CheckPermissionHelper.getInstance().isCurTalentAuth(candidateId)) {
                CloseCallBack closeCallBackSend = new CloseCallBack((IFormPlugin)this, "fullname");
                TalentListServiceHelper.getInstance().formShowCandidate(Long.valueOf(candidateId), this.getView(), closeCallBackSend);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u5019\u9009\u4eba\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"TalentPoolListPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.showRefreshPageTips();
            return;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("tblrefresh".equals(itemKey)) {
            Object currentNodeId = this.getTreeModel().getCurrentNodeId();
            this.getTreeListView().refreshTreeNode(currentNodeId.toString());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        boolean success = afterDoOperationEventArgs.getOperationResult().isSuccess();
        if (!success) {
            return;
        }
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)allErrorOrValidateInfo)) {
            this.getView().showOperationResult(operationResult);
            return;
        }
        List<Long> candidateIds = this.getSelectedRows().stream().map(row -> Long.parseLong(row.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        String key = this.getKey(operateKey);
        if (HRStringUtils.isNotEmpty((String)key)) {
            this.handleOpButton(key, candidateIds);
            return;
        }
        if ("storretotalentpool_right".equals(operateKey) || "removefromtalentpool_right".equals(operateKey) || "recommdtoposition_right".equals(operateKey)) {
            FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
            OperateOption option = formOperate.getOption();
            String actionId = option.getVariableValue("actionId");
            String returnData = option.getVariableValue("returnData");
            ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)SerializationUtils.fromJsonString((String)returnData, ListSelectedRowCollection.class);
            this.closeCallBackSwitch(actionId, actionId, listSelectedRows);
        }
    }

    private String getKey(String operateKey) {
        switch (operateKey) {
            case "storetotalentpool": {
                operateKey = "savetalent";
                break;
            }
            case "removefromtalentpool": {
                operateKey = "removetalent";
                break;
            }
            case "recommendtoposition": {
                operateKey = "selectposition";
                break;
            }
            default: {
                operateKey = "";
            }
        }
        return operateKey;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean hasStdRsmViewPermission;
        List<Long> candidateIds = this.getSelectedRows().stream().map(row -> Long.parseLong(row.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        String key = this.getKey(operateKey);
        if (candidateIds.size() == 1 && HRStringUtils.isNotEmpty((String)key) && !(hasStdRsmViewPermission = StdRsmCommonService.getInstance().queryStdRsmViewPermission((Long)candidateIds.get(0)))) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u5019\u9009\u4eba\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"TalentPoolListPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (key) {
            case "savetalent": 
            case "removetalent": 
            case "selectposition": {
                if (this.judgeIsSelectCandidate(candidateIds)) {
                    args.setCancel(true);
                    return;
                }
                if (this.checkDataChanged(candidateIds)) {
                    args.setCancel(true);
                    return;
                }
                ListSelectedRowCollection selectedRows = this.getSelectedRows();
                if ("selectposition".equals(key)) {
                    if (this.verifyCert(candidateIds)) {
                        args.setCancel(true);
                        return;
                    }
                    if (selectedRows.size() <= 20) break;
                    args.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u4ee5\u9009\u62e920\u4e2a\u5019\u9009\u4eba\u8fdb\u884c\u63a8\u8350\u3002", (String)"TalentPoolListPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if ("savetalent".equals(key)) {
                    if (selectedRows.size() <= 500) break;
                    args.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u4ee5\u9009\u62e9500\u4e2a\u5019\u9009\u4eba\u8fdb\u884c\u50a8\u5907\u3002", (String)"TalentPoolListPlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (selectedRows.size() <= 500) break;
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u4ee5\u9009\u62e9500\u4e2a\u5019\u9009\u4eba\u79fb\u9664\u4eba\u624d\u5e93\u3002", (String)"TalentPoolListPlugin_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            case "tblrefresh": {
                this.refreshChildViews();
                this.getTreeListView().refreshTreeNode(this.getTreeModel().getCurrentNodeId().toString());
                break;
            }
            case "tblclose": {
                this.getView().close();
                break;
            }
        }
        if (CheckPermissionHelper.getInstance().checkDelBlackPermission(candidateIds) && HRStringUtils.isNotEmpty((String)key)) {
            this.showRefreshPageTips();
        }
    }

    private void handleOpButton(String key, List<Long> candidateIds) {
        this.buttonSwitch(key, candidateIds);
    }

    private void buttonSwitch(String key, List<Long> candidateIds) {
        switch (key) {
            case "savetalent": {
                this.judgeIsEjectTips(key, candidateIds, "savetalent");
                break;
            }
            case "removetalent": {
                this.judgeIsEjectTips(key, candidateIds, "removetalent");
                break;
            }
            case "selectposition": {
                this.judgeIsEjectTips(key, candidateIds, "selectposition");
                break;
            }
            case "tblrefresh": {
                this.refreshChildViews();
                this.getTreeListView().refreshTreeNode(this.getTreeModel().getCurrentNodeId().toString());
                break;
            }
            case "tblclose": {
                this.getView().close();
                break;
            }
        }
    }

    private boolean judgeIsSelectCandidate(List<Long> candidateIds) {
        if (candidateIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TalentPoolListPlugin_7", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void judgeIsEjectTips(String key, List<Long> candidateIds, String btnNum) {
        this.getView().getPageCache().put("key", key);
        String cacheString = SerializationUtils.serializeToBase64(candidateIds);
        this.getView().getPageCache().put("cacheString", cacheString);
        this.judgeSwitch(btnNum, candidateIds, key);
    }

    private void judgeSwitch(String btnNum, List<Long> candidateIds, String key) {
        switch (btnNum) {
            case "savetalent": 
            case "removetalent": {
                this.selectTalentPool(key, candidateIds);
                break;
            }
            case "selectposition": {
                this.selectPositions(candidateIds);
                break;
            }
        }
    }

    private boolean verifyCert(List<Long> candidateIds) {
        boolean result = true;
        if (candidateIds.size() == 1) {
            return !CertService.getInstance().verifyCertByPid(candidateIds.get(0), this.getView());
        }
        Map personIdStdRsmMaq = StdRsmCommonService.getInstance().getPersonIdByStdRsmIds(candidateIds);
        logger.info("TalentPoolListPlugin.verifyCert.personIdStdRsmMaq->{}", (Object)personIdStdRsmMaq);
        ArrayList personIdListAll = new ArrayList(personIdStdRsmMaq.size());
        personIdListAll.addAll(personIdStdRsmMaq.keySet());
        Map verifyCertMap = TSIRMCertCommonHelper.verifyCertByPid((String)"2+TXFE9NU13A", (String)"tsirm_stdrsm", (List)HRUserService.getPersonPid(personIdListAll));
        logger.info("TalentPoolListPlugin.verifyCert.verifyCertMap->{}", (Object)verifyCertMap);
        Map data = (Map)verifyCertMap.get("DATA");
        String infoType = (String)data.get("infoType");
        if (HRCertPromptInfoTypeEnum.FORBIDDEN.getName().equals(infoType)) {
            result = false;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bb8\u53ef\u5360\u7528\u6570\u91cf\u5df2\u8d85\u8fc7\u8d2d\u4e70\u6570\u91cf\u4e0a\u9650\uff0c\u7cfb\u7edf\u529f\u80fd\u9650\u5236\u4f7f\u7528\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8865\u5145\u8bb8\u53ef\u8d2d\u4e70\u6570\u91cf\u3002", (String)"CandidateDetailPagePlugin_18", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        }
        return !result;
    }

    private void getPageJurisData(List<Long> candidateIds, List<Long> listWithoutDuplicates) {
        String cacheString = this.getView().getPageCache().get("cacheString");
        String cacheEffString = this.getView().getPageCache().get("cacheEffString");
        candidateIds.addAll((Collection)SerializationUtils.deSerializeFromBase64((String)cacheString));
        listWithoutDuplicates.addAll((Collection)SerializationUtils.deSerializeFromBase64((String)cacheEffString));
    }

    private void selectTalentPool(String key, List<Long> listWithoutDuplicates) {
        this.getPageCache().put(CANDIDATEIDSWITHRIGHTS, listWithoutDuplicates.toString().replaceAll("\\[|\\]", ""));
        ListShowParameter listShowParameter = new ListShowParameter();
        ListShowParameter lsp = (ListShowParameter)this.getView().getFormShowParameter();
        String formId = lsp.getBillFormId();
        if ("tsirm_stdrsm_onjob".equals(formId)) {
            listShowParameter.setBillFormId("tsirm_talentpoolmgt_onjob");
            listShowParameter.setCustomParam("formId", (Object)"tsirm_talentpoolmgt_onjob");
        } else {
            listShowParameter.setBillFormId("tsirm_talentpoolmgt_dimi");
            listShowParameter.setCustomParam("formId", (Object)"tsirm_talentpoolmgt_dimi");
        }
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        listShowParameter.getOpenStyle().setInlineStyleCss(css);
        listShowParameter.setShowTitle(false);
        listShowParameter.setLookUp(true);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setCustomParam("pageNumber", (Object)"tsirm_stdrsm");
        if (HRStringUtils.equals((String)key, (String)"savetalent")) {
            listShowParameter.setFormId("tsirm_talenttreelistf7");
            listShowParameter.setCustomParam("permissionItem", (Object)"1Y+/5TTR4HPX");
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u50a8\u5907\u5230\u4eba\u624d\u5e93", (String)"TalentPoolListPlugin_9", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "savetalent"));
        } else {
            listShowParameter.setFormId("tsirm_talenttreef7_remove");
            listShowParameter.setBillFormId("tsirm_talentpoolmg_f7");
            listShowParameter.setCustomParam("containLower", (Object)"0");
            listShowParameter.setCustomParam("permissionItem", (Object)"2/57Q834RUB4");
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u79fb\u9664\u4eba\u624d\u5e93", (String)"TalentPoolListPlugin_8", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            List repeatIds = StandardResumeDataHelper.getMergeStdIds(listWithoutDuplicates);
            listWithoutDuplicates.addAll(repeatIds);
            Set talentPoolIds = TalentPoolFunHelper.queryTalentPoolIds(listWithoutDuplicates);
            QFilter qFilter = new QFilter("id", "in", (Object)talentPoolIds);
            listShowParameter.getListFilterParameter().setFilter(qFilter);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "removetalent"));
        }
        listShowParameter.setHasRight(Boolean.TRUE.booleanValue());
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void selectPositions(List<Long> listWithoutDuplicates) {
        this.getPageCache().put(CANDIDATEIDSWITHRIGHTS, listWithoutDuplicates.toString().replaceAll("\\[|\\]", ""));
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("tsirm_position_f7view");
        listShowParameter.setFormId("tsirm_positionlistf7");
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        listShowParameter.getOpenStyle().setInlineStyleCss(css);
        listShowParameter.setShowTitle(false);
        listShowParameter.setLookUp(true);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
        QFilter statusFilter = new QFilter("positionstatus", "in", (Object)new String[]{"A", "C"});
        qFilterList.add(statusFilter);
        listShowParameter.getListFilterParameter().setQFilters(qFilterList);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setCustomParam("maxSelectRow", (Object)10);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectposition"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String operateKey;
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "pushAsyncTaskForSelectPosition": {
                TalentPoolService.getInstance().selectPositionTalentPoolTaskCloseCallBack(this.getView(), closedCallBackEvent);
                operateKey = "";
                break;
            }
            case "pushAsyncTaskForRestoreTalentPool": {
                TalentPoolService.getInstance().restoreTalentPoolTaskCloseCallBack(this.getView(), closedCallBackEvent);
                operateKey = "";
                break;
            }
            case "pushAsyncTaskForRemoveTalentPool": {
                TalentPoolService.getInstance().removeTalentPoolTaskCloseCallBack(this.getView(), closedCallBackEvent);
                operateKey = "";
                break;
            }
            case "savetalent": {
                operateKey = "storretotalentpool_right";
                break;
            }
            case "removetalent": {
                operateKey = "removefromtalentpool_right";
                break;
            }
            case "selectposition": {
                operateKey = "recommdtoposition_right";
                break;
            }
            default: {
                operateKey = "";
            }
        }
        switch (actionId) {
            case "btn_invite": 
            case "btn_invitedelivery": 
            case "fullname": {
                this.getTreeListView().refreshTreeNode(this.getTreeModel().getCurrentNodeId().toString());
                break;
            }
        }
        if (HRObjectUtils.isEmpty((Object)returnData) || HRStringUtils.isBlank((CharSequence)operateKey)) {
            return;
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("returnData", SerializationUtils.toJsonString((Object)returnData));
        operateOption.setVariableValue("actionId", actionId);
        this.getView().invokeOperation(operateKey, operateOption);
    }

    private void closeCallBackSwitch(String actionId, String key, Object returnData) {
        ArrayList<Long> candidateIds = new ArrayList<Long>();
        ArrayList<Long> listWithoutDuplicates = new ArrayList<Long>();
        switch (actionId) {
            case "savetalent": 
            case "removetalent": {
                this.operateReserveRecord(actionId, returnData);
                this.getTreeListView().refreshTreeNode(this.getTreeModel().getCurrentNodeId().toString());
                break;
            }
            case "selectposition": {
                this.recommend2Position(returnData);
                this.getTreeListView().refreshTreeNode(this.getTreeModel().getCurrentNodeId().toString());
                break;
            }
            case "savetalent<>": 
            case "removetalent<>": {
                this.getPageJurisData(candidateIds, listWithoutDuplicates);
                this.selectTalentPool(key, listWithoutDuplicates);
                break;
            }
            case "selectposition<>": {
                this.getPageJurisData(candidateIds, listWithoutDuplicates);
                this.selectPositions(listWithoutDuplicates);
                break;
            }
        }
    }

    private void refreshChildViews() {
        String childPageStr = this.getView().getPageCache().get("childpages");
        if (HRStringUtils.isNotEmpty((String)childPageStr)) {
            Map childPages = (Map)SerializationUtils.fromJsonString((String)childPageStr, Map.class);
            for (String childPageId : childPages.values()) {
                IFormView view = this.getView().getView(childPageId);
                if (view == null) continue;
                view.invokeOperation("refresh");
                this.getView().sendFormAction(view);
            }
        }
    }

    private void operateReserveRecord(String actionId, Object returnData) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String billFormId = listShowParameter.getBillFormId();
        Long allocatedTPId = 0L;
        if ("tsirm_stdrsm_onjob".equals(billFormId)) {
            allocatedTPId = TSTPMTalentPoolConstants.ON_JOB_TP_ALLOCATED;
        } else if ("tsirm_stdrsm_dimi".equals(billFormId)) {
            allocatedTPId = TSTPMTalentPoolConstants.DIMI_TP_ALLOCATED;
        }
        String candidateIdsWithRightsStr = this.getPageCache().get(CANDIDATEIDSWITHRIGHTS);
        if (HRStringUtils.isEmpty((String)candidateIdsWithRightsStr)) {
            return;
        }
        List candidateIds = TalentListFunService.stringToLongList((String)candidateIdsWithRightsStr);
        ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
        ArrayList<Long> talentPoolIds = new ArrayList<Long>(listSelectedRows.size());
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            Long talentPoolId = (Long)listSelectedRow.getPrimaryKeyValue();
            talentPoolIds.add(talentPoolId);
        }
        int totalCount = talentPoolIds.size() * candidateIds.size();
        boolean changeWithDataPermisson = this.isChangeWithDataPermisson(candidateIds);
        if (changeWithDataPermisson) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4eba\u624d\u5e93\u5217\u8868\u6570\u636e\u6743\u9650\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"TALENTLIST_23", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("savetalent".equals(actionId) && this.checkDataChanged(candidateIds)) {
            return;
        }
        List notExistsIds = TalentPoolMgtHelper.getInstance().getNotExistsIds(talentPoolIds);
        if (notExistsIds.size() == talentPoolIds.size()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u4eba\u624d\u5e93\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TALENTLIST_22", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return;
        }
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        if (totalCount > 100) {
            if ("savetalent".equals(actionId)) {
                TalentPoolAsyncService.pushAsyncTaskForRestoreTalentPool((AbstractFormPlugin)this, formId, candidateIds, talentPoolIds, notExistsIds, allocatedTPId);
            } else {
                ArrayList rootIdList = Lists.newArrayListWithCapacity((int)1);
                ITreeModel treeModel = this.getTreeModel();
                Optional.ofNullable(treeModel.getRoot()).filter(r -> org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)treeModel.getRoot().getChildren())).ifPresent(node -> {
                    TreeNode treeNode = (TreeNode)treeModel.getRoot().getChildren().get(0);
                    if (null == treeNode) {
                        return;
                    }
                    String id = treeNode.getId();
                    rootIdList.add(id);
                });
                TalentPoolAsyncService.pushAsyncTaskForRemoveTalentPool((AbstractFormPlugin)this, formId, candidateIds, talentPoolIds, notExistsIds, allocatedTPId, rootIdList);
            }
            return;
        }
        this.opSwitch(actionId, allocatedTPId, talentPoolIds, candidateIds, formId, totalCount, notExistsIds);
    }

    private void opSwitch(String actionId, Long allocatedTPId, List<Long> talentPoolIds, List<Long> candidateIds, String formId, int totalCount, List<Long> notExistsIds) {
        switch (actionId) {
            case "savetalent": {
                this.saveRecord(talentPoolIds, candidateIds, formId, totalCount, notExistsIds, allocatedTPId);
                TalentPoolService.getInstance().updateCache(this.getView(), candidateIds);
                break;
            }
            case "removetalent": {
                this.removeRecord(talentPoolIds, candidateIds, totalCount, notExistsIds, allocatedTPId);
                TalentPoolService.getInstance().updateCache(this.getView(), candidateIds);
                break;
            }
        }
    }

    private void removeRecord(List<Long> talentPoolIds, List<Long> candidateIds, int totalCount, List<Long> notExistsIds, Long allocatedTPId) {
        int removeIgnoreNum = TalentListFunService.getRemoveTalentPoolNum(talentPoolIds, candidateIds);
        DynamicObject[] reserveRecordDtArrays = TalentListFunService.removeReserveRecord(talentPoolIds, candidateIds);
        List stdRsmIdList = Arrays.stream(reserveRecordDtArrays).map(dynamicObject -> dynamicObject.getLong("stdrsm_id")).collect(Collectors.toList());
        DynamicObject[] stdRsmDys = StandardResumeDataHelper.batchQuerySelectFieldsyById(stdRsmIdList, (String)"empid");
        if (null == stdRsmDys || stdRsmDys.length == 0) {
            TalentListFunService.showPageNotification((IFormView)this.getView(), (boolean)false, (String)"removetalent");
            return;
        }
        Map<Long, Long> stdIdMapEmpId = Arrays.stream(stdRsmDys).collect(Collectors.toMap(dynamic -> dynamic.getLong("id"), dynamic -> dynamic.getLong("empid"), (v1, v2) -> v1));
        List empIdList = Arrays.stream(stdRsmDys).map(dynamic -> dynamic.getLong("empid")).collect(Collectors.toList());
        Map result = BizHRPIEmployeeService.getEmployeeStatus(empIdList);
        ArrayList rootIdList = Lists.newArrayListWithCapacity((int)1);
        Optional.ofNullable(this.getTreeModel().getRoot()).filter(r -> org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)this.getTreeModel().getRoot().getChildren())).ifPresent(node -> {
            TreeNode treeNode = (TreeNode)this.getTreeModel().getRoot().getChildren().get(0);
            if (null == treeNode) {
                return;
            }
            String id = treeNode.getId();
            rootIdList.add(id);
        });
        Arrays.stream(reserveRecordDtArrays).forEach(dynamicObject -> {
            boolean isOutWork;
            Long stdRsmId = dynamicObject.getLong("stdrsm_id");
            Long empId = (Long)stdIdMapEmpId.get(stdRsmId);
            DynamicObject empDynamic = (DynamicObject)result.get(empId);
            boolean bl = isOutWork = null == empDynamic || empDynamic.getLong("labrelstatusprd_id") == Long.parseLong("1020");
            if (isOutWork && !rootIdList.contains("1030")) {
                TalentListFunService.saveOneReserveRecord((Long)stdRsmId, (Long)TSTPMTalentPoolConstants.DIMI_TP_ALLOCATED);
            }
        });
        int errorCount = totalCount - reserveRecordDtArrays.length - removeIgnoreNum;
        if (totalCount > 1) {
            if (errorCount > 0) {
                this.removeShow(reserveRecordDtArrays, notExistsIds, candidateIds, totalCount, removeIgnoreNum);
            } else {
                TalentListFunService.showPageNotification((IFormView)this.getView(), (boolean)true, (String)"removetalent");
            }
        } else {
            TalentListFunService.showPageNotification((IFormView)this.getView(), (errorCount <= 0 ? 1 : 0) != 0, (String)"removetalent");
        }
        List unClassifiedCandidateIds = TalentPoolFunHelper.queryCandidateReserve(candidateIds);
        if (!CollectionUtils.isEmpty((Collection)unClassifiedCandidateIds)) {
            TalentListFunService.saveCandidate2UnClassFy((List)unClassifiedCandidateIds, (Long)allocatedTPId);
        }
    }

    private void removeShow(DynamicObject[] reserveRecordDtArrays, List<Long> notExistsIds, List<Long> candidateIds, int totalCount, int removeIgnoreNum) {
        int removeSize = reserveRecordDtArrays.length;
        Map returnMap = TalentListFunService.showRemoveTalentPoolMessage((int)removeSize, notExistsIds, candidateIds, (int)totalCount, (int)removeIgnoreNum);
        if (returnMap.isEmpty()) {
            return;
        }
        FormShowParameter formShowParameter = GenerateFormShowParamUtils.generateBosOperationResultFormShowParam(returnMap.get("titleMsg"), returnMap.get("errorMsgTotal"), (boolean)false);
        this.getView().showForm(formShowParameter);
    }

    private void saveRecord(List<Long> talentPoolIds, List<Long> candidateIds, String formId, int totalCount, List<Long> notExistsIds, Long allocatedTPId) {
        Object[] addReserveDtArrays = TalentListFunService.saveReserveRecord(talentPoolIds, candidateIds);
        if (HRArrayUtils.isEmpty((Object[])addReserveDtArrays)) {
            return;
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("formId", formId);
        OperationResult addOperationResult = SaveServiceHelper.saveOperate((String)"save", (String)"tsirm_reservere", (DynamicObject[])addReserveDtArrays, (OperateOption)operateOption);
        StandardResumeDataHelper.updateStdRsmTalentPool(candidateIds);
        TalentPoolService.getInstance().dealRestoreTalentPoolResult(this.getView(), addOperationResult, totalCount, notExistsIds, (DynamicObject[])addReserveDtArrays, talentPoolIds, candidateIds, allocatedTPId);
    }

    protected boolean checkDataChanged(List<Long> candidateIds) {
        AtomicBoolean isDataChange = new AtomicBoolean(false);
        if (!StringUtil.isEmpty((String)this.getPageCache().get("currentNodeId"))) {
            Map stdReserveMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("currentNodeId"));
            List currentStdTalentList = TsrbsHelper.selectByFilter((String)"talentpool.fbasedataid", (QFilter[])new QFilter[]{new QFilter("id", "in", candidateIds)}, (String)"tsirm_stdrsm");
            currentStdTalentList.forEach(dynamicObject -> {
                boolean equals;
                List currentTalentPool = dynamicObject.getDynamicObjectCollection("talentpool").stream().map(dynamic -> dynamic.getLong("fbasedataid.id")).collect(Collectors.toList());
                long stdRsmId = dynamicObject.getLong("id");
                if (null == stdReserveMap) {
                    return;
                }
                if (org.apache.commons.collections.CollectionUtils.isEmpty(currentTalentPool)) {
                    return;
                }
                List talentPool = (List)stdReserveMap.get(stdRsmId);
                boolean bl = equals = talentPool != null && talentPool.stream().sorted(Comparator.comparing(talentPoolId -> talentPoolId)).map(String::valueOf).collect(Collectors.joining()).equals(currentTalentPool.stream().sorted(Comparator.comparing(currentTalentPoolId -> currentTalentPoolId)).map(String::valueOf).collect(Collectors.joining()));
                if (!equals) {
                    isDataChange.set(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4eba\u624d\u5e93\u5217\u8868\u6570\u636e\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"TalentPoolListPlugin_10", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                }
            });
        }
        return isDataChange.get();
    }

    private void recommend2Position(Object returnData) {
        boolean limit;
        String candidateIdsWithRightsStr = this.getPageCache().get(CANDIDATEIDSWITHRIGHTS);
        if (HRStringUtils.isEmpty((String)candidateIdsWithRightsStr)) {
            return;
        }
        List candidateIds = TalentListFunService.stringToLongList((String)candidateIdsWithRightsStr);
        ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
        ArrayList<Long> positionIds = new ArrayList<Long>(listSelectedRows.size());
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            Long positionId = (Long)listSelectedRow.getPrimaryKeyValue();
            positionIds.add(positionId);
        }
        if (this.checkDataChanged(candidateIds)) {
            return;
        }
        if (this.verifyCert(candidateIds)) {
            return;
        }
        logger.info("start to saveAppFile ");
        long start = System.currentTimeMillis();
        boolean bl = limit = candidateIds.size() * positionIds.size() > 100;
        if (limit) {
            TalentPoolAsyncService.pushAsyncTaskForSelectPosition((AbstractFormPlugin)this, candidateIds, positionIds);
        } else {
            TalentPoolFallMessage talentPoolFallMessage = TalentListFunService.saveAppFile((List)candidateIds, positionIds);
            logger.info("create saveAppFile cost time  {}", (Object)(System.currentTimeMillis() - start));
            if (talentPoolFallMessage.getFlag()) {
                this.getView().showSuccessNotification(talentPoolFallMessage.getTitleMsg());
                return;
            }
            if (HRStringUtils.isEmpty((String)talentPoolFallMessage.getErrorMsgTotal())) {
                this.getView().showErrorNotification(talentPoolFallMessage.getTitleMsg());
            } else {
                FormShowParameter formShowParameter = GenerateFormShowParamUtils.generateBosOperationResultFormShowParam((Object)talentPoolFallMessage.getTitleMsg(), (Object)talentPoolFallMessage.getErrorMsgTotal(), (boolean)false);
                this.getView().showForm(formShowParameter);
            }
        }
    }

    private void showApplyPositionList(String candidateId) {
        DynamicObject candidateDt = TalentPoolFunHelper.queryCandidateNumber((String)candidateId);
        if (HRObjectUtils.isEmpty((Object)candidateDt)) {
            return;
        }
        FormShowParameter listShowParameter = new FormShowParameter();
        listShowParameter.setFormId("tsirm_talentpositionlist");
        String fullName = candidateDt.getString("fullname");
        if (fullName.length() >= 40) {
            fullName = fullName.substring(0, 40);
        }
        listShowParameter.setCaption(ResManager.loadKDString((String)"{0}-\u5e94\u8058\u804c\u4f4d", (String)"TalentPoolListPlugin_5", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{fullName}));
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        listShowParameter.getOpenStyle().setInlineStyleCss(css);
        listShowParameter.setCustomParam("id", (Object)Long.valueOf(candidateId));
        this.getView().showForm(listShowParameter);
    }

    private void showTalentPoolList(String candidateId) {
        DynamicObject candidateDt = TalentPoolFunHelper.queryCandidateNumber((String)candidateId);
        if (HRObjectUtils.isEmpty((Object)candidateDt)) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsirm_showreservecord");
        String fullName = candidateDt.getString("fullname");
        if (fullName.length() >= 40) {
            fullName = fullName.substring(0, 40);
        }
        showParameter.setCaption(ResManager.loadKDString((String)"{0}-\u50a8\u5907\u4eba\u624d\u5e93", (String)"TalentPoolListPlugin_6", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{fullName}));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("id", (Object)candidateId);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        this.getView().showForm(showParameter);
    }

    private void showRefreshPageTips() {
        this.getView().showErrorNotification(TSCBaseKDString.dataChangedTip());
    }

    private boolean isChangeWithDataPermisson(List<Long> stdRsmIdList) {
        Map longBooleanMap = StdRsmCommonService.getInstance().queryStdRsmViewPermission(stdRsmIdList);
        AtomicBoolean isChange = new AtomicBoolean(false);
        longBooleanMap.forEach((key, value) -> {
            if (!value.booleanValue()) {
                isChange.set(true);
            }
        });
        return isChange.get();
    }

    public void packageData(PackageDataEvent e) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        String fieldKey = columnDesc.getFieldKey();
        DynamicObject rowData = e.getRowData();
        if ("workingyear".equals(fieldKey)) {
            e.setFormatValue((Object)ResumeAnalysisHelper.getWorkYearShow((int)rowData.getInt("workingyears")));
        }
    }
}

