/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.talentpool;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sdk.tsc.common.vo.BizResult;
import kd.sdk.tsc.common.vo.KResumeBO;
import kd.sdk.tsc.tsirm.extpoint.cv.DeliveryParam;
import kd.sdk.tsc.tsirm.extpoint.cv.EmpDeliveryTypeEnum;
import kd.tsc.tsirm.business.domain.pc.factory.PCServiceFactory;
import kd.tsc.tsirm.business.domain.pc.helper.EmpCVHelper;
import kd.tsc.tsirm.business.domain.pc.helper.EmpDeliveryHelper;
import kd.tsc.tsirm.business.domain.pc.service.AbstractEmpCVService;
import kd.tsc.tsirm.business.domain.pc.service.PersonInfoService;
import kd.tsc.tsirm.business.domain.pc.service.PersonalCenterService;
import kd.tsc.tsirm.common.enums.pc.PCServiceErrorStatusEnum;
import org.apache.commons.lang3.ObjectUtils;

public class TsirmSmpleResumePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(TsirmSmpleResumePlugin.class);
    private static AbstractEmpCVService empCVService = PCServiceFactory.getEmpCVService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"bingemployee", "getemployeedoc", "getemployeecv", "submitbutton", "deliveryposition", "openresume", "closeresume"});
        BasedataEdit advertBd = (BasedataEdit)this.getControl("advert");
        advertBd.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.getView().setVisible(Boolean.FALSE, new String[]{"baseinfo", "deliveryinfo"});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        beforeF7SelectEvent.setCancel(true);
        this.openAdvertF7();
    }

    private void openAdvertF7() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setMultiSelect(false);
        listShowParameter.setBillFormId("tsirm_adverttplex");
        listShowParameter.setFormId("bos_listf7");
        OpenStyle style = new OpenStyle();
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("900px");
        cssValue.setHeight("600px");
        style.setInlineStyleCss(cssValue);
        style.setShowType(ShowType.Modal);
        listShowParameter.setOpenStyle(style);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setLookUp(true);
        listShowParameter.setShowTitle(false);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u5e7f\u544a\u5217\u8868", (String)"TsirmSmpleResumePlugin_16", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, null));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (HRObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
        Long advertId = (Long)listSelectedRows.get(0).getPrimaryKeyValue();
        this.getModel().setValue("advert", (Object)advertId);
    }

    public void click(EventObject evt) {
        String controlKey = ((Control)evt.getSource()).getKey();
        if ("bingemployee".equals(controlKey)) {
            Object userObj = this.getModel().getValue("user");
            if (ObjectUtils.isEmpty((Object)this.getView().getModel().getValue("user"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5458\u5de5\u7f16\u7801\u4e3a\u7a7a", (String)"TsirmSmpleResumePlugin_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            MulBasedataDynamicObjectCollection users = (MulBasedataDynamicObjectCollection)userObj;
            logger.info("TsirmSmpleResumePlugin.click->{}", (Object)users);
            for (int idx = 0; idx < users.size(); ++idx) {
                DynamicObject user = (DynamicObject)users.get(idx);
                long userId = user.getDynamicObject("fbasedataid").getLong("id");
                BizResult bizResult = empCVService.bindAccount(Long.valueOf(userId));
            }
        } else if ("getemployeedoc".equals(controlKey)) {
            if (Objects.isNull(this.getView().getModel().getValue("employeenumber"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5458\u5de5\u7f16\u7801\u4e3a\u7a7a", (String)"TsirmSmpleResumePlugin_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            PersonInfoService personInfoService = new PersonInfoService();
            DynamicObject userDt = (DynamicObject)this.getView().getModel().getValue("employeenumber");
            Long userId = userDt.getLong("id");
            BizResult bizResult = personInfoService.getPersonInfo(userId);
            if (bizResult.getSuccess() != Boolean.TRUE) {
                if (bizResult.getCode().intValue() == PCServiceErrorStatusEnum.ACCOUNT_NOTEXIST.getStatus() || bizResult.getCode().intValue() == PCServiceErrorStatusEnum.ACCOUNT_NOTBINDING.getStatus()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5c1a\u672a\u7ed1\u5b9a\u8d26\u53f7\uff0c\u8bf7\u5148\u7ed1\u5b9a\u5458\u5de5\u8d26\u53f7", (String)"TsirmSmpleResumePlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                } else if (bizResult.getCode().intValue() == PCServiceErrorStatusEnum.ACCOUNT_NOTFINDPERSON.getStatus()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u672a\u5165\u804c", (String)"TsirmSmpleResumePlugin_17", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                }
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"baseinfo", "deliveryinfo"});
                KResumeBO personInfo = (KResumeBO)bizResult.getData();
                Long empCVId = EmpCVHelper.getEmpCVId((Long)userId);
                KResumeBO KResumeBO2 = empCVService.getEmpCV(empCVId);
                DynamicObject empCV = KResumeBO2.getData();
                HRDynamicObjectUtils.copy((DynamicObject)personInfo.getData(), (DynamicObject)empCV);
                empCV.set("id", (Object)empCVId);
                KResumeBO2.setData(empCV);
                KResumeBO2.setDynCollMap(personInfo.getDynCollMap());
                EmpCVHelper.saveEmpCV((KResumeBO)KResumeBO2);
                this.loadEmployeeCV(empCVId);
            }
        } else if ("getemployeecv".equals(controlKey)) {
            if (Objects.isNull(this.getView().getModel().getValue("employeenumber"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5458\u5de5\u7f16\u7801\u4e3a\u7a7a", (String)"TsirmSmpleResumePlugin_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject userDt = (DynamicObject)this.getView().getModel().getValue("employeenumber");
            Long userId = userDt.getLong("id");
            DynamicObject rel = EmpCVHelper.queryEmpCVRel((String)"account", (Long)userId);
            if (rel == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5c1a\u672a\u7ed1\u5b9a\u8d26\u53f7\uff0c\u8bf7\u5148\u7ed1\u5b9a\u5458\u5de5\u8d26\u53f7", (String)"TsirmSmpleResumePlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            Long cvId = EmpCVHelper.getEmpCVId((Long)userId);
            KResumeBO KResumeBO3 = empCVService.getEmpCV(cvId);
            if (KResumeBO3 != null) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"baseinfo", "deliveryinfo"});
                this.loadEmployeeCV(KResumeBO3.getData().getLong("id"));
                this.getDeliveryRecords(cvId);
            }
        } else if ("submitbutton".equals(controlKey)) {
            if (Objects.isNull(this.getView().getModel().getValue("employeenumber"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5458\u5de5\u7f16\u7801\u4e3a\u7a7a", (String)"TsirmSmpleResumePlugin_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            IFormView empcvView = this.getView().getView(this.getPageCache().get("tsirm_empcv"));
            if (empcvView == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u83b7\u53d6\u5458\u5de5\u7b80\u5386\u4fe1\u606f", (String)"TsirmSmpleResumePlugin_14", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject empcvDy = empcvView.getModel().getDataEntity(true);
            KResumeBO KResumeBO4 = new KResumeBO();
            KResumeBO4.setData(empcvDy);
            BizResult bizResult = PersonalCenterService.getInstance().updateCV(KResumeBO4);
            if (bizResult.getSuccess() == Boolean.TRUE) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u7b80\u5386\u6210\u529f", (String)"TsirmSmpleResumePlugin_6", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u7b80\u5386\u5931\u8d25", (String)"TsirmSmpleResumePlugin_7", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            }
        } else if ("deliveryposition".equals(controlKey)) {
            Long cvId;
            if (Objects.isNull(this.getView().getModel().getValue("advert"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u804c\u4f4d\u7f16\u7801\u4e3a\u7a7a", (String)"TsirmSmpleResumePlugin_5", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (Objects.isNull(this.getView().getModel().getValue("employeenumber"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5458\u5de5\u7f16\u7801\u4e3a\u7a7a", (String)"TsirmSmpleResumePlugin_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_advertpublish");
            DynamicObject advertDt = (DynamicObject)this.getView().getModel().getValue("advert");
            Long advertDtId = advertDt.getLong("id");
            DynamicObject advert = serviceHelper.queryOne("position", (Object)advertDtId);
            if (advert == null) {
                return;
            }
            Long positionId = advert.getLong("position.id");
            DynamicObject userDt = (DynamicObject)this.getView().getModel().getValue("employeenumber");
            Long userId = userDt.getLong("id");
            DeliveryParam deliveryParam = new DeliveryParam(userId, positionId, advertDtId, cvId = EmpCVHelper.getEmpCVId((Long)userId), EmpDeliveryTypeEnum.DELIVTYPE_POSITION);
            BizResult bizResult = empCVService.deliveryCV(deliveryParam);
            if (bizResult.getSuccess() == Boolean.TRUE) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6295\u9012\u804c\u4f4d\u6210\u529f", (String)"TsirmSmpleResumePlugin_8", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.TRUE, new String[]{"baseinfo", "deliveryinfo"});
                KResumeBO KResumeBO5 = empCVService.getEmpCV(cvId);
                if (KResumeBO5 != null) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"baseinfo", "deliveryinfo"});
                    this.loadEmployeeCV(KResumeBO5.getData().getLong("id"));
                    this.getDeliveryRecords(cvId);
                }
            } else if (bizResult.getCode().intValue() == PCServiceErrorStatusEnum.ACCOUNT_NOTEXIST.getStatus() || bizResult.getCode().intValue() == PCServiceErrorStatusEnum.ACCOUNT_NOTBINDING.getStatus()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5c1a\u672a\u7ed1\u5b9a\u8d26\u53f7\uff0c\u8bf7\u5148\u7ed1\u5b9a\u5458\u5de5\u8d26\u53f7", (String)"TsirmSmpleResumePlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6295\u9012\u804c\u4f4d\u5931\u8d25", (String)"TsirmSmpleResumePlugin_9", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            }
        } else if ("openresume".equals(controlKey)) {
            if (Objects.isNull(this.getView().getModel().getValue("employeenumber"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5458\u5de5\u7f16\u7801\u4e3a\u7a7a", (String)"TsirmSmpleResumePlugin_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject userDt = (DynamicObject)this.getView().getModel().getValue("employeenumber");
            Long userId = userDt.getLong("id");
            Long cvId = EmpCVHelper.getEmpCVId((Long)userId);
            DeliveryParam deliveryParam = new DeliveryParam(EmpDeliveryTypeEnum.DELIVTYPE_OPENCV, userId);
            deliveryParam.setCvId(cvId);
            BizResult bizResult = empCVService.deliveryCV(deliveryParam);
            if (bizResult.getSuccess() == Boolean.TRUE) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u516c\u5f00\u7b80\u5386\u6210\u529f", (String)"TsirmSmpleResumePlugin_10", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            } else if (bizResult.getCode().intValue() == PCServiceErrorStatusEnum.ACCOUNT_NOTEXIST.getStatus() || bizResult.getCode().intValue() == PCServiceErrorStatusEnum.ACCOUNT_NOTBINDING.getStatus()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5c1a\u672a\u7ed1\u5b9a\u8d26\u53f7\uff0c\u8bf7\u5148\u7ed1\u5b9a\u5458\u5de5\u8d26\u53f7", (String)"TsirmSmpleResumePlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            } else if (bizResult.getCode().intValue() == PCServiceErrorStatusEnum.ACCOUNT_NOTFINDPERSON.getStatus()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d26\u53f7\u672a\u627e\u5230\u5bf9\u5e94\u4eba\u5458\u6863\u6848", (String)"TsirmSmpleResumePlugin_15", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u516c\u5f00\u7b80\u5386\u5931\u8d25", (String)"TsirmSmpleResumePlugin_11", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            }
        } else if ("closeresume".equals(controlKey)) {
            if (Objects.isNull(this.getView().getModel().getValue("employeenumber"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5458\u5de5\u7f16\u7801\u4e3a\u7a7a", (String)"TsirmSmpleResumePlugin_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject userDt = (DynamicObject)this.getView().getModel().getValue("employeenumber");
            Long userId = userDt.getLong("id");
            BizResult bizResult = empCVService.unPublishedCV(userId);
            if (bizResult.getSuccess() == Boolean.TRUE) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u516c\u5f00\u7b80\u5386\u6210\u529f", (String)"TsirmSmpleResumePlugin_12", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            } else if (bizResult.getCode().intValue() == PCServiceErrorStatusEnum.ACCOUNT_NOTEXIST.getStatus() || bizResult.getCode().intValue() == PCServiceErrorStatusEnum.ACCOUNT_NOTBINDING.getStatus()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5c1a\u672a\u7ed1\u5b9a\u8d26\u53f7\uff0c\u8bf7\u5148\u7ed1\u5b9a\u5458\u5de5\u8d26\u53f7", (String)"TsirmSmpleResumePlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            } else if (bizResult.getCode().intValue() == PCServiceErrorStatusEnum.ACCOUNT_NOTFINDPERSON.getStatus()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d26\u53f7\u672a\u627e\u5230\u5bf9\u5e94\u4eba\u5458\u6863\u6848", (String)"TsirmSmpleResumePlugin_15", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u516c\u5f00\u7b80\u5386\u5931\u8d25", (String)"TsirmSmpleResumePlugin_13", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void loadEmployeeCV(Long pkid) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("tsirm_empcv");
        showParameter.getOpenStyle().setTargetKey("baseinfo");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setPkId((Object)String.valueOf(pkid));
        this.getView().showForm((FormShowParameter)showParameter);
        this.getPageCache().put("tsirm_empcv", showParameter.getPageId());
    }

    private void getDeliveryRecords(Long cvId) {
        List deliveryRecordsList = EmpDeliveryHelper.getDeliveryRecords((Long)cvId);
        ArrayList<Long> deliveryRecordsIds = new ArrayList<Long>(deliveryRecordsList.size());
        for (DynamicObject deliveryRecords : deliveryRecordsList) {
            deliveryRecordsIds.add(deliveryRecords.getLong("id"));
        }
        if (deliveryRecordsList.size() > 0) {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setMultiSelect(false);
            listShowParameter.setBillFormId("tsirm_empdelivery");
            listShowParameter.setFormId("bos_list");
            listShowParameter.getOpenStyle().setTargetKey("deliveryinfo");
            listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            listShowParameter.setShowTitle(false);
            QFilter qFilter = new QFilter("id", "in", deliveryRecordsIds);
            listShowParameter.getListFilterParameter().setFilter(qFilter);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }
}

