/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.talentpool.talentpoolmgt;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ITreeListView;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtPermHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtQFilterHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtTreeHelper;
import kd.tsc.tsirm.common.constants.talentpool.TPMTreeDto;
import kd.tsc.tsirm.common.constants.talentpool.TSTPMTalentPoolConstants;
import kd.tsc.tsirm.common.enums.talentpool.TalentPoolMgtEnum;
import kd.tsc.tsrbs.business.domain.common.service.ListFilterCommonHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class TalentPoolMgtBaseListPlugin {
    public static void defaultRefreshNode(RefreshNodeEvent re, TreeNode root, String currNodeId, TreeNode currNode, TPMTreeDto tpmTreeDto) {
        if (currNode.getChildren() != null && !currNode.getChildren().isEmpty()) {
            if (tpmTreeDto.getFromDelete().booleanValue()) {
                tpmTreeDto.setTreeNode(currNode);
                tpmTreeDto.setContainLower(true);
                re.setChildNodes(TalentPoolMgtBaseListPlugin.loadSubNode(tpmTreeDto, tpmTreeDto.getPoolType()));
            } else {
                re.setChildNodes(currNode.getChildren());
            }
        } else if (StringUtils.equals((CharSequence)currNodeId, (CharSequence)root.getId())) {
            re.setChildNodes(TalentPoolMgtBaseListPlugin.loadTalentPoolListNode(tpmTreeDto));
        } else {
            re.setChildNodes(new ArrayList());
        }
    }

    public static List<TreeNode> loadTalentPoolListNode(TPMTreeDto treeDto) {
        List<TreeNode> treeNodes;
        TreeNode parentNode;
        ArrayList<TreeNode> treeSysPresetNodes = new ArrayList<TreeNode>();
        if (treeDto.isPubTPM()) {
            parentNode = TalentPoolMgtTreeHelper.getPublicTalentPoolTreeNode();
            treeDto.setEncryption(!TalentPoolMgtPermHelper.isSuperUser() && TalentPoolMgtPermHelper.querySecurityConf());
            treeNodes = TalentPoolMgtBaseListPlugin.loadSubNode(treeDto, treeDto.getPoolType());
            if (treeNodes.size() != 0) {
                parentNode.addChildren(treeNodes);
            }
            treeSysPresetNodes.add(parentNode);
        }
        if (treeDto.isPriTPM()) {
            parentNode = TalentPoolMgtTreeHelper.getPrivateTalentPoolTreeNode();
            treeDto.setEncryption(false);
            treeNodes = TalentPoolMgtBaseListPlugin.loadSubNode(treeDto, "B");
            if (treeNodes.size() != 0) {
                parentNode.addChildren(treeNodes);
            }
            treeSysPresetNodes.add(parentNode);
        }
        return treeSysPresetNodes;
    }

    public static List<TreeNode> loadSubNode(TPMTreeDto treeDto, String poolType) {
        return treeDto.isContainLower() ? TalentPoolMgtBaseListPlugin.getTalentPoolListNode(TalentPoolMgtQFilterHelper.getSubQFilter((TPMTreeDto)treeDto, (String)poolType), treeDto) : new ArrayList<TreeNode>();
    }

    public static List<TreeNode> getTalentPoolListNode(QFilter qFilter, TPMTreeDto treeDto) {
        List notContainIds = treeDto.getNotContainIds();
        if (ObjectUtils.isEmpty((Object)notContainIds)) {
            if ("tsirm_talentpoolmgt_onjob".equals(treeDto.getPageNumber())) {
                qFilter.or("id", "in", (Object)TSTPMTalentPoolConstants.ON_JOB_TP_ALLOCATED);
            } else if ("tsirm_talentpoolmgt_dimi".equals(treeDto.getPageNumber())) {
                qFilter.or("id", "in", (Object)TSTPMTalentPoolConstants.DIMI_TP_ALLOCATED);
            }
        } else {
            qFilter.and("id", "!=", notContainIds.get(0));
        }
        DynamicObject[] objects = TalentPoolMgtHelper.talentPoolMgtServiceHelper.query(TalentPoolMgtHelper.selectProperties(), new QFilter[]{qFilter}, "createtime");
        LinkedHashMap<Long, TreeNode> nodeHashMap = TalentPoolMgtBaseListPlugin.objToTreeNodeMap(objects, treeDto.isEncryption());
        return TalentPoolMgtBaseListPlugin.getChildrenNodeList(nodeHashMap, treeDto.getTreeNode());
    }

    public static List<TreeNode> getChildrenNodeList(LinkedHashMap<Long, TreeNode> maps, TreeNode currNode) {
        ArrayList<TreeNode> parentNodes = new ArrayList<TreeNode>(maps.size());
        for (Map.Entry<Long, TreeNode> map : maps.entrySet()) {
            TreeNode value = map.getValue();
            if (maps.get(Long.parseLong(value.getParentid())) == null) {
                if (currNode != null && !HRStringUtils.equals((String)currNode.getId(), (String)value.getParentid())) continue;
                parentNodes.add(value);
                continue;
            }
            maps.get(Long.parseLong(value.getParentid())).addChild(value);
        }
        return parentNodes;
    }

    public static LinkedHashMap<Long, TreeNode> objToTreeNodeMap(DynamicObject[] objects, boolean originalEncryption) {
        LinkedHashMap nodeHashMap = Maps.newLinkedHashMapWithExpectedSize((int)objects.length);
        boolean encryption = originalEncryption;
        DynamicObject userSecurityObj = TalentPoolMgtPermHelper.queryUserSecurityLevel();
        List list = Arrays.stream(objects).sorted(Comparator.comparing(object -> object.getLong("id"))).collect(Collectors.toList());
        for (DynamicObject dynamicObject : list) {
            if (originalEncryption && userSecurityObj != null && dynamicObject.getLong("seclevel.index") >= userSecurityObj.getLong("index")) {
                encryption = false;
            }
            TreeNode treeNode = TalentPoolMgtTreeHelper.getTreeNode((DynamicObject)dynamicObject, (boolean)encryption);
            nodeHashMap.put(dynamicObject.getLong("id"), treeNode);
            encryption = originalEncryption;
        }
        return nodeHashMap;
    }

    public static void commonRecrutypColumnInit(FilterContainerInitArgs args, IFormView view) {
        CommonFilterColumn orgColumn = (CommonFilterColumn)args.getFilterColumn("recrutyp.name");
        String pageParam = TalentPoolMgtHelper.getInstance().getPageParam(view);
        QFilter qFilter = TalentPoolMgtQFilterHelper.getRecrutypQFilter((String)pageParam, (boolean)true);
        ListFilterCommonHelper.generalCommonColumnInit((CommonFilterColumn)orgColumn, (QFilter[])qFilter.toArray(), (String)"hbss_recrutyp", (String)"id");
    }

    public static void buildTreeListFilter(BuildTreeListFilterEvent ble, IFormView view) {
        String nodeId = ble.getNodeId().toString();
        DynamicObject[] dynamicObject = TalentPoolMgtHelper.getDynamicObjects((Long)Long.valueOf(nodeId));
        if (dynamicObject.length == 0) {
            return;
        }
        if (HRStringUtils.equals((String)nodeId, (String)"0") || "1020".equals(nodeId) || "1030".equals(nodeId)) {
            ble.setCancel(true);
            return;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(nodeId));
        boolean containLower = (Boolean)view.getModel().getValue("iscontainlower1");
        if (containLower) {
            String longNumber = dynamicObject[0].getString("longnumber");
            qFilter.or("longnumber", "like", (Object)(longNumber + "%"));
        }
        ble.addQFilter(qFilter);
        ble.setCancel(true);
    }

    public static void saveCheck(IFormView view, ITreeModel model, String poolType, BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)"copy", (String)formOperate.getOperateKey()) || HRStringUtils.equals((String)"new", (String)formOperate.getOperateKey())) {
            String currentNodeId = (String)model.getCurrentNodeId();
            if (ObjectUtils.isEmpty((Object)currentNodeId)) {
                return;
            }
            if (!HRStringUtils.equals((String)currentNodeId, (String)"0")) {
                DynamicObject[] dynamicObjects = TalentPoolMgtHelper.getDynamicObjects((Long)Long.parseLong(currentNodeId));
                if (dynamicObjects.length == 0) {
                    args.setCancel(true);
                    view.showErrorNotification(TalentPoolMgtEnum.TPM_23.getValue());
                    return;
                }
                if (HRStringUtils.equals((String)"copy", (String)formOperate.getOperateKey()) || HRStringUtils.equals((String)"new", (String)formOperate.getOperateKey())) {
                    if (dynamicObjects[0].getLong("level") >= 10L) {
                        args.setCancel(true);
                        view.showErrorNotification(TalentPoolMgtEnum.TPM_6.getValue());
                        return;
                    }
                } else {
                    return;
                }
            }
            view.getPageCache().put("currentNodeId", currentNodeId);
            view.getPageCache().put("pooltype", poolType);
        }
    }

    private static void afterOpInitTree(ITreeModel treeModel) {
        TreeNode root = TalentPoolMgtTreeHelper.createRoot();
        treeModel.setRoot(root);
        treeModel.setCurrentNodeId((Object)"0");
    }

    public static void afterBindData(IFormView view, ITreeModel treeModel, ITreeListView treeListView) {
        String currentNodeId = String.valueOf(treeModel.getCurrentNodeId());
        IPageCache pageCache = view.getPageCache();
        if (HRStringUtils.equals((String)pageCache.get("operation"), (String)"new")) {
            String newID = pageCache.get("insertId");
            TreeNode root = treeModel.getRoot();
            TreeNode newTreeNode = root.getTreeNode(newID, 20);
            if (newTreeNode == null) {
                String parentID = pageCache.get("parentID");
                view.getPageCache().remove("parentID");
                if (HRStringUtils.isNotEmpty((String)parentID) && HRStringUtils.isNotEmpty((String)newID)) {
                    treeModel.setCurrentNodeId((Object)parentID);
                    TalentPoolMgtBaseListPlugin.afterOpInitTree(treeModel);
                    treeListView.refresh();
                }
            } else {
                view.getPageCache().remove("parentID");
                view.getPageCache().remove("operation");
                view.getPageCache().remove("insertId");
                treeModel.setCurrentNodeId((Object)newID);
                treeListView.refreshTreeNode(newID);
            }
        } else {
            treeListView.getTreeView().showNode(currentNodeId);
            view.setVisible(Boolean.valueOf(!StringUtils.equals((CharSequence)currentNodeId, (CharSequence)"0")), new String[]{"iscontainlower1"});
            if (StringUtils.equals((CharSequence)currentNodeId, (CharSequence)"0")) {
                treeListView.getTreeView().focusNode((TreeNode)treeModel.getRoot().getChildren().get(0));
            }
            if (StringUtils.equals((CharSequence)currentNodeId, (CharSequence)"0")) {
                treeListView.getTreeView().focusNode((TreeNode)treeModel.getRoot().getChildren().get(0));
            }
            if (StringUtils.equals((CharSequence)currentNodeId, (CharSequence)"1020") || StringUtils.equals((CharSequence)currentNodeId, (CharSequence)"1030")) {
                view.setVisible(Boolean.valueOf(false), new String[]{"iscontainlower1"});
            }
            if (HRStringUtils.equals((String)pageCache.get("operation"), (String)"delete")) {
                treeModel.setCurrentNodeId((Object)currentNodeId);
                view.getPageCache().remove("operation");
            }
        }
    }

    public static void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args, IFormView view) {
        if (args.getFieldName().contains("recrutyp")) {
            String pageParam = TalentPoolMgtHelper.getInstance().getPageParam(view.getParentView());
            args.addCustomQFilter(TalentPoolMgtQFilterHelper.getRecrutypQFilter((String)pageParam, (boolean)true));
        }
    }
}

