/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.talentpool.talentpoolmgt;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.function.Consumer;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtPriHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtQFilterHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtTreeHelper;
import kd.tsc.tsirm.common.constants.talentpool.TPMTreeDto;
import kd.tsc.tsirm.common.enums.talentpool.TalentPoolMgtEnum;
import kd.tsc.tsirm.formplugin.web.talentpool.talentpoolmgt.TalentPoolMgtBaseListPlugin;
import kd.tsc.tsirm.formplugin.web.talentpool.talentpoolmgt.TalentPoolMgtPriListDataProvider;
import org.apache.commons.lang3.StringUtils;

public class TalentPoolMgtPriListPlugin
extends StandardTreeListPlugin {
    private static final HashMap<String, Consumer<ItemClickEvent>> OPERATION_MAP = new HashMap(4);
    private final TalentPoolMgtPriHelper talentPoolMgtPriHelper = TalentPoolMgtPriHelper.getInstance();

    public TalentPoolMgtPriListPlugin() {
        OPERATION_MAP.put("tblnew", evt -> this.tblNew());
        OPERATION_MAP.put("tbldel", evt -> this.tblDel());
        OPERATION_MAP.put("tblrefresh", evt -> this.tblRefresh());
        OPERATION_MAP.put("exportbylist", evt -> this.tblExportListBySelectFields());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    private void initTreeNode() {
        TreeNode root = TalentPoolMgtTreeHelper.createRoot();
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)"0");
    }

    private boolean isLookUp() {
        return ((ListShowParameter)this.getView().getFormShowParameter()).isLookUp();
    }

    public void refreshNode(RefreshNodeEvent e) {
        TreeNode root = this.getTreeModel().getRoot();
        String currNodeId = (String)e.getNodeId();
        TreeNode currNode = root.getTreeNode(currNodeId, 20);
        IPageCache pageCache = this.getPageCache();
        String operation = pageCache.get("operation");
        TPMTreeDto tpmTreeDto = new TPMTreeDto(false, true, false);
        if (operation != null) {
            if (StringUtils.equals((CharSequence)currNodeId, (CharSequence)root.getId())) {
                e.setChildNodes(TalentPoolMgtBaseListPlugin.loadTalentPoolListNode(tpmTreeDto));
            } else {
                tpmTreeDto.setTreeNode(currNode);
                e.setChildNodes(TalentPoolMgtBaseListPlugin.loadSubNode(tpmTreeDto, "B"));
            }
        } else {
            TalentPoolMgtBaseListPlugin.defaultRefreshNode(e, root, currNodeId, currNode, tpmTreeDto);
        }
    }

    public void initializeTree(EventObject e) {
        IPageCache iPageCache = this.getPageCache();
        if (!HRStringUtils.equals((String)"1", (String)iPageCache.get("isFirst"))) {
            this.initTreeNode();
            iPageCache.put("isFirst", "1");
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        if (this.isLookUp()) {
            return;
        }
        TalentPoolMgtBaseListPlugin.commonRecrutypColumnInit(args, this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (HRStringUtils.equals((String)e.getProperty().getName(), (String)"iscontainlower1")) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new TalentPoolMgtPriListDataProvider());
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
        TalentPoolMgtBaseListPlugin.buildTreeListFilter(e, this.getView());
    }

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("level asc ,modifytime desc");
        e.setMainOrgQFilter(null);
        QFilter qFilter = TalentPoolMgtPriHelper.getDefaultFilter((IFormView)this.getView());
        if (this.isLookUp()) {
            qFilter.or(TalentPoolMgtQFilterHelper.getQFilterByID((Long)1030L));
        }
        String nodeId = this.getTreeModel().getCurrentNodeId().toString();
        this.talentPoolMgtPriHelper.notRootAddQFilter(qFilter, nodeId, this.getView(), this.getModel());
        e.setCustomQFilters(Collections.singletonList(qFilter));
    }

    public void afterBindData(EventObject e) {
        TalentPoolMgtBaseListPlugin.afterBindData(this.getView(), this.getTreeModel(), this.treeListView);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        TalentPoolMgtBaseListPlugin.filterContainerBeforeF7Select(args, this.getView());
    }

    public void itemClick(ItemClickEvent evt) {
        Consumer<ItemClickEvent> consumer = OPERATION_MAP.get(evt.getItemKey());
        if (consumer != null) {
            consumer.accept(evt);
        }
    }

    private void tblNew() {
    }

    private void tblDel() {
        this.getPageCache().put("operation", "delete");
        this.getView().invokeOperation("delete");
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (this.talentPoolMgtPriHelper.isDeleteConfirmOperation(event)) {
            this.tblDel();
        }
    }

    private void tblRefresh() {
        this.getPageCache().put("operation", "refresh");
        this.getView().invokeOperation("refresh");
    }

    private void tblExportListBySelectFields() {
        if (this.talentPoolMgtPriHelper.isDeleteData(this.getTreeModel())) {
            this.getView().showTipNotification(TalentPoolMgtEnum.TPM_23.getValue());
            return;
        }
        this.getView().invokeOperation("exportlistbyselectfields");
    }
}

