/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.talentpool.talentpoolmgt;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.mvc.base.BaseView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtPermHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtPubHelper;
import kd.tsc.tsirm.common.constants.talentpool.TalentPoolOpConstants;
import kd.tsc.tsirm.formplugin.web.talentpool.talentpoolmgt.TalentPoolMgtEditPlugin;
import kd.tsc.tsrbd.common.utils.NotDataChangeUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;

public class TalentPoolMgtPubEditPlugin
extends TalentPoolMgtEditPlugin {
    private final TalentPoolMgtPubHelper talentPoolMgtPubHelper = TalentPoolMgtPubHelper.getInstance();
    private static final String CUSTOM_STYLE_STR = "eyJ0eXBlIjowLCJjb250ZW50IjoiJHtcbm9yZGVyOjAgIWltcG9ydGFudDtcbn0ifQ==";

    @Override
    public void registerListener(EventObject eo) {
        super.registerListener(eo);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs pre) {
        BaseShowParameter showParameter = (BaseShowParameter)pre.getSource();
        if (showParameter.getCustomParam("iscopy") == null) {
            String pkId;
            String string = pkId = showParameter.getPkId() == null ? null : showParameter.getPkId().toString();
            if (pkId != null) {
                DynamicObject[] dynamicObjects = TalentPoolMgtHelper.getDynamicObjects((Long)Long.parseLong(pkId));
                Long org = dynamicObjects[0].getLong("org.id");
                Pair permOrgResult = TalentPoolMgtPermHelper.getAllPermOrg((String)showParameter.getFormId(), (String)"4715a0df000000ac");
                if (!((Boolean)permOrgResult.getLeft()).booleanValue() && !((List)permOrgResult.getRight()).contains(org)) {
                    showParameter.setBillStatus(BillOperationStatus.VIEW);
                    showParameter.setStatus(OperationStatus.VIEW);
                }
            }
        }
        super.preOpenForm(pre);
    }

    public void afterCreateNewData(EventObject eo) {
        super.afterCreateNewData(eo);
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        long currentNodeId = Long.parseLong(pageCache.get("currentNodeId"));
        OperationStatus status = ((BaseView)this.getView()).getStatus();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String formId = (String)this.getView().getParentView().getFormShowParameter().getCustomParam("formId");
        Pair addPermItem = TalentPoolMgtPermHelper.getAllPermOrg((String)formId, (String)"47156aff000000ac");
        if (OperationStatus.ADDNEW == status) {
            if ("tsirm_talentpoolmgt_onjob".equals(formId)) {
                this.getModel().setValue("pooltype", (Object)"A");
            } else {
                this.getModel().setValue("pooltype", (Object)"B");
            }
            if (currentNodeId == 0L) {
                if ("tsirm_talentpoolmgt_onjob".equals(formId)) {
                    currentNodeId = 1020L;
                    this.getModel().setValue("parent", (Object)1020L);
                } else {
                    currentNodeId = 1030L;
                    this.getModel().setValue("parent", (Object)1030L);
                    this.getModel().setValue("parent", (Object)1030L);
                }
            }
            if (currentNodeId == 1020L || currentNodeId == 1030L) {
                this.getModel().setValue("nodetype", (Object)"A");
            } else {
                this.getModel().setValue("nodetype", (Object)"B");
                this.talentPoolMgtPubHelper.setParentValue(this.getModel(), addPermItem);
            }
        }
        this.talentPoolMgtPubHelper.setOrgValue(this.getModel(), addPermItem, dataEntity.getLong("parent.org.id"));
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.getModel().setDataChanged(false);
    }

    public void afterLoadData(EventObject event) {
        super.afterLoadData(event);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        this.getPageCache().put("pooltype", "A");
        super.beforeF7Select(beforeF7SelectEvent);
        String name = beforeF7SelectEvent.getProperty().getName();
        String formId = (String)this.getView().getParentView().getFormShowParameter().getCustomParam("formId");
        if (HRStringUtils.equals((String)name, (String)"org")) {
            this.talentPoolMgtPubHelper.beforeF7SelectOrg(beforeF7SelectEvent, formId);
        } else if (HRStringUtils.equals((String)name, (String)"parent")) {
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("formId", (Object)this.getView().getFormShowParameter().getFormId());
            this.talentPoolMgtPubHelper.beforeF7SelectParent(beforeF7SelectEvent, this.getView().getParentView().getParentView());
            QFilter defaultFilter = TalentPoolMgtPubHelper.getInstance().getDefaultFilter(this.getView().getParentView());
            if ("tsirm_talentpoolmgt_onjob".equals(formId)) {
                defaultFilter.or("id", "=", (Object)TalentPoolOpConstants.ID_TALENT_ON_JOB);
            } else {
                defaultFilter.or("id", "=", (Object)TalentPoolOpConstants.ID_TALENT_DIMI);
            }
            beforeF7SelectEvent.getCustomQFilters().add(defaultFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs pca) {
        super.propertyChanged(pca);
        String propertyName = pca.getProperty().getName();
        ChangeData[] changeSet = pca.getChangeSet();
        if (HRStringUtils.equals((String)propertyName, (String)"nodetype")) {
            this.setPluginOrderAndValue(changeSet[0]);
        } else if (HRStringUtils.equals((String)propertyName, (String)"parent")) {
            this.getModel().setValue("org", (Object)this.getModel().getDataEntity().getLong("parent.org.id"));
        } else if (HRStringUtils.equals((String)propertyName, (String)"secselect")) {
            if (this.getPageCache().get("oldSecLevel") == null) {
                this.getPageCache().put("oldSecLevel", (String)changeSet[0].getOldValue());
            }
            String newValue = (String)changeSet[0].getNewValue();
            this.getPageCache().put("newSecLevel", newValue);
        }
    }

    private void setPluginOrderAndValue(ChangeData changeData) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        DynamicObject dataEntity = model.getDataEntity();
        String newValue = (String)changeData.getNewValue();
        String customStyleStr = "";
        String ROOT_ORG = "rootOrg";
        String SUB_ORG = "subOrg";
        String SUB_PARENT = "subParent";
        if (HRStringUtils.equals((String)newValue, (String)"A")) {
            pageCache.put(SUB_ORG, String.valueOf(dataEntity.getLong("org.id")));
            pageCache.put(SUB_PARENT, String.valueOf(dataEntity.getLong("parent.id")));
            model.setValue("parent", (Object)1020L);
            boolean isEmpty = HRStringUtils.equals((String)pageCache.get(ROOT_ORG), (String)"0");
            model.setValue("org", isEmpty ? null : pageCache.get(ROOT_ORG));
        } else {
            pageCache.put(ROOT_ORG, String.valueOf(dataEntity.getLong("org.id")));
            boolean parentIsEmpty = HRStringUtils.equals((String)pageCache.get(SUB_PARENT), (String)"0");
            boolean orgIsEmpty = HRStringUtils.equals((String)pageCache.get(SUB_ORG), (String)"0");
            model.setValue("parent", parentIsEmpty ? null : pageCache.get(SUB_PARENT));
            model.setValue("org", orgIsEmpty ? null : pageCache.get(SUB_ORG));
            customStyleStr = CUSTOM_STYLE_STR;
        }
        HashMap<String, String> data = new HashMap<String, String>(4);
        data.put("cstyles", customStyleStr);
        view.updateControlMetadata("parent", data);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String formId = (String)this.getView().getParentView().getFormShowParameter().getCustomParam("formId");
        Pair allPermOrg = TalentPoolMgtPermHelper.getAllPermOrg((String)formId, (String)"47150e89000000ac");
        List permOrgList = (List)allPermOrg.getRight();
        long currOrgId = this.getModel().getDataEntity().getLong("org.id");
        boolean hasDataPerm = Boolean.FALSE;
        if (ObjectUtils.isNotEmpty((Object)permOrgList) && permOrgList.contains(currOrgId)) {
            hasDataPerm = Boolean.TRUE;
        }
        if (!hasDataPerm) {
            this.getView().getParentView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"TalentPoolMgtPubEditPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        Control source = (Control)evt.getSource();
        if (HRStringUtils.equals((String)"btnsave", (String)source.getKey())) {
            OperationStatus status = ((BaseView)this.getView()).getStatus();
            boolean isOperation = true;
            if (OperationStatus.EDIT == status) {
                this.getPageCache().put("OperationStatus", OperationStatus.EDIT.toString());
                isOperation = this.talentPoolMgtPubHelper.edit(this.getView(), this.getModel(), (IFormPlugin)this);
            } else if (OperationStatus.ADDNEW == status) {
                this.getPageCache().put("OperationStatus", OperationStatus.ADDNEW.toString());
                isOperation = this.talentPoolMgtPubHelper.add(this.getView(), this.getModel());
            }
            if (isOperation) {
                this.getView().invokeOperation("save");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            NotDataChangeUtils.setPropertyNotDataChanged((IDataModel)this.getModel(), (String[])new String[]{"fullname", "longnumber"});
            return;
        }
        this.talentPoolMgtPubHelper.afterDoOperation(afterDoOperationEventArgs, this.getView(), this.getModel());
        IListView listView = (IListView)this.getView().getParentView();
        ITreeListView treeListView = listView.getTreeListView();
        Long currentNodeId = Long.parseLong(treeListView.getTreeModel().getCurrentNodeId().toString());
        if (!TalentPoolMgtHelper.queryTalentPoolByIdWithTryCatch((Long)currentNodeId)) {
            treeListView.getTreeModel().setCurrentNodeId((Object)treeListView.getTreeModel().getRoot().getId());
            treeListView.getTreeView().focusNode(treeListView.getTreeModel().getRoot());
            treeListView.refresh();
        }
    }

    public void afterCopyData(EventObject eo) {
        super.afterCopyData(eo);
        long orgID = this.getModel().getDataEntity().getLong("org.id");
        String nodeType = this.getModel().getDataEntity().getString("nodetype");
        Pair addPermItem = TalentPoolMgtPermHelper.getAllPermOrg((String)"47156aff000000ac");
        if (HRStringUtils.equals((String)nodeType, (String)"B")) {
            this.talentPoolMgtPubHelper.setParentValue(this.getModel(), addPermItem);
        }
        this.talentPoolMgtPubHelper.setOrgValue(this.getModel(), addPermItem, orgID);
        Long parentId = this.getModel().getDataEntity().getLong("parent.id");
        if (1020L == parentId || 1030L == parentId) {
            this.getModel().setValue("org", (Object)this.getModel().getDataEntity().getLong("org.id"));
        }
    }
}

