/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.talentpool.talentpoolmgt;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.talentpool.service.CheckPermissionHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentListDaoHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtPermHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtPubHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtQFilterHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtTreeHelper;
import kd.tsc.tsirm.common.constants.talentpool.TPMTreeDto;
import kd.tsc.tsirm.common.constants.talentpool.TSTPMTalentPoolConstants;
import kd.tsc.tsirm.common.enums.talentpool.TalentPoolMgtEnum;
import kd.tsc.tsirm.formplugin.web.talentpool.talentpoolmgt.TalentPoolMgtBaseListPlugin;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.common.service.ListFilterCommonHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class TalentPoolMgtPubListPlugin
extends StandardTreeListPlugin {
    private final TalentPoolMgtPubHelper talentPoolMgtPubHelper = TalentPoolMgtPubHelper.getInstance();
    private static final HashMap<String, Consumer<ItemClickEvent>> OPERATION_MAP = new HashMap(4);

    public TalentPoolMgtPubListPlugin() {
        OPERATION_MAP.put("tbldel", evt -> this.tblDel());
        OPERATION_MAP.put("tblrefresh", evt -> this.tblRefresh());
        OPERATION_MAP.put("tblcopy", evt -> this.tblCopy());
        OPERATION_MAP.put("exportbylist", evt -> this.tblExportListBySelectFields());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    private void initTreeNode() {
        TreeNode root = TalentPoolMgtTreeHelper.createRoot();
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)"0");
    }

    public void refreshNode(RefreshNodeEvent e) {
        TreeNode root = this.getTreeModel().getRoot();
        String currNodeId = (String)e.getNodeId();
        TreeNode currNode = root.getTreeNode(currNodeId, 20);
        IPageCache pageCache = this.getPageCache();
        String operation = pageCache.get("operation");
        TPMTreeDto tpmTreeDto = this.setTreeDto();
        if (operation != null) {
            if (StringUtils.equals((CharSequence)currNodeId, (CharSequence)root.getId())) {
                tpmTreeDto.setContainLower(true);
                e.setChildNodes(TalentPoolMgtBaseListPlugin.loadTalentPoolListNode(tpmTreeDto));
            } else if ("delete".equals(operation)) {
                tpmTreeDto.setTreeNode(currNode);
                tpmTreeDto.setFromDelete(Boolean.valueOf(true));
                this.getTreeModel().setCurrentNodeId((Object)currNodeId);
            } else {
                tpmTreeDto.setTreeNode(currNode);
                e.setChildNodes(TalentPoolMgtBaseListPlugin.loadSubNode(tpmTreeDto, tpmTreeDto.getPoolType()));
                tpmTreeDto.setContainLower(((Boolean)this.getModel().getValue("iscontainlower1")).booleanValue());
            }
        }
        TalentPoolMgtBaseListPlugin.defaultRefreshNode(e, root, currNodeId, currNode, tpmTreeDto);
    }

    private TPMTreeDto setTreeDto() {
        TPMTreeDto tpmTreeDto = new TPMTreeDto();
        tpmTreeDto.setPermissionItem(TalentPoolMgtPubHelper.getPermissionItem((IFormView)this.getView()));
        ListShowParameter lsp = (ListShowParameter)this.getView().getFormShowParameter();
        if (lsp.isLookUp()) {
            tpmTreeDto.setLookUp(Boolean.TRUE);
        } else {
            tpmTreeDto.setLookUp(Boolean.FALSE);
        }
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        if (ObjectUtils.isEmpty((Object)formId)) {
            formId = lsp.getBillFormId();
            if ("tsirm_talent_onjob_auto".equals(formId)) {
                tpmTreeDto.setPoolType("A");
                tpmTreeDto.setPubTPM(true);
                tpmTreeDto.setPageNumber("tsirm_talentpoolmgt_onjob");
                tpmTreeDto.setNotContainIds((List)ImmutableList.of((Object)TSTPMTalentPoolConstants.ON_JOB_TP_ALLOCATED));
            } else if ("tsirm_talent_dimi_auto".equals(formId)) {
                tpmTreeDto.setPoolType("B");
                tpmTreeDto.setPriTPM(true);
                tpmTreeDto.setPageNumber("tsirm_talentpoolmgt_dimi");
                tpmTreeDto.setNotContainIds((List)ImmutableList.of((Object)TSTPMTalentPoolConstants.DIMI_TP_ALLOCATED));
            }
        } else if ("tsirm_talentpoolmgt_onjob".equals(formId)) {
            tpmTreeDto.setPoolType("A");
            tpmTreeDto.setPubTPM(true);
            tpmTreeDto.setPageNumber("tsirm_talentpoolmgt_onjob");
        } else {
            tpmTreeDto.setPoolType("B");
            tpmTreeDto.setPriTPM(true);
            tpmTreeDto.setPageNumber("tsirm_talentpoolmgt_dimi");
        }
        return tpmTreeDto;
    }

    public void initializeTree(EventObject e) {
        IPageCache iPageCache = this.getPageCache();
        if (!HRStringUtils.equals((String)"1", (String)iPageCache.get("isFirst"))) {
            long orgId = TSCRequestContext.getOrgId();
            Pair permOrgResult = this.talentPoolMgtPubHelper.checkHasPermOrgResult(this.getView());
            if (!((List)permOrgResult.getRight()).contains(orgId)) {
                orgId = ((List)permOrgResult.getRight()).size() > 0 ? (Long)((List)permOrgResult.getRight()).get(0) : 0L;
            }
            this.getPageCache().put("org", String.valueOf(orgId));
            this.initTreeNode();
            iPageCache.put("isFirst", "1");
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        if (TalentPoolMgtPubHelper.isLookUp((IFormView)this.getView())) {
            return;
        }
        this.commonOrgColumnInit(args, this.getView());
    }

    public void commonOrgColumnInit(FilterContainerInitArgs args, IFormView view) {
        CommonFilterColumn orgColumn = (CommonFilterColumn)args.getFilterColumn("org.name");
        if (!TalentPoolMgtPermHelper.isSuperUser()) {
            Pair permOrgResult = this.talentPoolMgtPubHelper.checkHasPermOrgResult(view);
            ListFilterCommonHelper.generalCommonColumnInit((CommonFilterColumn)orgColumn, (QFilter[])new QFilter[]{TalentPoolMgtQFilterHelper.getQFilter((List)((List)permOrgResult.getRight()), (String)"id")}, (String)"bos_org", (String)"id");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (HRStringUtils.equals((String)e.getProperty().getName(), (String)"iscontainlower1")) {
            Object currentNodeId = this.getTreeModel().getCurrentNodeId();
            this.getTreeListView().refreshTreeNode(currentNodeId.toString());
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        String filterValue = String.valueOf(args.getFilterValue("org.id")).replaceAll("[\\[\\]]", "");
        IPageCache iPageCache = this.getPageCache();
        iPageCache.put("org", filterValue);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        if (TalentPoolMgtPermHelper.querySecurityConf()) {
            List listColumns = args.getListColumns();
            ListColumn secLevel = TalentPoolMgtPubHelper.createListColumn((String)"seclevel.codelevel", (String)TalentPoolMgtEnum.TPM_25.getValue(), (int)1);
            listColumns.add(listColumns.size() - 2, secLevel);
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent evt) {
        super.buildTreeListFilter(evt);
        TalentPoolMgtBaseListPlugin.buildTreeListFilter(evt, this.getView());
    }

    public void setFilter(SetFilterEvent e) {
        IFormView parentView = this.getView().getParentView();
        this.getView().sendFormAction(parentView);
        e.setOrderBy("level asc ,modifytime desc");
        QFilter qFilter = this.talentPoolMgtPubHelper.getDefaultFilter(this.getView());
        String nodeId = this.getTreeModel().getCurrentNodeId().toString();
        if ("1040".equals(nodeId) || "1050".equals(nodeId)) {
            qFilter.and("id", "=", null);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tblnew", "tbldele", "tblrefresh", "close"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tblnew", "tbldele", "tblrefresh", "close"});
        }
        this.talentPoolMgtPubHelper.notRootAddQFilter(qFilter, nodeId, this.getView(), this.getModel());
        qFilter.and("id", "not in", (Object)ImmutableList.of((Object)TSTPMTalentPoolConstants.ON_JOB_TP_ALLOCATED, (Object)TSTPMTalentPoolConstants.DIMI_TP_ALLOCATED));
        e.setCustomQFilters(Collections.singletonList(qFilter));
    }

    public void afterBindData(EventObject e) {
        TalentPoolMgtBaseListPlugin.afterBindData(this.getView(), this.getTreeModel(), this.treeListView);
        this.getTreeListView().getTreeView().setRootVisible(false);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        TalentPoolMgtBaseListPlugin.filterContainerBeforeF7Select(args, this.getView());
        if (args.getFieldName().contains("org")) {
            Pair permOrgResult = this.talentPoolMgtPubHelper.checkHasPermOrgResult(this.getView());
            args.addCustomQFilter(TalentPoolMgtQFilterHelper.getQFilter((List)((List)permOrgResult.getRight()), (String)"id"));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        Object primaryKeyValue = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
        DynamicObject[] dynamicObjects = TalentPoolMgtHelper.getDynamicObjects((Long)((Long)primaryKeyValue));
        if (dynamicObjects.length == 0) {
            this.getView().showTipNotification(TalentPoolMgtEnum.TPM_23.getValue());
            args.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        Consumer<ItemClickEvent> consumer = OPERATION_MAP.get(evt.getItemKey());
        if (consumer != null) {
            consumer.accept(evt);
        }
        if ("tbldele".equals(itemKey = evt.getItemKey())) {
            this.tblDel();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (operateKey.equals("delete")) {
            String formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
            Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
            ArrayList<Long> primaryKeyList = new ArrayList<Long>(16);
            for (Object primaryKeyValue : primaryKeyValues) {
                primaryKeyList.add(Long.parseLong(primaryKeyValue.toString()));
            }
            Map talentPoolPermMap = CheckPermissionHelper.getInstance().checkTalentPoolPerm(primaryKeyList, formId);
            boolean permChange = talentPoolPermMap.containsValue(Boolean.FALSE);
            if (permChange) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"TalentPoolMgtPubEditPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                args.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            CheckPermissionHelper.getInstance().selectComPerTalentPool(formId, "47150e89000000ac");
        }
        TalentPoolMgtBaseListPlugin.saveCheck(this.getView(), this.getTreeModel(), "A", args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (ObjectUtils.isNotEmpty((Object)afterDoOperationEventArgs.getOperationResult())) {
            boolean success = afterDoOperationEventArgs.getOperationResult().isSuccess();
            if ("delete".equals(operateKey) && success) {
                this.getView().getPageCache().put("operation", "delete");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (this.talentPoolMgtPubHelper.isDeleteConfirmOperation(event)) {
            Object currentNodeId = this.getTreeModel().getCurrentNodeId();
            TreeNode currentNode = this.getTreeListView().getTreeModel().getRoot().getTreeNode(currentNodeId.toString());
            String parentId = currentNode.getParentid();
            OperationResult deletePerm = this.getView().invokeOperation("deleteperm");
            if (ObjectUtils.isNotEmpty((Object)deletePerm) && !deletePerm.isSuccess()) {
                return;
            }
            Object[] selectRowIds = this.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
            Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
            ArrayList<Long> primaryKeyList = new ArrayList<Long>(16);
            for (Object primaryKeyValue : primaryKeyValues) {
                primaryKeyList.add(Long.parseLong(primaryKeyValue.toString()));
            }
            String formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
            Map talentPoolPermMap = CheckPermissionHelper.getInstance().checkTalentPoolPerm(primaryKeyList, formId);
            boolean permChange = talentPoolPermMap.containsValue(Boolean.FALSE);
            if (permChange) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"TalentPoolMgtPubEditPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                return;
            }
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"tsirm_talentpoolmgt_pub", (Object[])selectRowIds, (OperateOption)OperateOption.create());
            this.getView().getPageCache().put("operation", "delete");
            DynamicObject dynObj = TalentListDaoHelper.getInstance().getTalentPool(currentNodeId.toString());
            if (ObjectUtils.isEmpty((Object)dynObj)) {
                this.treeListView.getTreeView().focusNode(this.getTreeModel().getRoot().getTreeNode(parentId));
                this.getTreeModel().setCurrentNodeId((Object)parentId);
            }
            this.getView().invokeOperation("refresh");
            if (operationResult.getSuccessPkIds().size() == selectRowIds.length) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"TalentPoolMgtPubListPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showOperationResult(operationResult);
            }
        }
    }

    private void tblDel() {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        if (!TalentPoolMgtPermHelper.checkPerm((String)formId, (String)"4715e1f1000000ac")) {
            ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            this.getView().showErrorNotification(String.format(TalentPoolMgtEnum.TPM_37.getValue(), formShowParameter.getFormName()));
            return;
        }
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (ObjectUtils.isEmpty((Object)selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TalentPoolMgtPubListPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return;
        }
        List collect = selectedRows.stream().map(listSelectedRow -> (Long)listSelectedRow.getPrimaryKeyValue()).collect(Collectors.toList());
        DynamicObject[] subTalentPools = TalentPoolMgtHelper.queryTalentPool((QFilter)new QFilter("parent", "in", collect));
        DynamicObject[] TalentPools = TalentPoolMgtHelper.queryTalentPool((QFilter)new QFilter("id", "in", collect));
        StringBuilder talentPoolNameBdr = new StringBuilder();
        int hasSubTalentPoolSize = 0;
        for (int i = 0; i < collect.size(); ++i) {
            Long talentPoolId = (Long)collect.get(i);
            Optional<DynamicObject> first = Arrays.stream(subTalentPools).filter(dynamicObject -> dynamicObject.getLong("parent.id") == talentPoolId.longValue()).findFirst();
            if (!first.isPresent()) continue;
            ++hasSubTalentPoolSize;
            DynamicObject talentPoolDy = Arrays.stream(TalentPools).filter(dynamicObject -> dynamicObject.getLong("id") == talentPoolId.longValue()).findFirst().get();
            if (i == collect.size() - 1) {
                talentPoolNameBdr.append(talentPoolDy.getString("name"));
                continue;
            }
            talentPoolNameBdr.append(talentPoolDy.getString("name")).append("\u3001");
        }
        if (hasSubTalentPoolSize > 0) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("delete", (IFormPlugin)this);
            String msg = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684{0}\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\r\n\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"AbstractListView_1", (String)"bos-form-mvc", (Object[])new Object[0]).replace("{0}", String.valueOf(selectedRows.size()));
            String msgDetail = String.format(ResManager.loadKDString((String)"\u4eba\u624d\u5e93%s\u7b49%s\u4e2a\u4eba\u624d\u5e93\u5305\u542b\u4e0b\u7ea7\u4eba\u624d\u5e93\uff0c\u5220\u9664\u64cd\u4f5c\u5c06\u8fde\u540c\u6240\u6709\u4e0b\u7ea7\u4eba\u624d\u5e93\u5168\u90e8\u5220\u9664\uff0c\u4e14\u4e0d\u53ef\u6062\u590d\u3002", (String)"TalentPoolMgtPubListPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), talentPoolNameBdr.toString(), hasSubTalentPoolSize);
            this.getView().showConfirm(msg, msgDetail, MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBacks);
        } else {
            this.getView().invokeOperation("delete");
        }
    }

    private void tblRefresh() {
        this.getPageCache().put("operation", "refresh");
        this.getView().invokeOperation("refresh");
        this.getTreeListView().refreshTreeNode(this.getTreeModel().getCurrentNodeId().toString());
    }

    private void tblCopy() {
    }

    private void tblExportListBySelectFields() {
        if (this.talentPoolMgtPubHelper.isDeleteData(this.getTreeModel())) {
            this.getView().showTipNotification(TalentPoolMgtEnum.TPM_23.getValue());
            return;
        }
        this.getView().invokeOperation("exportlistbyselectfields");
    }

    public void packageData(PackageDataEvent e) {
        Object formatValue = e.getFormatValue();
        if (ObjectUtils.isEmpty((Object)formatValue)) {
            e.setFormatValue((Object)"-");
        }
    }
}

