/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.mservice.intv;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tsc.tsirm.business.domain.intv.service.IntvEvlHelper;
import kd.tsc.tsirm.business.domain.intv.service.IntvTaskHelper;
import kd.tsc.tsirm.business.domain.intv.service.calendar.SetAbleInterviewTimeFormHelper;
import kd.tsc.tsirm.business.domain.intv.service.home.IntvEvlServiceImp;
import kd.tsc.tsirm.business.domain.intv.service.home.TssrmServiceCache;
import kd.tsc.tsirm.common.util.IntvDateUtil;
import kd.tsc.tsirm.mservice.api.intv.IInterviewCalendarService;
import kd.tsc.tsrbd.common.enums.InterviewTimeWayEnum;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.lang.ArrayUtils;

public class InterviewCalendarServiceImpl
implements IInterviewCalendarService {
    private static final Log LOG = LogFactory.getLog(InterviewCalendarServiceImpl.class);
    private static final IntvTaskHelper TASK_HELPER = IntvTaskHelper.getInstance();
    private IntvEvlServiceImp intvEvlService = (IntvEvlServiceImp)TssrmServiceCache.get(IntvEvlServiceImp.class);

    public List<Object> getInterviewCalendarList(Date startDate, Date endDate) {
        LOG.info("InterviewCalendarServiceImpl.getInterviewCalendarList param startDate : {} endData : {}", (Object)startDate, (Object)endDate);
        return TASK_HELPER.getIntvCalendarLists(startDate, endDate);
    }

    public DynamicObject[] listTodayInterviewEvl() {
        return this.intvEvlService.listTodayIntvEvl();
    }

    public Map<String, Long> getIntverviewMap() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        QFilter qFilter = new QFilter("handlestatus", "=", (Object)"A").and("interviewer", "=", (Object)TSCRequestContext.getUserId());
        Object[] intvEvls = IntvEvlHelper.getInstance().queryIntvEvl("id,intvgroup.intvdate", qFilter, "id");
        Date now = IntvDateUtil.getStartDate((Date)new Date());
        if (ArrayUtils.isNotEmpty((Object[])intvEvls)) {
            List collect = Arrays.stream(intvEvls).filter(intvEvl -> intvEvl.getDate("intvgroup.intvdate").after(now) || intvEvl.getDate("intvgroup.intvdate").getTime() == now.getTime()).collect(Collectors.toList());
            map.put("tobeadvanced", Long.valueOf(intvEvls.length));
            map.put("tobeinterviewed", collect.isEmpty() ? 0L : (long)collect.size());
        } else {
            map.put("tobeadvanced", 0L);
            map.put("tobeinterviewed", 0L);
        }
        return map;
    }

    public BaseShowParameter getSetInterviewTimeFormParameter(String formId, InterviewTimeWayEnum interviewTimeWay, Long interviewId, Long candidateId, CloseCallBack closeCallBack) {
        return SetAbleInterviewTimeFormHelper.getSetInterviewTimePage((String)formId, (InterviewTimeWayEnum)interviewTimeWay, (Long)interviewId, (Long)candidateId, (CloseCallBack)closeCallBack);
    }
}

