/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.op.advert;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tsc.tsirm.business.domain.advert.service.AdvertApprovalDataHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBizService;
import kd.tsc.tsirm.business.domain.advert.service.AdvertDetailExDataHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertTplExCommonHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertTplExDataHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionDataHelper;
import org.apache.commons.lang.ArrayUtils;

public class AdvertApproveStatusOp
extends HRDataBaseOp {
    private static final Log LOGGER = LogFactory.getLog(AdvertApproveStatusOp.class);
    AdvertDetailExDataHelper detailExDataHelper = AdvertDetailExDataHelper.getInstance();

    public void endOperationTransaction(EndOperationTransactionArgs evt) {
        super.endOperationTransaction(evt);
        String operationKey = evt.getOperationKey();
        DynamicObject[] dataEntities = evt.getDataEntities();
        List billIds = Arrays.stream(dataEntities).mapToLong(dataEntity -> dataEntity.getLong("id")).boxed().collect(Collectors.toCollection(() -> Lists.newArrayListWithCapacity((int)dataEntities.length)));
        Object[] dbDynamicObjects = AdvertApprovalDataHelper.getInstance().loadApprovalData(dataEntities);
        if ("approvaled".equals(operationKey)) {
            if (ArrayUtils.isNotEmpty((Object[])dbDynamicObjects) && dbDynamicObjects.length == 1 && dbDynamicObjects[0].getDynamicObjectCollection("entryentity").size() == 1) {
                long channelId = ((DynamicObject)dbDynamicObjects[0].getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("channel").getLong("id");
                boolean enable = AdvertBizService.getInstance().getChannelIdIsEnable(Long.valueOf(channelId));
                if (enable) {
                    AdvertTplExCommonHelper.updateAdvertByApproval((DynamicObject[])dbDynamicObjects, (boolean)false);
                }
            } else {
                AdvertTplExCommonHelper.updateAdvertByApproval((DynamicObject[])dbDynamicObjects, (boolean)false);
            }
            this.detailExDataHelper.updateApproveStatusByApprovalIds(billIds, "C", "S");
        } else if ("unapproval".equals(operationKey)) {
            this.detailExDataHelper.updateApproveStatusByApprovalIdsWhenAgain(billIds, "E", "K");
        } else if ("approvaling".equals(operationKey)) {
            this.detailExDataHelper.updateApproveStatusByApprovalIdsWhenAgain(billIds, "D", "A");
        } else if ("wait".equals(operationKey)) {
            this.detailExDataHelper.updateApproveStatusByApprovalIdsWhenAgain(billIds, "G", "A");
        } else if ("rollbacksubmit".equals(operationKey)) {
            this.detailExDataHelper.updateApproveStatusByApprovalIdsWhenAgain(billIds, "B", "A");
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs evt) {
        super.afterExecuteOperationTransaction(evt);
        String operationKey = evt.getOperationKey();
        DynamicObject[] dataEntities = evt.getDataEntities();
        if ("approvaled".equals(operationKey)) {
            List billIds = Arrays.stream(dataEntities).mapToLong(dataEntity -> dataEntity.getLong("id")).boxed().collect(Collectors.toCollection(() -> Lists.newArrayListWithCapacity((int)dataEntities.length)));
            try {
                List positionIds = AdvertApprovalDataHelper.getInstance().getPosIdsByBillId(billIds);
                Map positionAdvCounts = AdvertTplExDataHelper.getInstance().countAdvert(positionIds);
                PositionDataHelper.updatePubCountByPositionId((Map)positionAdvCounts, (List)positionIds);
            }
            catch (Exception exception) {
                LOGGER.error("\u66f4\u65b0\u804c\u4f4d\u5e7f\u544a\u6570\u91cf\u5931\u8d25", (Object)evt);
            }
        }
    }
}

