/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.op.advert;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBizService;
import kd.tsc.tsirm.business.domain.advert.service.AdvertConfigHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertDetailExDataHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertTplExCommonHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertTplExDataHelper;
import kd.tsc.tsirm.common.util.CommonUtils;
import kd.tsc.tsrbs.common.utils.ObjectUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AdvertListOp
extends HRDataBaseOp {
    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        String operateKey = args.getOperationKey();
        Object[] dbDataEntities = HRStringUtils.equals((String)operateKey, (String)"startadvert") ? this.getDBDataEntitiesForEnable(dataEntities) : this.getDBDataEntities(dataEntities);
        switch (operateKey) {
            case "refreashadvert": {
                this.advertRefresh((DynamicObject[])dbDataEntities);
                break;
            }
            case "top": {
                this.advertTop((DynamicObject[])dbDataEntities, true);
                break;
            }
            case "untop": {
                this.advertTop((DynamicObject[])dbDataEntities, false);
                break;
            }
            case "urgent": {
                this.advertUrgent((DynamicObject[])dbDataEntities, true);
                break;
            }
            case "unurgent": {
                this.advertUrgent((DynamicObject[])dbDataEntities, false);
                break;
            }
            case "stopadvert": {
                this.advertEnable((DynamicObject[])dbDataEntities, false);
                break;
            }
            case "startadvert": {
                this.advertEnable((DynamicObject[])dbDataEntities, true);
                break;
            }
            case "stopadvertall": {
                this.advertDisableAll((DynamicObject[])dbDataEntities);
                break;
            }
        }
        AdvertDetailExDataHelper.getInstance().saveAdvertDetail((List)Lists.newArrayList((Object[])dbDataEntities));
    }

    private DynamicObject[] getDBDataEntitiesForEnable(DynamicObject[] dataEntities) {
        Long[] ids = new Long[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            ids[i] = dataEntities[i].getLong("id");
        }
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        return AdvertDetailExDataHelper.getInstance().getAdvertListByFilter(new QFilter[]{qFilter}, null);
    }

    private void advertDisableAll(DynamicObject[] dbDataEntities) {
        Date date = new Date();
        for (DynamicObject dataEntity : dbDataEntities) {
            if (!dataEntity.getString("advertstatus").equals("S")) continue;
            dataEntity.set("advertstatus", (Object)"D");
            dataEntity.set("stoptime", (Object)date);
        }
    }

    private DynamicObject[] getDBDataEntities(DynamicObject[] dataEntities) {
        Long[] ids = new Long[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            ids[i] = dataEntities[i].getLong("id");
        }
        return AdvertDetailExDataHelper.getInstance().queryAdvertDetail(ids);
    }

    private void advertRefresh(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("refreshtime", (Object)new Date());
        }
    }

    private void advertTop(DynamicObject[] dataEntities, boolean top) {
        long currUserId = RequestContext.getOrCreate().getCurrUserId();
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("istop", (Object)top);
            if (top) {
                dataEntity.set("topuser", (Object)currUserId);
                dataEntity.set("topstarttime", (Object)new Date());
                dataEntity.set("topendtime", null);
                continue;
            }
            dataEntity.set("topuser", null);
            dataEntity.set("topstarttime", null);
            dataEntity.set("topendtime", (Object)new Date());
        }
    }

    private void advertUrgent(DynamicObject[] dataEntities, boolean urgent) {
        long currUserId = RequestContext.getOrCreate().getCurrUserId();
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("isurgent", (Object)urgent);
            if (urgent) {
                dataEntity.set("urgentuser", (Object)currUserId);
                dataEntity.set("urgentstarttime", (Object)new Date());
                dataEntity.set("urgentendtime", null);
                continue;
            }
            dataEntity.set("urgentuser", null);
            dataEntity.set("urgentstarttime", null);
            dataEntity.set("urgentendtime", (Object)new Date());
        }
    }

    private void advertEnable(DynamicObject[] dataEntities, boolean enable) {
        if (dataEntities == null || dataEntities.length == 0) {
            this.operationResult.setSuccess(false);
            this.operationResult.setMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"AdvertListOp_0", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList advertBillList = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        if (enable) {
            ArrayList directPubList = Lists.newArrayListWithExpectedSize((int)10);
            ArrayList waitPubList = Lists.newArrayListWithExpectedSize((int)10);
            ArrayList needApprovalList = Lists.newArrayListWithExpectedSize((int)10);
            for (DynamicObject dataEntity : dataEntities) {
                boolean isEndFuture;
                long oldAdvertId = dataEntity.getDynamicObject("channel").getLong("id");
                Boolean needAuditByChannel = AdvertConfigHelper.needAuditByChannel((Long)oldAdvertId);
                Date startDate = dataEntity.getDate("startdate");
                Date endDate = dataEntity.getDate("enddate");
                Date now = CommonUtils.getBeginDate((Date)new Date());
                boolean isFuture = null != startDate && CommonUtils.dateAfter((Date)startDate, (Date)now);
                boolean bl = isEndFuture = null != endDate && CommonUtils.dateAfter((Date)now, (Date)endDate);
                if (needAuditByChannel.booleanValue()) {
                    needApprovalList.add(dataEntity);
                } else if (isFuture || isEndFuture) {
                    waitPubList.add(dataEntity);
                } else {
                    directPubList.add(dataEntity);
                }
                AdvertTplExCommonHelper.activeOldAdvertBill((DynamicObject)dataEntity, (List)advertBillList, (Boolean)needAuditByChannel);
            }
            Map<Long, DynamicObject> advertMap = Arrays.stream(dataEntities).collect(Collectors.toMap(advert -> advert.getLong("id"), advert -> advert, (oldValue, newValue) -> newValue));
            ArrayList<DynamicObject> matchWorkFLowErrList = new ArrayList<DynamicObject>(advertBillList.size());
            if (CollectionUtils.isNotEmpty((Collection)advertBillList)) {
                ArrayList advertBillPassList = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
                for (DynamicObject advertBill : advertBillList) {
                    String matchErrMsg = AdvertTplExCommonHelper.matchWorkflowCheck((DynamicObject)advertBill);
                    if (HRStringUtils.isEmpty((String)matchErrMsg)) {
                        advertBillPassList.add(advertBill);
                        continue;
                    }
                    DynamicObjectCollection billEntity = advertBill.getDynamicObjectCollection("entryentity");
                    Long advertId = ObjectUtils.getLongValOfObject((Object)((DynamicObject)billEntity.get(0)).get("advertid"));
                    DynamicObject advert2 = advertMap.get(advertId);
                    if (advert2 == null) {
                        this.operationResult.setSuccess(false);
                        this.operationResult.setMessage(matchErrMsg);
                        return;
                    }
                    needApprovalList.remove(advert2);
                    matchWorkFLowErrList.add(advert2);
                }
                if (CollectionUtils.isNotEmpty((Collection)advertBillPassList)) {
                    AdvertTplExCommonHelper.touchOffWorkFlows((List)advertBillPassList);
                }
            }
            List errorInfoList = this.operationResult.getAllErrorOrValidateInfo();
            List matchWorkFLowErrors = CollectionUtils.isEmpty(matchWorkFLowErrList) ? Collections.emptyList() : AdvertTplExCommonHelper.getAuditAdvErrors(matchWorkFLowErrList);
            Pair result = AdvertBizService.getInstance().getPublishMsg((List)needApprovalList, (List)directPubList, (List)waitPubList, matchWorkFLowErrors, errorInfoList, true);
            this.operationResult.setSuccess(true);
            this.operationResult.setShowMessage(false);
            this.operationResult.setMessage(SerializationUtils.serializeToBase64((Object)result));
        } else {
            Date now = new Date();
            for (DynamicObject dataEntity : dataEntities) {
                dataEntity.set("advertstatus", (Object)"D");
                dataEntity.set("stoptime", (Object)new Date());
                if (dataEntity.getBoolean("istop")) {
                    dataEntity.set("istop", (Object)false);
                    dataEntity.set("topstarttime", null);
                    dataEntity.set("topendtime", (Object)now);
                }
                if (!dataEntity.getBoolean("isurgent")) continue;
                dataEntity.set("isurgent", (Object)false);
                dataEntity.set("urgentstarttime", null);
                dataEntity.set("urgentendtime", (Object)now);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        super.afterExecuteOperationTransaction(args);
        String operationKey = args.getOperationKey();
        DynamicObject[] advertEntities = args.getDataEntities();
        DynamicObject[] dbDataEntities = this.getDBDataEntities(advertEntities);
        if ("stopadvert".equals(operationKey) || "stopadvertall".equals(operationKey) || "startadvert".equals(operationKey)) {
            AdvertTplExDataHelper.getInstance().calculatePosAdvNum(dbDataEntities);
        }
    }
}

