/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.op.advert;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.interaction.InteractionConfirmResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.form.MessageBoxResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tsc.tsirm.business.domain.advert.service.AdvertApprovalDataHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBizService;
import kd.tsc.tsirm.business.domain.advert.service.AdvertConfigHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertDetailExDataHelper;
import kd.tsc.tsirm.common.util.CommonUtils;
import kd.tsc.tsirm.opplugin.web.validator.advert.AdvertSubmitValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AdvertTplExOp
extends HRDataBaseOp {
    private AdvertBizService advertBizService = AdvertBizService.getInstance();
    private AdvertDetailExDataHelper detailExDataHelper = AdvertDetailExDataHelper.getInstance();
    private List<Long> notAuditList;
    private List<Long> needAuditList;
    private Boolean IS_AUDIT_CHANGED = Boolean.FALSE;

    public void onAddValidators(AddValidatorsEventArgs evt) {
        super.onAddValidators(evt);
        evt.addValidator((AbstractValidator)new AdvertSubmitValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs evt) {
        super.beforeExecuteOperationTransaction(evt);
        List validExtDataEntities = evt.getValidExtDataEntities();
        if (evt.getOperationKey().equals("submit")) {
            validExtDataEntities.forEach(dataEntity -> {
                DynamicObject advertBill = dataEntity.getDataEntity();
                boolean confirmResult = this.getConfirmResult();
                List<Long> channelIds = this.getNeedAuditChannels(advertBill, false);
                String auditStatus = advertBill.getString("billstatus");
                if (HRStringUtils.equals((String)auditStatus, (String)"G")) {
                    this.needAuditList = channelIds;
                    return;
                }
                List<Long> notChannelIds = this.getNeedAuditChannels(advertBill, true);
                if (!confirmResult) {
                    channelIds.addAll(notChannelIds);
                    this.updateSnapAuditChannel(advertBill, channelIds, null);
                    this.cancelOperation(evt);
                    return;
                }
                Pair isChange = AdvertConfigHelper.isAuditChannelChange(channelIds, notChannelIds);
                if (((Boolean)isChange.getLeft()).booleanValue()) {
                    this.IS_AUDIT_CHANGED = Boolean.TRUE;
                    List confForNotAudit = (List)isChange.getRight();
                    if (CollectionUtils.isEmpty((Collection)confForNotAudit)) {
                        channelIds.addAll(notChannelIds);
                    }
                    this.updateSnapAuditChannel(advertBill, channelIds, confForNotAudit);
                    if (confForNotAudit.containsAll(channelIds) && confForNotAudit.size() == 1) {
                        this.isShowSaveConfirm();
                    } else {
                        String channelNames = this.getChannelNames(advertBill, confForNotAudit);
                        this.isShowAuditConfirm(channelNames);
                    }
                } else {
                    if (null == this.notAuditList) {
                        this.notAuditList = (List)isChange.getRight();
                    } else {
                        this.notAuditList.addAll((Collection)isChange.getRight());
                    }
                    if (null == this.needAuditList) {
                        this.needAuditList = channelIds;
                    } else {
                        this.needAuditList.addAll(channelIds);
                    }
                }
            });
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs evt) {
        super.beginOperationTransaction(evt);
        DynamicObject[] dataEntities = evt.getDataEntities();
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            String operationKey = evt.getOperationKey();
            if ("submit".equals(operationKey)) {
                if (CollectionUtils.isNotEmpty(this.needAuditList) && CollectionUtils.isEmpty(this.notAuditList)) {
                    this.advertBizService.beforeSubmit2Flow(dataEntity, this.operationResult);
                } else if (CollectionUtils.isEmpty(this.needAuditList) && CollectionUtils.isNotEmpty(this.notAuditList)) {
                    this.advertBizService.reverseSnapToAdvert(dataEntity, this.operationResult);
                    dataEntity.set("isexistsworkflow", (Object)Boolean.FALSE);
                } else {
                    this.advertBizService.auditAndPubAdvert(dataEntity, this.notAuditList, this.operationResult);
                }
            } else if ("unsubmit".equals(operationKey)) {
                dataEntity.set("billstatus", (Object)"A");
                this.detailExDataHelper.updateApproveStatusByApprovalId(Long.valueOf(dataEntity.getLong("id")), "A");
            }
        });
    }

    private void isShowAuditConfirm(String channelNames) {
        if (this.IS_AUDIT_CHANGED.booleanValue()) {
            String content = HRStringUtils.isEmpty((String)channelNames) ? ResManager.loadKDString((String)"\u5e7f\u544a\u5ba1\u6279\u914d\u7f6e\u53d1\u751f\u53d8\u5316\u3002\u60a8\u6240\u4fee\u6539\u7684\u5185\u5bb9\uff0c\u5168\u90e8\u9700\u63d0\u4ea4\u5ba1\u6279\u3002\u786e\u8ba4\u63d0\u4ea4\u5ba1\u6279\uff0c\u8bf7\u70b9\u51fb\u201c\u786e\u5b9a\u201d\u3002", (String)"AdvertTplExOp_9", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e7f\u544a\u5ba1\u6279\u914d\u7f6e\u53d1\u751f\u53d8\u5316\u3002\u4ee5\u4e0b\u6e20\u9053\u7684\u5e7f\u544a\u53d8\u66f4\u4e3a\u4e0d\u9700\u8981\u5ba1\u6279\u3002\u70b9\u51fb\u201c\u786e\u5b9a\u201d\uff0c\u4e0d\u9700\u8981\u5ba1\u6279\u7684\u5e7f\u544a\uff0c\u76f4\u63a5\u66f4\u65b0/\u53d1\u5e03\uff0c\u5176\u4f59\u6e20\u9053\u63d0\u4ea4\u5ba1\u6279\u3002\u4e0d\u9700\u5ba1\u6279\u7684\u6e20\u9053\u5e7f\u544a{0}\u3002", (String)"AdvertTplExOp_10", (String)"tsc-tsirm-opplugin", (Object[])new Object[]{channelNames});
            this.advertBizService.popConfirmForOp("advbill_confirm", content, "btnok", this.getOption());
        }
    }

    private boolean getConfirmResult() {
        String confirmResultString = this.getOption().getVariableValue("interactionconfirmresult", "");
        InteractionConfirmResult confirmResult = InteractionConfirmResult.fromJsonString((String)confirmResultString);
        Map results = confirmResult.getResults();
        if (MapUtils.isEmpty((Map)results)) {
            return true;
        }
        MessageBoxResult result = MessageBoxResult.valueOf((String)((String)results.get("advbill_confirm")));
        return result == MessageBoxResult.Yes;
    }

    private void isShowSaveConfirm() {
        if (this.IS_AUDIT_CHANGED.booleanValue()) {
            String content = ResManager.loadKDString((String)"\u8be5\u5e7f\u544a\u7684\u5ba1\u6279\u914d\u7f6e\u53d1\u751f\u53d8\u5316\u3002\u60a8\u6240\u4fee\u6539\u7684\u5185\u5bb9\uff0c\u5df2\u4e0d\u9700\u63d0\u4ea4\u5ba1\u6279\u3002\u70b9\u51fb\u201c\u66f4\u65b0\u5e76\u53d1\u5e03\u201d\uff0c\u76f4\u63a5\u66f4\u65b0\u5e7f\u544a\u3002", (String)"AdvertTplExOp_11", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]);
            this.advertBizService.popConfirmForOp("advbill_confirm", content, "btnpub", this.getOption());
        }
    }

    private String getChannelNames(DynamicObject advertBill, List<Long> confForNotAudit) {
        DynamicObjectCollection advertSnapList = advertBill.getDynamicObjectCollection("entryentity");
        StringBuilder channelNames = new StringBuilder(365);
        advertSnapList.stream().forEach(snap -> {
            DynamicObject channel = snap.getDynamicObject("channel");
            if (confForNotAudit.contains(channel.getLong("id"))) {
                String cName = channel.getString("name");
                channelNames.append(cName).append("\u3001");
            }
        });
        if (channelNames.length() > 0) {
            channelNames.deleteCharAt(channelNames.length() - 1);
        }
        return channelNames.toString();
    }

    private List<Long> getNeedAuditChannels(DynamicObject advertBill, boolean isDirectPub) {
        DynamicObjectCollection advertSnapList = advertBill.getDynamicObjectCollection("entryentity");
        List<Long> channelIds = advertSnapList.stream().map(snap -> {
            if (snap.getBoolean("isaudit") ^ isDirectPub) {
                return snap.getDynamicObject("channel").getLong("id");
            }
            return null;
        }).filter(channelId -> null != channelId && channelId != 0L).collect(Collectors.toList());
        return channelIds;
    }

    private void cancelOperation(BeforeOperationArgs evt) {
        evt.setCancel(true);
        this.operationResult.setSuccess(true);
        this.operationResult.setShowMessage(false);
        this.operationResult.setSponsor("cancel");
        this.operationResult.setMessage(ResManager.loadKDString((String)"\u5df2\u53d6\u6d88\u4fee\u6539\u5e7f\u544a\u3002", (String)"AdvertTplExOp_12", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
    }

    private void updateSnapAuditChannel(DynamicObject advertBill, List<Long> channelIds, List<Long> confForNotAudit) {
        List copyList = CommonUtils.copyList(channelIds);
        if (CollectionUtils.isNotEmpty(confForNotAudit)) {
            copyList.removeAll(confForNotAudit);
        }
        AdvertApprovalDataHelper.getInstance().updateSnapIsAuditAndChannelNames(advertBill, copyList, confForNotAudit);
    }
}

