/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.op.advert;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.interaction.InteractionConfirmResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.form.MessageBoxResult;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBizService;
import kd.tsc.tsirm.business.domain.advert.service.AdvertConfigHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertDetailExDataHelper;
import kd.tsc.tsirm.common.constants.advert.AdvertConstants;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class EditPublishAdvOp
extends AbstractOperationServicePlugIn {
    private AdvertBizService advertBizService = AdvertBizService.getInstance();
    private Boolean DETAIL_NEED_AUDIT = Boolean.FALSE;

    public void onAddValidators(AddValidatorsEventArgs evt) {
        super.onAddValidators(evt);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs evt) {
        super.beforeExecuteOperationTransaction(evt);
        List validExtDataEntities = evt.getValidExtDataEntities();
        DynamicObject advert = ((ExtendedDataEntity)validExtDataEntities.get(0)).getDataEntity();
        if (AdvertConfigHelper.needAuditByChannel((DynamicObject)advert).booleanValue()) {
            this.DETAIL_NEED_AUDIT = Boolean.TRUE;
            boolean flag = this.isShowAuditConfirm();
            if (!flag) {
                this.cancelOperation(evt);
            }
        } else {
            boolean flag = this.isShowSaveConfirm();
            if (!flag) {
                this.cancelOperation(evt);
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs evt) {
        super.beginOperationTransaction(evt);
        DynamicObject[] dataEntities = evt.getDataEntities();
        DynamicObject dataEntity = dataEntities[0];
        dataEntity.set("modifyuser", (Object)TSCRequestContext.getUserId());
        if (this.DETAIL_NEED_AUDIT.booleanValue()) {
            this.advertBizService.editAdvertInfoByAudit(dataEntity, this.operationResult);
        } else {
            this.publishWithNoAudit(dataEntity);
        }
    }

    private boolean isShowAuditConfirm() {
        boolean isSaveChange;
        String confirmResultString = this.getOption().getVariableValue("interactionconfirmresult", "");
        InteractionConfirmResult confirmResult = InteractionConfirmResult.fromJsonString((String)confirmResultString);
        Map results = confirmResult.getResults();
        if (results.containsKey("advert_confirm_audit")) {
            MessageBoxResult result = MessageBoxResult.valueOf((String)((String)results.get("advert_confirm_audit")));
            return result == MessageBoxResult.Yes;
        }
        boolean bl = isSaveChange = results.containsKey("advert_confirm_save") && MessageBoxResult.valueOf((String)((String)results.get("advert_confirm_save"))) == MessageBoxResult.Yes;
        if (isSaveChange || this.DETAIL_NEED_AUDIT.booleanValue()) {
            this.advertBizService.popConfirmForOp("advert_confirm_audit", ResManager.loadKDString((String)"\u60a8\u6240\u4fee\u6539\u7684\u5185\u5bb9\uff0c\u9700\u63d0\u4ea4\u5ba1\u6279\u3002\u786e\u8ba4\u63d0\u4ea4\u5ba1\u6279\uff0c\u8bf7\u70b9\u51fb\u201c\u53d1\u8d77\u5ba1\u6279\u201d\u3002", (String)"EditPublishAdvOp_0", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]), "btnaudit", this.getOption());
        }
        return true;
    }

    private boolean isShowSaveConfirm() {
        String confirmResultString = this.getOption().getVariableValue("interactionconfirmresult", "");
        InteractionConfirmResult confirmResult = InteractionConfirmResult.fromJsonString((String)confirmResultString);
        Map results = confirmResult.getResults();
        if (results.containsKey("advert_confirm_save")) {
            MessageBoxResult result = MessageBoxResult.valueOf((String)((String)confirmResult.getResults().get("advert_confirm_save")));
            return result == MessageBoxResult.Yes;
        }
        if (results.containsKey("advert_confirm_audit") && MessageBoxResult.valueOf((String)((String)results.get("advert_confirm_audit"))) == MessageBoxResult.Yes) {
            String content = ResManager.loadKDString((String)"\u8be5\u5e7f\u544a\u7684\u5ba1\u6279\u914d\u7f6e\u53d1\u751f\u53d8\u5316\u3002\u60a8\u6240\u4fee\u6539\u7684\u5185\u5bb9\uff0c\u5df2\u4e0d\u9700\u63d0\u4ea4\u5ba1\u6279\u3002\u70b9\u51fb\u201c\u66f4\u65b0\u5e76\u53d1\u5e03\u201d\uff0c\u76f4\u63a5\u66f4\u65b0\u5e7f\u544a\u3002", (String)"EditPublishAdvOp_1", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]);
            this.advertBizService.popConfirmForOp("advert_confirm_save", content, "btnpub", this.getOption());
        }
        return true;
    }

    public void publishWithNoAudit(DynamicObject advertEntity) {
        boolean isDirectPub = this.advertBizService.pubOrWaitByStart(advertEntity);
        AdvertDetailExDataHelper.getInstance().saveAdvertDetail(Collections.singletonList(advertEntity));
        this.operationResult.setSuccess(true);
        this.operationResult.setShowMessage(false);
        String msg = ResManager.loadKDString((String)"\u5e7f\u544a\u4fdd\u5b58\u6210\u529f\uff0c\u5f85\u53d1\u5e03\u3002", (String)"EditPublishAdvOp_2", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]);
        if (isDirectPub) {
            msg = AdvertConstants.successPub();
        }
        this.operationResult.setMessage(msg);
    }

    private void cancelOperation(BeforeOperationArgs evt) {
        evt.setCancel(true);
        this.operationResult.setSuccess(true);
        this.operationResult.setShowMessage(false);
        this.operationResult.setSponsor("cancel");
        this.operationResult.setMessage(ResManager.loadKDString((String)"\u5df2\u53d6\u6d88\u4fee\u6539\u5e7f\u544a\uff0c\u4fee\u6539\u7684\u5185\u5bb9\u4e0d\u4f1a\u4fdd\u5b58\u3002", (String)"EditPublishAdvOp_3", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs evt) {
        super.afterExecuteOperationTransaction(evt);
        DynamicObject[] dataEntities = evt.getDataEntities();
        if (!this.DETAIL_NEED_AUDIT.booleanValue()) {
            this.advertBizService.updateOnePosAdvCount(Arrays.asList((Object[])dataEntities.clone()));
        }
    }
}

