/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.op.appfile;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileOpHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tsirm.business.domain.appfile.ChangeStageStatusHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileOpRecordService;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileStdRsmHelper;
import kd.tsc.tsirm.opplugin.web.validator.appfile.ChangeStageStatusValidator;
import kd.tsc.tsrbs.common.enums.OpDefEnum;

public class ChangeStageStatusOp
extends HRDataBaseOp {
    private long stageId;
    private long statusId;
    private long reasonId;

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        args.getFieldKeys().add("enterlinktime");
        args.getFieldKeys().add("isbinddelyrec");
        args.getFieldKeys().add("position");
        args.getFieldKeys().add("recruproc");
        args.getFieldKeys().add("modifier");
        args.getFieldKeys().add("modifytime");
        args.getFieldKeys().add("name");
        args.getFieldKeys().add("recrustg");
        args.getFieldKeys().add("recrustat");
        args.getFieldKeys().add("appres");
        args.getFieldKeys().add("filestatus");
        args.getFieldKeys().add("offerstatus");
        args.getFieldKeys().add("createorg");
        args.getFieldKeys().add("phone");
        args.getFieldKeys().add("email");
        args.getFieldKeys().add("stdrsm.id");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        String stageStr = this.getOption().getVariableValue("recruitmentstage", "0");
        this.stageId = HRStringUtils.isEmpty((String)stageStr) ? 0L : Long.parseLong(stageStr);
        String statusStr = this.getOption().getVariableValue("recruitmentstatus", "0");
        this.statusId = HRStringUtils.isEmpty((String)statusStr) ? 0L : Long.parseLong(statusStr);
        String reasonStr = this.getOption().getVariableValue("reason", "0");
        this.reasonId = HRStringUtils.isEmpty((String)reasonStr) ? 0L : Long.parseLong(reasonStr);
        args.addValidator((AbstractValidator)new ChangeStageStatusValidator(this.stageId));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        ChangeStageStatusHelper.saveStageTraceUpdateAppFile((long)this.stageId, (long)this.statusId, (long)this.reasonId, (DynamicObject[])args.getDataEntities());
        AppFileHelper.bindAppFileResume((DynamicObject[])args.getDataEntities());
        this.getOperationResult().setMessage(this.packReturnData(args.getDataEntities(), this.stageId, this.statusId));
        List stdRsmIdList = Arrays.stream(args.getDataEntities()).map(dyo -> dyo.getLong("stdrsm.id")).collect(Collectors.toList());
        AppFileStdRsmHelper.updateStdRsmLastStgAndStat((long)this.stageId, (long)this.statusId, stdRsmIdList);
    }

    private String packReturnData(DynamicObject[] appFiles, long stageId, long statusId) {
        DynamicObject stage = ChangeStageStatusHelper.getStageById((String)"name", (long)stageId);
        DynamicObject status = ChangeStageStatusHelper.getStatusById((String)"name", (long)statusId);
        String stageName = stage.getString("name");
        String statusName = status.getString("name");
        String name = AppFileOpHelper.getErrorMulTipHead(Arrays.asList(appFiles));
        String tip = String.format(ResManager.loadKDString((String)"\u6210\u529f\u8f6c\u79fb\u5230\u201c%s\u201d\u73af\u8282-\u201c%s\u201d\u72b6\u6001\u3002", (String)"ChangeStageStatusOp_0", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]), stageName, statusName);
        return name + tip;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        List appFileIdList = Arrays.stream(args.getDataEntities()).map(dyo -> dyo.getLong("id")).collect(Collectors.toList());
        AppFileOpRecordService.getInstance().sendOpRecord(AppFileResManagerHelper.getRecRoleName(), OpDefEnum.TSIRM_CHANG_LINK_STATUS, appFileIdList, null);
    }
}

