/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.op.appfile;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tsc.tsirm.business.domain.appfile.AppFileFlowLockHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileOpHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileStatusHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileOpRecordService;
import kd.tsc.tsirm.common.constants.appfile.AppFileConstants;
import kd.tsc.tsirm.opplugin.web.validator.appfile.RecoverAppFileValidator;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.enums.OpDefEnum;

public class RecoverAppFileOp
extends HRDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        evt.getFieldKeys().add("stdrsm.mid");
        evt.getFieldKeys().add("filestatus");
        evt.getFieldKeys().add("position.id");
        evt.getFieldKeys().add("eliminatetime");
        evt.getFieldKeys().add("modifytime");
        evt.getFieldKeys().add("modifier");
    }

    public void onAddValidators(AddValidatorsEventArgs evt) {
        evt.addValidator((AbstractValidator)new RecoverAppFileValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs evt) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = evt.getDataEntities()) {
            dataEntity.set("filestatus", (Object)AppFileConstants.APP_FILE_STATUS_IN);
            dataEntity.set("eliminatetime", null);
            dataEntity.set("modifytime", (Object)new Date());
            dataEntity.set("modifier", (Object)TSCRequestContext.getUserId());
        }
        if (evt.getDataEntities().length > 0) {
            this.operationResult.setMessage(this.getRecoverSuccessMsg(evt.getDataEntities()));
        }
        AppFileHelper.update((DynamicObject[])dataEntities);
    }

    public void endOperationTransaction(EndOperationTransactionArgs evt) {
        List appFileIds = Arrays.stream(evt.getDataEntities()).map(dyo -> dyo.getLong("id")).collect(Collectors.toList());
        AppFileStatusHelper.addStatusRecordByRecoverOp(appFileIds);
        AppFileFlowLockHelper.recoverAppFile((DynamicObject[])evt.getDataEntities());
    }

    private String getRecoverSuccessMsg(DynamicObject[] appFiles) {
        String name = AppFileOpHelper.getErrorMulTipHead(Arrays.asList(appFiles));
        String tpTip = ResManager.loadKDString((String)"\u6062\u590d\u6210\u529f\u3002", (String)"RecoverAppFileOp_0", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]);
        return name + tpTip;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs evt) {
        List appFileIdList = Arrays.stream(evt.getDataEntities()).map(dyo -> dyo.getLong("id")).collect(Collectors.toList());
        AppFileOpRecordService.getInstance().sendOpRecord(AppFileResManagerHelper.getRecRoleName(), OpDefEnum.TSIRM_RECOVERY, appFileIdList, null);
    }
}

