/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.op.hire.approval;

import java.time.LocalDateTime;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.tsc.tsirm.business.domain.hire.approval.HireApprovalAppFileService;
import kd.tsc.tsirm.opplugin.web.validator.hire.HireApprovalAFStasValidator;
import kd.tsc.tsirm.opplugin.web.validator.hire.HireApprovalBlackListValidator;
import kd.tsc.tsirm.opplugin.web.validator.hire.HireApprovalDuplicateValidator;
import kd.tsc.tsirm.opplugin.web.validator.hire.HireApprovalLicenseValidator;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class HireApprovalSubmitOp
extends HRCoreBaseBillOp {
    public void onAddValidators(AddValidatorsEventArgs addValidatorsEventArgs) {
        addValidatorsEventArgs.addValidator((AbstractValidator)new HireApprovalDuplicateValidator());
        addValidatorsEventArgs.addValidator((AbstractValidator)new HireApprovalBlackListValidator());
        addValidatorsEventArgs.addValidator((AbstractValidator)new HireApprovalAFStasValidator());
        addValidatorsEventArgs.addValidator((AbstractValidator)new HireApprovalLicenseValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        evt.getFieldKeys().add("submitor");
        evt.getFieldKeys().add("submittime");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        DynamicObject[] approvalDys;
        DynamicObject[] dataEntities = args.getDataEntities();
        Object[] approvalIds = new Long[dataEntities.length];
        Long userId = TSCRequestContext.getUserId();
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject row = dataEntities[i];
            approvalIds[i] = (Long)row.getPkValue();
            row.set("submitor", (Object)userId);
            row.set("submittime", (Object)now);
        }
        for (DynamicObject hireApprovalDyn : approvalDys = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_hireapprovalsg").loadDynamicObjectArray(approvalIds)) {
            hireApprovalDyn.set("submitor", (Object)userId);
            hireApprovalDyn.set("submittime", (Object)now);
        }
        ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_hireapprovalsg").update(approvalDys);
    }

    public void endOperationTransaction(EndOperationTransactionArgs endOperationTransactionArgs) {
        Long[] approvalIds = new Long[endOperationTransactionArgs.getDataEntities().length];
        for (int i = 0; i < endOperationTransactionArgs.getDataEntities().length; ++i) {
            approvalIds[i] = (Long)endOperationTransactionArgs.getDataEntities()[i].getPkValue();
        }
        HireApprovalAppFileService.updateAppFileAndLockByApprovalId((Long[])approvalIds);
    }
}

