/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.op.hire.approval;

import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.tsc.tsirm.business.domain.hire.approval.HireApprovalAppFileService;
import kd.tsc.tsirm.business.domain.hire.approval.HireApprovalDomainService;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.enums.OpDefEnum;

public class HireApprovalWorkFlowOp
extends HRCoreBaseBillOp {
    private String opKey;
    private Long[] approvalIds;
    private static final Map<String, String> OPKEY_STATUS_MAPPING = Maps.newHashMap();

    public void beforeExecuteOperationTransaction(BeforeOperationArgs beforeOperationArgs) {
        this.opKey = beforeOperationArgs.getOperationKey();
        DynamicObject[] dataEntities = beforeOperationArgs.getDataEntities();
        this.approvalIds = new Long[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            this.approvalIds[i] = (Long)dataEntities[i].getPkValue();
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        DynamicObject[] hireApprovalDyns;
        String status = OPKEY_STATUS_MAPPING.get(this.opKey);
        Long userId = TSCRequestContext.getUserId();
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        HRBaseServiceHelper dbServiceApproval = new HRBaseServiceHelper("tsirm_hireapprovalsg");
        for (DynamicObject hireApprovalDyn : hireApprovalDyns = dbServiceApproval.loadDynamicObjectArray((Object[])this.approvalIds)) {
            if ("C".equals(status) || "E".equals(status)) {
                hireApprovalDyn.set("auditor", (Object)userId);
                hireApprovalDyn.set("auditdate", (Object)now);
            }
            hireApprovalDyn.set("billstatus", (Object)status);
            hireApprovalDyn.set("modifier", (Object)userId);
            hireApprovalDyn.set("modifytime", (Object)now);
        }
        dbServiceApproval.update(hireApprovalDyns);
    }

    public void endOperationTransaction(EndOperationTransactionArgs endOperationTransactionArgs) {
        DynamicObject[] approvalDys = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_hireapprovalsg").loadDynamicObjectArray((Object[])this.approvalIds);
        this.approvalOpRecord(approvalDys);
        HireApprovalAppFileService.updateAppFileAndLockByApprovalId((Long[])this.approvalIds);
        HireApprovalDomainService.batchSyncTransferStatus((DynamicObject[])endOperationTransactionArgs.getDataEntities());
    }

    private void approvalOpRecord(DynamicObject[] hireApprovalDyns) {
        boolean haveJumpPage;
        OpDefEnum opDefEnum;
        if (HRStringUtils.equals((String)this.opKey, (String)"unsubmit")) {
            opDefEnum = OpDefEnum.TSIRM_REVOKE_EMPLOY_APPFORM;
            haveJumpPage = true;
        } else if (HRStringUtils.equals((String)this.opKey, (String)"audit")) {
            opDefEnum = OpDefEnum.TSIRM_AGREE_EMP_EXAMINE;
            haveJumpPage = false;
        } else if (HRStringUtils.equals((String)this.opKey, (String)"failaudit")) {
            opDefEnum = OpDefEnum.TSIRM_DISAGREE_EMP_EXAMINE;
            haveJumpPage = false;
        } else {
            return;
        }
        HireApprovalAppFileService.approvalOpRecord((DynamicObject[])hireApprovalDyns, (OpDefEnum)opDefEnum, (boolean)haveJumpPage);
    }

    static {
        OPKEY_STATUS_MAPPING.put("audit", "C");
        OPKEY_STATUS_MAPPING.put("inaudit", "D");
        OPKEY_STATUS_MAPPING.put("failaudit", "E");
        OPKEY_STATUS_MAPPING.put("unsubmit", "A");
        OPKEY_STATUS_MAPPING.put("resubmit", "G");
    }
}

