/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.op.intv;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tsc.tsirm.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tsirm.common.enums.TSIRMPreDataEnum;
import kd.tsc.tsirm.common.enums.intv.ArgIntvReceiverTypeEnum;
import kd.tsc.tsirm.opplugin.web.validator.intv.ArgIntvValidator;
import kd.tsc.tsrbd.common.enums.CfgMsgRecvType;

public class ArgIntvOp
extends HRDataBaseOp {
    private static final Log logger = LogFactory.getLog(ArgIntvOp.class);
    private static final HRBaseServiceHelper argIntvHelper = new HRBaseServiceHelper("tsirm_argintvmtpl");

    public void beginOperationTransaction(BeginOperationTransactionArgs evt) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        result.put(CfgMsgRecvType.INTERVIEWER.getBaseDataId(), Lists.newArrayListWithExpectedSize((int)10));
        result.put(CfgMsgRecvType.CANDIDATE.getBaseDataId(), Lists.newArrayListWithExpectedSize((int)10));
        result.put(CfgMsgRecvType.RECEIVER.getBaseDataId(), Lists.newArrayListWithExpectedSize((int)10));
        DynamicObject[] dataEntities = evt.getDataEntities();
        if (Objects.isNull(dataEntities) || dataEntities.length == 0) {
            logger.error("intvdata is empty");
        } else {
            DynamicObject dataEntity = dataEntities[0];
            logger.info("intv begin id {}", (Object)dataEntity.getLong("id"));
            dataEntity.set("arrangeantime", (Object)new Date());
            boolean isAddNew = ArgIntvHelper.getInstance().isExists(Long.valueOf(dataEntity.getLong("id")));
            DistributeSessionlessCache appCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
            appCache.put("tsirm_isAddNew_Intv" + dataEntity.getLong("id"), (Object)String.valueOf(isAddNew));
            if (!HRObjectUtils.isEmpty((Object)dataEntity)) {
                ArgIntvHelper argIntvHelper = new ArgIntvHelper();
                String intvorgfrm = dataEntity.getString("intvorgfrm");
                if ("C".equals(intvorgfrm)) {
                    DynamicObject[] batchDataEntities;
                    List argIntvDataEntitys = argIntvHelper.getDynamicObjects(dataEntity, argIntvHelper);
                    evt.setDataEntities(argIntvDataEntitys.toArray(new DynamicObject[0]));
                    for (DynamicObject batchDataEntity : batchDataEntities = evt.getDataEntities()) {
                        logger.info("intv ing id {}", (Object)batchDataEntity.getLong("id"));
                        argIntvHelper.generateFlowOfIntv(batchDataEntity, isAddNew, (Map)result);
                    }
                } else if ("D".equals(intvorgfrm)) {
                    dataEntity.set("intvorgfrm", (Object)"C");
                    DynamicObject round = (DynamicObject)dataEntity.getDynamicObjectCollection("tsirm_intvroundentry").get(0);
                    Long interviewMethodId = round.getDynamicObject("interviewmethod").getLong("id");
                    DynamicObjectCollection dynamicObjectCollection = round.getDynamicObjectCollection("tsirm_intvgroupentry");
                    for (DynamicObject dynamicObject : dynamicObjectCollection) {
                        if (!TSIRMPreDataEnum.KEY_1010.getId().equals(interviewMethodId)) {
                            dynamicObject.set("admindivision", null);
                            dynamicObject.set("interviewlocation", null);
                            dynamicObject.set("interviewroom", null);
                        }
                        if (TSIRMPreDataEnum.KEY_1040.getId().equals(interviewMethodId)) continue;
                        dynamicObject.set("intvervedioaddress", null);
                        dynamicObject.set("candatevedioaddress", null);
                    }
                    argIntvHelper.generateFlowOfIntv(dataEntity, isAddNew, (Map)result);
                } else {
                    argIntvHelper.generateFlowOfIntv(dataEntity, isAddNew, (Map)result);
                }
            }
            if (isAddNew) {
                this.saveSendTemplate(dataEntity);
            }
        }
        this.getOption().setVariableValue("cfgMsgVariableValue", JSON.toJSONString((Object)result));
    }

    public void endOperationTransaction(EndOperationTransactionArgs evt) {
        if ("save".equals(evt.getOperationKey())) {
            DynamicObject[] dataEntities;
            for (DynamicObject dataEntity : dataEntities = evt.getDataEntities()) {
                DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("tsirm_intvroundentry");
                for (DynamicObject object : dynamicObjectCollection) {
                    DataEntityCacheManager dataEntityCacheManager1 = new DataEntityCacheManager(object.getDataEntityType());
                    dataEntityCacheManager1.removeByPrimaryKey(new Object[]{object.getLong("id")});
                    DynamicObjectCollection objectCollection = object.getDynamicObjectCollection("tsirm_intvgroupentry");
                    this.doNotWorryBeHappy(objectCollection);
                }
            }
        }
    }

    public void doNotWorryBeHappy(DynamicObjectCollection objectCollection) {
        for (DynamicObject dynamicObject : objectCollection) {
            DataEntityCacheManager dataEntityCacheManager2 = new DataEntityCacheManager(dynamicObject.getDataEntityType());
            dataEntityCacheManager2.removeByPrimaryKey(new Object[]{dynamicObject.getLong("id")});
        }
    }

    public void onAddValidators(AddValidatorsEventArgs evt) {
        evt.addValidator((AbstractValidator)new ArgIntvValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs evt) {
        Object[] dataEntities = evt.getDataEntities();
        if (HRArrayUtils.isEmpty((Object[])dataEntities)) {
            logger.error("data exception because of  argintv object is null ");
            return;
        }
        ArgIntvHelper argIntvHelper = new ArgIntvHelper();
        for (Object dataEntity : dataEntities) {
            ArgIntvHelper.INTV_THREAD_POOL.execute(() -> ArgIntvOp.lambda$afterExecuteOperationTransaction$0(argIntvHelper, (DynamicObject)dataEntity));
        }
    }

    private void saveSendTemplate(DynamicObject dynamicObject) {
        DynamicObject argIntvTpl;
        ArrayList<DynamicObject> templateResultList = new ArrayList<DynamicObject>();
        long id = dynamicObject.getLong("id");
        boolean candidateNotice = dynamicObject.getBoolean("noticecopiedperson");
        boolean email2Candidate = dynamicObject.getBoolean("candchkmailsend");
        boolean sms2Candidate = dynamicObject.getBoolean("candchksmssend");
        boolean interviewerNotice = dynamicObject.getBoolean("noticeinterviewer");
        boolean email2Interviewer = dynamicObject.getBoolean("intvchkmailsend");
        boolean sms2Interviewer = dynamicObject.getBoolean("intvchksmssend");
        boolean recepNotice = dynamicObject.getBoolean("noticereceptionist");
        boolean email2Recep = dynamicObject.getBoolean("recechkmailsend");
        boolean sms2Recep = dynamicObject.getBoolean("recechksmssend");
        if (candidateNotice) {
            argIntvTpl = this.createDynamicObject(id, ArgIntvReceiverTypeEnum.CANDIDATE);
            if (sms2Candidate) {
                argIntvTpl.set("channel", (Object)Long.parseLong("475773159430184960"));
                argIntvTpl.set("content_tag", (Object)dynamicObject.getString("sms_cand_richtext"));
                templateResultList.add(argIntvTpl);
            }
            if (email2Candidate) {
                argIntvTpl = this.createDynamicObject(id, ArgIntvReceiverTypeEnum.CANDIDATE);
                argIntvTpl.set("channel", (Object)Long.parseLong("475773782250774528"));
                argIntvTpl.set("content_tag", (Object)dynamicObject.getString("txtmailcandidate_tag"));
                argIntvTpl.set("emailtheme", (Object)dynamicObject.getString("copitheme"));
                templateResultList.add(argIntvTpl);
            }
        }
        if (interviewerNotice) {
            argIntvTpl = this.createDynamicObject(id, ArgIntvReceiverTypeEnum.INTERVIEWER);
            if (sms2Interviewer) {
                argIntvTpl.set("channel", (Object)Long.parseLong("475773159430184960"));
                argIntvTpl.set("content_tag", (Object)dynamicObject.getString("sms_intv_richtext"));
                templateResultList.add(argIntvTpl);
            }
            if (email2Interviewer) {
                argIntvTpl = this.createDynamicObject(id, ArgIntvReceiverTypeEnum.INTERVIEWER);
                argIntvTpl.set("channel", (Object)Long.parseLong("475773782250774528"));
                argIntvTpl.set("content_tag", (Object)dynamicObject.getString("txtmailinterviewer_tag"));
                argIntvTpl.set("emailtheme", (Object)dynamicObject.getString("intetheme"));
                templateResultList.add(argIntvTpl);
            }
        }
        if (recepNotice) {
            argIntvTpl = this.createDynamicObject(id, ArgIntvReceiverTypeEnum.RECEP);
            if (sms2Recep) {
                argIntvTpl.set("channel", (Object)Long.parseLong("475773159430184960"));
                argIntvTpl.set("content_tag", (Object)dynamicObject.getString("sms_rece_richtext"));
                templateResultList.add(argIntvTpl);
            }
            if (email2Recep) {
                argIntvTpl = this.createDynamicObject(id, ArgIntvReceiverTypeEnum.RECEP);
                argIntvTpl.set("channel", (Object)Long.parseLong("475773782250774528"));
                argIntvTpl.set("content_tag", (Object)dynamicObject.getString("txtmailunawares_tag"));
                argIntvTpl.set("emailtheme", (Object)dynamicObject.getString("recptheme"));
                templateResultList.add(argIntvTpl);
            }
        }
        this.setCommon(templateResultList);
        argIntvHelper.save(templateResultList.toArray(new DynamicObject[0]));
    }

    private DynamicObject createDynamicObject(long id, ArgIntvReceiverTypeEnum argIntvReceiverTypeEnum) {
        DynamicObject argIntvTpl = argIntvHelper.generateEmptyDynamicObject();
        argIntvTpl.set("argintv", (Object)id);
        argIntvTpl.set("receiverType", (Object)argIntvReceiverTypeEnum.getNumber());
        return argIntvTpl;
    }

    private void setCommon(List<DynamicObject> templateResultList) {
        Date now = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        templateResultList.forEach(dynamicObject -> {
            dynamicObject.set("creator", (Object)currUserId);
            dynamicObject.set("createtime", (Object)now);
            dynamicObject.set("modifier", (Object)currUserId);
            dynamicObject.set("modifytime", (Object)now);
        });
    }

    private static /* synthetic */ void lambda$afterExecuteOperationTransaction$0(ArgIntvHelper argIntvHelper, DynamicObject dataEntity) {
        argIntvHelper.arrangeInterviewExecuteTasks(dataEntity);
    }
}

