/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.op.operationmanage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidatePriority;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tsc.tsirm.business.domain.appfile.AppFileStatusHelper;
import kd.tsc.tsirm.business.domain.operationmanage.CreateOperationManageService;
import kd.tsc.tsirm.business.domain.operationmanage.helper.OperationManageRecordServiceHelper;
import kd.tsc.tsirm.business.domain.operationmanage.helper.OperationManageServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.resume.IResumeService;
import kd.tsc.tsirm.business.license.TSIRMCertCommonHelper;
import kd.tsc.tsirm.common.enums.operationmanage.ActivationStatus;
import kd.tsc.tsirm.common.enums.operationmanage.OperatevalEnum;
import kd.tsc.tsirm.opplugin.web.validator.operationmanage.CancelLicenseValidators;
import kd.tsc.tsrbd.common.utils.DateUtils;

public class CancelLicenseOp
extends HRDataBaseOp {
    private static final Log LOG = LogFactory.getLog(CancelLicenseOp.class);
    CreateOperationManageService createOperationManageService = CreateOperationManageService.Singleton.INSTANCE.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs eventArgs) {
        super.onPreparePropertys(eventArgs);
        eventArgs.getFieldKeys().add("activationstatus");
        eventArgs.getFieldKeys().add("employee");
        eventArgs.getFieldKeys().add("failreason");
        eventArgs.getFieldKeys().add("checkfail");
        eventArgs.getFieldKeys().add("activationtime");
        eventArgs.getFieldKeys().add("user");
    }

    public void onAddValidators(AddValidatorsEventArgs eventArgs) {
        super.onAddValidators(eventArgs);
        CancelLicenseValidators cancelLicenseValidators = new CancelLicenseValidators();
        cancelLicenseValidators.setSeq(ValidatePriority.Last.getValue());
        eventArgs.addValidator((AbstractValidator)cancelLicenseValidators);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        List<DynamicObject> validatorSuccessList = Arrays.stream(args.getDataEntities()).filter(dynamicObject -> !dynamicObject.getBoolean("checkfail")).collect(Collectors.toList());
        ArrayList<Long> employeeIdList = new ArrayList<Long>(validatorSuccessList.size());
        HashMap<Long, Long> userHrMap = new HashMap<Long, Long>(validatorSuccessList.size());
        ArrayList<DynamicObject> operationManagerdObjList = new ArrayList<DynamicObject>(args.getDataEntities().length);
        for (DynamicObject dynamicObject2 : validatorSuccessList) {
            DynamicObject operationManagerdObj = this.createOperationManageService.buildOperationmanagerd(dynamicObject2, ActivationStatus.D, OperatevalEnum.C);
            operationManagerdObjList.add(operationManagerdObj);
            dynamicObject2.set("activationstatus", (Object)ActivationStatus.D);
            dynamicObject2.set("user", (Object)RequestContext.get().getCurrUserId());
            dynamicObject2.set("activationtime", (Object)DateUtils.nowDateTime());
            employeeIdList.add(dynamicObject2.getLong("employee.id"));
            long userHrId = dynamicObject2.getDynamicObject("employee").getDynamicObject("person").getLong("id");
            userHrMap.put(dynamicObject2.getLong("id"), userHrId);
        }
        List stdRsmIdList = StandardResumeDataHelper.batchQueryStdRsmByEmpId(employeeIdList);
        LOG.info("CancelLicenseOp.beginOperationTransaction stdRsmIdList {} employeeIdList {}", (Object)stdRsmIdList, employeeIdList);
        Map<String, String> paramMap = Collections.singletonMap("status", "C");
        new IResumeService().updateStdRsmWithNoHistory(stdRsmIdList, paramMap);
        AppFileStatusHelper.expireAppFilesByStdRsmId((List)stdRsmIdList);
        OperationManageServiceHelper.Singleton.INSTANCE.getInstance().save(validatorSuccessList.toArray(new DynamicObject[0]));
        OperationManageRecordServiceHelper.Singleton.INSTANCE.getInstance().save(operationManagerdObjList.toArray(new DynamicObject[0]));
        this.cancelLicense(userHrMap);
    }

    private void cancelLicense(Map<Long, Long> userHrMap) {
        QFilter qFilter = new QFilter("id", "in", userHrMap.values());
        DynamicObject[] hrPiPersons = BusinessDataServiceHelper.load((String)"hrpi_person", (String)"id,personindexid", (QFilter[])new QFilter[]{qFilter});
        Map<Long, Long> personIndexIdMap = Arrays.stream(hrPiPersons).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getLong("personindexid")));
        ArrayList<Long> pids = new ArrayList<Long>(personIndexIdMap.values());
        LOG.info("CancelLicenseOp.beginOperationTransaction pids {} qFilter {}", pids, (Object)qFilter);
        TSIRMCertCommonHelper.releaseCertByPid((String)"2+TXFE9NU13A", (String)"tsirm_stdrsm", pids);
    }
}

