/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.op.operationmanage;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.plugin.args.ValidatePrefixArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidatePriority;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.sdk.tsc.common.vo.BizResult;
import kd.tsc.tsirm.business.domain.operationmanage.CreateOperationManageService;
import kd.tsc.tsirm.business.domain.operationmanage.helper.OperationManageRecordServiceHelper;
import kd.tsc.tsirm.business.domain.operationmanage.helper.OperationManageServiceHelper;
import kd.tsc.tsirm.business.domain.pc.factory.PCServiceFactory;
import kd.tsc.tsirm.business.domain.pc.service.AbstractEmpCVService;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tsirm.business.domain.stdrsm.service.StdRsmCommonService;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.resume.IResumeService;
import kd.tsc.tsirm.business.license.TSIRMCertCommonHelper;
import kd.tsc.tsirm.common.enums.operationmanage.ActivationStatus;
import kd.tsc.tsirm.common.enums.operationmanage.OperatevalEnum;
import kd.tsc.tsirm.opplugin.web.validator.operationmanage.OpeningLicenseValidators;
import kd.tsc.tsrbd.common.utils.DateUtils;

public class OpeningLicenseOp
extends HRDataBaseOp {
    private static final Log LOG = LogFactory.getLog(OpeningLicenseOp.class);
    CreateOperationManageService createOperationManageService = CreateOperationManageService.Singleton.INSTANCE.getInstance();
    StdRsmCommonService stdRsmCommonService = StdRsmCommonService.getInstance();
    private static final AbstractEmpCVService empCVService = PCServiceFactory.getEmpCVService();

    public void onPreparePropertys(PreparePropertysEventArgs eventArgs) {
        super.onPreparePropertys(eventArgs);
        eventArgs.getFieldKeys().add("activationstatus");
        eventArgs.getFieldKeys().add("employee");
        eventArgs.getFieldKeys().add("failreason");
        eventArgs.getFieldKeys().add("activationtime");
        eventArgs.getFieldKeys().add("user");
        eventArgs.getFieldKeys().add("failreasoncombo");
        eventArgs.getFieldKeys().add("dataindex");
        eventArgs.getFieldKeys().add("rowindex");
        eventArgs.getFieldKeys().add("subrowindex");
        eventArgs.getFieldKeys().add("checkfail");
    }

    public void validatePrefix(ValidatePrefixArgs validatePrefixArgs) {
        super.validatePrefix(validatePrefixArgs);
    }

    public void onAddValidators(AddValidatorsEventArgs eventArgs) {
        super.onAddValidators(eventArgs);
        this.getOperationResult();
        OpeningLicenseValidators openingLicenseValidators = new OpeningLicenseValidators();
        openingLicenseValidators.setSeq(ValidatePriority.Last.getValue());
        eventArgs.addValidator((AbstractValidator)openingLicenseValidators);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        List<DynamicObject> validatorSuccessList = Arrays.stream(args.getDataEntities()).filter(dynamicObject -> !dynamicObject.getBoolean("checkfail")).collect(Collectors.toList());
        List<DynamicObject> validatorFailList = Arrays.stream(args.getDataEntities()).filter(dynamicObject -> dynamicObject.getBoolean("checkfail")).collect(Collectors.toList());
        ArrayList<DynamicObject> operationManagerdObjList = new ArrayList<DynamicObject>(args.getDataEntities().length);
        this.opendLicense(validatorSuccessList, operationManagerdObjList, validatorFailList);
        this.checkValidatorFail(validatorFailList, operationManagerdObjList);
        if (!validatorFailList.isEmpty()) {
            OperationManageServiceHelper.Singleton.INSTANCE.getInstance().save(validatorFailList.toArray(new DynamicObject[0]));
        }
        if (!validatorSuccessList.isEmpty()) {
            OperationManageServiceHelper.Singleton.INSTANCE.getInstance().save(validatorSuccessList.toArray(new DynamicObject[0]));
        }
        if (!operationManagerdObjList.isEmpty()) {
            OperationManageRecordServiceHelper.Singleton.INSTANCE.getInstance().save(operationManagerdObjList.toArray(new DynamicObject[0]));
        }
        if (!validatorFailList.isEmpty()) {
            this.addValidatorError(validatorFailList);
        }
    }

    private void addValidatorError(List<DynamicObject> validatorFailList) {
        String opKeyName = LocaleString.fromMap((Map)((Map)this.operateMeta.get("name"))).getLocaleValue();
        String entityKey = this.billEntityType.getName();
        String tipMsg = ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef\u3002", (String)"OpeningLicenseOp_0", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]);
        this.getOperationResult().setMessage(tipMsg);
        for (DynamicObject dynamicObject : validatorFailList) {
            ValidateResult validateResult = new ValidateResult();
            validateResult.setValidatorKey(opKeyName);
            validateResult.setSuccess(true);
            validateResult.setNeedSign(false);
            validateResult.setNeedWfAssignPersons(false);
            validateResult.setCancelWriteLog(false);
            validateResult.setMessageType(0);
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setErrorCode("errorcode_001");
            operateErrorInfo.setLevel(ErrorLevel.FatalError);
            operateErrorInfo.setPkValue((Object)dynamicObject.getLong("id"));
            operateErrorInfo.setEntityKey(entityKey);
            operateErrorInfo.setFieldKey(null);
            operateErrorInfo.setRowIndex(dynamicObject.getInt("rowindex"));
            operateErrorInfo.setSubRowIndex(dynamicObject.getInt("subrowindex"));
            operateErrorInfo.setDataEntityIndex(dynamicObject.getInt("dataindex"));
            operateErrorInfo.setTitle(opKeyName);
            DynamicObject employeeObj = dynamicObject.getDynamicObject("employee");
            String messagePrefix = employeeObj.getDynamicObject("person").getString("name") + " " + employeeObj.getString("empnumber") + ": ";
            operateErrorInfo.setMessage(messagePrefix + dynamicObject.getString("failreason"));
            validateResult.addErrorInfo(operateErrorInfo);
            this.getOperationResult().getValidateResult().getValidateErrors().add(validateResult);
        }
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        super.onReturnOperation(e);
        this.getOperationResult().getAllErrorOrValidateInfo().forEach(iOperateInfo -> this.getOperationResult().getSuccessPkIds().remove(iOperateInfo.getPkValue()));
    }

    private void checkValidatorFail(List<DynamicObject> validatorFailList, List<DynamicObject> operationManagerdObjList) {
        for (DynamicObject dynamicObject : validatorFailList) {
            DynamicObject operationManagerdObj = this.createOperationManageService.buildOperationmanagerd(dynamicObject, ActivationStatus.C, OperatevalEnum.B);
            operationManagerdObj.set("failreason", (Object)dynamicObject.getString("failreason"));
            operationManagerdObjList.add(operationManagerdObj);
            dynamicObject.set("activationstatus", (Object)ActivationStatus.C);
            dynamicObject.set("activationtime", (Object)DateUtils.nowDateTime());
            dynamicObject.set("user", (Object)RequestContext.get().getCurrUserId());
        }
    }

    private void opendLicense(List<DynamicObject> validatorSuccessList, List<DynamicObject> operationManagerdObjList, List<DynamicObject> validatorFailList) {
        if (validatorSuccessList.isEmpty()) {
            return;
        }
        HashMap<Long, Long> userHrMap = new HashMap<Long, Long>();
        ArrayList<Long> personIdList = new ArrayList<Long>(validatorSuccessList.size());
        this.filterStatus(validatorSuccessList, userHrMap, personIdList);
        this.invokeBindAccount(personIdList, validatorSuccessList, validatorFailList);
        Map<String, Object> invokeResultMap = this.invokeUpdateUsedCertCount(userHrMap);
        this.buildOpenDate(validatorSuccessList, operationManagerdObjList, invokeResultMap, userHrMap);
    }

    private void buildOpenDate(List<DynamicObject> validatorSuccessList, List<DynamicObject> operationManagerdObjList, Map<String, Object> invokeResultMap, Map<Long, Long> userHrMap) {
        if (userHrMap.isEmpty()) {
            return;
        }
        if ("TRUE".equals(invokeResultMap.get("STATE"))) {
            ArrayList<Long> employeeIdList = new ArrayList<Long>(validatorSuccessList.size());
            for (DynamicObject dynamicObject : validatorSuccessList) {
                if (!userHrMap.containsKey(dynamicObject.getLong("id"))) continue;
                DynamicObject operationManagerdObj = this.createOperationManageService.buildOperationmanagerd(dynamicObject, ActivationStatus.B, OperatevalEnum.B);
                operationManagerdObjList.add(operationManagerdObj);
                dynamicObject.set("activationstatus", (Object)ActivationStatus.B);
                dynamicObject.set("activationtime", (Object)DateUtils.nowDateTime());
                dynamicObject.set("user", (Object)RequestContext.get().getCurrUserId());
                dynamicObject.set("failreason", (Object)"");
                employeeIdList.add(dynamicObject.getLong("employee.id"));
            }
            List stdRsmIdList = StandardResumeDataHelper.batchQueryStdRsmByEmpId(employeeIdList);
            LOG.info("CancelLicenseOp.beginOperationTransaction stdRsmIdList {} employeeIdList {}", (Object)stdRsmIdList, employeeIdList);
            Map<String, String> paramMap = Collections.singletonMap("status", "B");
            new IResumeService().updateStdRsmWithNoHistory(stdRsmIdList, paramMap);
        } else {
            Map dataMap = (Map)invokeResultMap.get("DATA");
            Object message = dataMap.get("message");
            for (DynamicObject dynamicObject : validatorSuccessList) {
                if (!userHrMap.containsKey(dynamicObject.getLong("id"))) continue;
                DynamicObject operationManagerdObj = this.createOperationManageService.buildOperationmanagerd(dynamicObject, ActivationStatus.C, OperatevalEnum.B);
                operationManagerdObj.set("failreason", message);
                operationManagerdObjList.add(operationManagerdObj);
                dynamicObject.set("activationstatus", (Object)ActivationStatus.C);
                dynamicObject.set("failreason", message);
                dynamicObject.set("activationtime", (Object)DateUtils.nowDateTime());
                dynamicObject.set("user", (Object)RequestContext.get().getCurrUserId());
            }
        }
    }

    private void filterStatus(List<DynamicObject> validatorSuccessList, Map<Long, Long> userHrMap, List<Long> personIdList) {
        List employeeIdList = validatorSuccessList.stream().map(dynamicObject -> dynamicObject.getLong("employee.id")).collect(Collectors.toList());
        LOG.info("OpeningLicenseOp.filterStatus employeeIdList : {}", employeeIdList);
        Map checkInvokeConditionMap = this.stdRsmCommonService.needBindAccount(employeeIdList);
        LOG.info("OpeningLicenseOp.filterStatus employeeIdList : {} checkInvokeConditionMap : {}", (Object)checkInvokeConditionMap);
        for (DynamicObject dynamicObject2 : validatorSuccessList) {
            long employeeId = dynamicObject2.getLong("employee.id");
            if (ActivationStatus.A.code.equals(dynamicObject2.getString("activationstatus"))) {
                personIdList.add(employeeId);
                continue;
            }
            if (ActivationStatus.D.code.equals(dynamicObject2.getString("activationstatus"))) {
                long userHrId = dynamicObject2.getDynamicObject("employee").getDynamicObject("person").getLong("id");
                userHrMap.put(dynamicObject2.getLong("id"), userHrId);
                continue;
            }
            if (!ActivationStatus.C.code.equals(dynamicObject2.getString("activationstatus"))) continue;
            this.checkInvokeMethod(userHrMap, personIdList, checkInvokeConditionMap, dynamicObject2, employeeId);
        }
    }

    private void checkInvokeMethod(Map<Long, Long> userHrMap, List<Long> personIdList, Map<Long, Boolean> checkInvokeConditionMap, DynamicObject dynamicObject, long employeeId) {
        if (checkInvokeConditionMap.get(employeeId).booleanValue()) {
            personIdList.add(employeeId);
        } else {
            long userHrId = dynamicObject.getDynamicObject("employee").getDynamicObject("person").getLong("id");
            userHrMap.put(dynamicObject.getLong("id"), userHrId);
        }
    }

    private Map<String, Object> invokeUpdateUsedCertCount(Map<Long, Long> userHrMap) {
        if (userHrMap.isEmpty()) {
            return Maps.newHashMap();
        }
        QFilter qFilter = new QFilter("id", "in", userHrMap.values());
        DynamicObject[] hrPiPersons = BusinessDataServiceHelper.load((String)"hrpi_person", (String)"id,personindexid", (QFilter[])new QFilter[]{qFilter});
        Map<Long, Long> personIndexIdMap = Arrays.stream(hrPiPersons).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getLong("personindexid")));
        LOG.info("OpeningLicenseOp.opendLicense personIndexIdMap {} qFilter {}", personIndexIdMap, (Object)qFilter);
        ArrayList<Long> pids = new ArrayList<Long>(personIndexIdMap.values());
        Map updateUsedCertCountMap = TSIRMCertCommonHelper.updateUsedCertCount((String)"2+TXFE9NU13A", (String)"tsirm_stdrsm", pids);
        LOG.info("OpeningLicenseOp.opendLicense updateUsedCertCountMap {} param {}", (Object)updateUsedCertCountMap, pids);
        return updateUsedCertCountMap;
    }

    private void invokeBindAccount(List<Long> personIdList, List<DynamicObject> validatorSuccessList, List<DynamicObject> validatorFailList) {
        if (personIdList.isEmpty()) {
            return;
        }
        Map<Long, DynamicObject> employeeMap = validatorSuccessList.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("employee.id"), Function.identity()));
        HashMap<String, List<Long>> idMaps = new HashMap<String, List<Long>>(personIdList.size());
        idMaps.put("employee", personIdList);
        Map resultMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{idMaps});
        LOG.info("OpeningLicenseOp.opendLicense resultMap {} idMaps {}", (Object)resultMap, idMaps);
        if (((Boolean)resultMap.get("success")).booleanValue()) {
            Map data = (Map)resultMap.get("data");
            this.doInvokeBindAccount(personIdList, validatorSuccessList, validatorFailList, employeeMap, data);
        } else {
            LOG.info("OpeningLicenseOp.opendLicense getUserIdByPersonInfo error");
            Map<Long, Long> employeeIdMap = personIdList.stream().collect(Collectors.toMap(employeId -> employeId, employeId -> employeId, (v1, v2) -> v1));
            Iterator<DynamicObject> iterator = validatorSuccessList.iterator();
            while (iterator.hasNext()) {
                DynamicObject dynamicObject2 = iterator.next();
                long employeeId = dynamicObject2.getLong("employee.id");
                if (!employeeIdMap.containsKey(employeeId)) continue;
                iterator.remove();
                dynamicObject2.set("failreasoncombo", (Object)"0");
                dynamicObject2.set("checkfail", (Object)Boolean.TRUE);
                dynamicObject2.set("failreason", (Object)"invoke hrpi getUserIdByPersonInfo return fail");
                validatorFailList.add(dynamicObject2);
            }
        }
    }

    private void doInvokeBindAccount(List<Long> personIdList, List<DynamicObject> validatorSuccessList, List<DynamicObject> validatorFailList, Map<Long, DynamicObject> employeeMap, Map<Long, Map<String, Long>> data) {
        for (Long employeeId : personIdList) {
            Map<String, Long> dataValue = data.get(employeeId);
            DynamicObject dynamicObject = employeeMap.get(employeeId);
            if (dataValue == null) {
                validatorSuccessList.remove(dynamicObject);
                dynamicObject.set("failreasoncombo", (Object)"0");
                dynamicObject.set("checkfail", (Object)Boolean.TRUE);
                dynamicObject.set("failreason", (Object)"not bos user info");
                validatorFailList.add(dynamicObject);
                continue;
            }
            Long userId = dataValue.get("user");
            BizResult bizResult = empCVService.bindAccount(userId);
            LOG.info("OpeningLicenseOp.opendLicense bizResult {} userId {}", (Object)bizResult, (Object)userId);
            if (bizResult.getSuccess().booleanValue()) {
                dynamicObject.set("activationstatus", (Object)ActivationStatus.B);
                dynamicObject.set("failreason", (Object)"");
                continue;
            }
            validatorSuccessList.remove(dynamicObject);
            dynamicObject.set("failreasoncombo", (Object)"0");
            dynamicObject.set("checkfail", (Object)Boolean.TRUE);
            dynamicObject.set("failreason", (Object)bizResult.getMessage());
            validatorFailList.add(dynamicObject);
        }
    }
}

