/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.op.operationmanage;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tsc.tsirm.opplugin.web.validator.operationmanage.OperateEmployeeValidators;

public class OperateEmployeeOp
extends HRDataBaseOp {
    HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsirm_operateemployee");

    public void onAddValidators(AddValidatorsEventArgs eventArgs) {
        super.onAddValidators(eventArgs);
        eventArgs.addValidator((AbstractValidator)new OperateEmployeeValidators());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs transactionArgs) {
        super.beginOperationTransaction(transactionArgs);
        DynamicObject[] entities = transactionArgs.getDataEntities();
        DynamicObject entity = entities[0];
        String employees = entity.getString("employees");
        if (StringUtils.isBlank((CharSequence)employees)) {
            return;
        }
        List employeeIds = SerializationUtils.fromJsonStringToList((String)employees, Long.class);
        ArrayList objects = Lists.newArrayListWithCapacity((int)employeeIds.size());
        for (Long employeeId : employeeIds) {
            DynamicObject object = this.hrBaseServiceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)entity, (DynamicObject)object);
            object.set("employee", (Object)new Object[]{employeeId});
            objects.add(object);
        }
        this.hrBaseServiceHelper.deleteByFilter(new QFilter("id", "!=", (Object)0).toArray());
        this.hrBaseServiceHelper.save(objects.toArray(new DynamicObject[0]));
    }
}

