/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.op.talentpool;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtHelper;
import org.apache.commons.lang3.ObjectUtils;

public class DeleteTreeValidator
extends AbstractValidator {
    public void validate() {
        if (this.dataEntities != null && this.dataEntities.length > 0) {
            IDataEntityType type = this.dataEntities[0].getDataEntity().getDataEntityType();
            this.deleteValidate((BasedataEntityType)type);
        }
    }

    public void deleteValidate(BasedataEntityType entityType) {
        List collect = Arrays.stream(this.dataEntities).map(d -> d.getDataEntity().getLong("id")).collect(Collectors.toList());
        BaseDataCheckRefrence check = new BaseDataCheckRefrence();
        check.getCheckRefEntityIds().add("tsirm_reservere");
        check.setDraftValidReference(true);
        this.quickSortInternally(this.dataEntities, 0, this.dataEntities.length - 1, entityType);
        HRBaseServiceHelper reserveRecordHelper = new HRBaseServiceHelper("tsirm_reservere");
        HRBaseServiceHelper talentPoolHelper = new HRBaseServiceHelper("tsirm_talentpoolmgt");
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject dynamicObject = this.dataEntities[i].getDataEntity();
            String longNumber = dynamicObject.getString("longnumber");
            String parentLongNumber = dynamicObject.getString("parent.longnumber");
            boolean flag = false;
            this.addIgnoreRefEntityIds(check);
            DynamicObject[] subTalentPools = TalentPoolMgtHelper.queryTalentPool((QFilter)new QFilter("longnumber", "like", (Object)("%" + dynamicObject.getString("number") + "%")));
            List subTalentPoolIdList = Arrays.stream(subTalentPools).map(dynamicObject1 -> dynamicObject1.getLong("id")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("talentpool", "=", (Object)dynamicObject.getLong("id"));
            qFilter.or("talentpool", "in", subTalentPoolIdList);
            boolean isExists = reserveRecordHelper.isExists(qFilter);
            if (isExists) {
                if (this.dataEntities.length > 1) {
                    this.addMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u201c{0}\u201d\u4e0b\u5df2\u6709\u5019\u9009\u4eba\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"DeleteTreeValidator_2", (String)"tsc-tsirm-opplugin", (Object[])new Object[]{this.dataEntities[i].getDataEntity().getString("name")}));
                } else {
                    this.addMessage(this.dataEntities[i], ResManager.loadKDString((String)"{0}\uff1a\u201c{1}\u201d\u4e0b\u5df2\u6709\u5019\u9009\u4eba\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"DeleteTreeValidator_3", (String)"tsc-tsirm-opplugin", (Object[])new Object[]{this.dataEntities[i].getDataEntity().getString("number"), this.dataEntities[i].getDataEntity().getString("name")}));
                }
                this.dataEntities[i] = null;
                continue;
            }
            if (!ObjectUtils.isNotEmpty(subTalentPoolIdList)) continue;
            Iterator iterator = subTalentPoolIdList.iterator();
            while (iterator.hasNext()) {
                if (!collect.contains(iterator.next())) continue;
                iterator.remove();
            }
            if (!ObjectUtils.isNotEmpty(subTalentPoolIdList)) continue;
            talentPoolHelper.delete(subTalentPoolIdList.toArray());
        }
    }

    public void quickSortInternally(ExtendedDataEntity[] av, int pv, int rv, BasedataEntityType entityType) {
        if (pv >= rv) {
            return;
        }
        int qv = this.partition(av, pv, rv, entityType);
        this.quickSortInternally(av, pv, qv - 1, entityType);
        this.quickSortInternally(av, qv + 1, rv, entityType);
    }

    public int compare(ExtendedDataEntity arg0, ExtendedDataEntity arg1, BasedataEntityType entityType) {
        DynamicObject dynamicObject1 = arg0.getDataEntity();
        DynamicObject dynamicObject2 = arg1.getDataEntity();
        String longNumberDLM = ".";
        for (IDataEntityProperty property : entityType.getProperties()) {
            if (!(property instanceof ParentBasedataProp)) continue;
            longNumberDLM = ((ParentBasedataProp)property).getLongNumberDLM();
        }
        if (dynamicObject1.getString("longnumber").split("\\" + longNumberDLM).length > dynamicObject2.getString("longnumber").split("\\" + longNumberDLM).length) {
            return 1;
        }
        return -1;
    }

    public int partition(ExtendedDataEntity[] av, int pv, int rv, BasedataEntityType entityType) {
        ExtendedDataEntity pivot = av[rv];
        int index = pv;
        for (int j = pv; j < rv; ++j) {
            if (this.compare(av[j], pivot, entityType) <= 0) continue;
            if (index == j) {
                ++index;
                continue;
            }
            ExtendedDataEntity tmp = av[index];
            av[index++] = av[j];
            av[j] = tmp;
        }
        ExtendedDataEntity tmp = av[index];
        av[index] = av[rv];
        av[rv] = tmp;
        return index;
    }

    public void addIgnoreRefEntityIds(BaseDataCheckRefrence checker) {
        String[] entityIds;
        RefObject opValue = new RefObject();
        if (this.getOption().tryGetVariableValue("ignorerefentityids", opValue) && StringUtils.isNotBlank((CharSequence)((CharSequence)opValue.getValue()))) {
            for (String entityId : entityIds = StringUtils.split((String)((String)opValue.getValue()), (String)",")) {
                if (!StringUtils.isNotBlank((CharSequence)entityId)) continue;
                checker.getIgnoreRefEntityIds().add(entityId);
            }
        }
        opValue = new RefObject();
        if (this.getOption().tryGetVariableValue("checkrefentityids", opValue) && StringUtils.isNotBlank((CharSequence)((CharSequence)opValue.getValue()))) {
            for (String entityId : entityIds = StringUtils.split((String)((String)opValue.getValue()), (String)",")) {
                if (!StringUtils.isNotBlank((CharSequence)entityId)) continue;
                checker.getCheckRefEntityIds().add(entityId);
            }
        }
    }
}

