/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.advert;

import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBizService;
import kd.tsc.tsirm.business.domain.advert.service.AdvertConfigHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertDetailExDataHelper;
import kd.tsc.tsrbd.common.kdstring.TSCBaseKDString;

public class AdvModifyValidator
extends HRDataBaseValidator {
    private AdvertBizService advertBizService = AdvertBizService.getInstance();
    private static final String MODULE = AdvModifyValidator.class.getName();

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        super.validate();
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject advert = dataEntity.getDataEntity();
            advert = AdvertDetailExDataHelper.getInstance().queryAdvertDetail(Long.valueOf(advert.getLong("id")));
            String errorMsg = this.advertBizService.checkAdvPub(advert);
            if (HRStringUtils.isNotEmpty((String)errorMsg)) {
                this.addErrorMessage(dataEntity, errorMsg);
                continue;
            }
            errorMsg = this.advertBizService.checkAdvAuditStatus(advert, true);
            if (HRStringUtils.isNotEmpty((String)errorMsg)) {
                Boolean isNeedAudit = AdvertConfigHelper.needAuditByChannel((DynamicObject)advert);
                if (isNeedAudit.booleanValue()) {
                    String billNo = advert.getString("advbillno");
                    String tip = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u3001\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u7684\u5355\u636e\u8fdb\u884c\u4fee\u6539\u3002", (String)"AdvModifyValidator_0", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]);
                    errorMsg = String.format(Locale.ROOT, tip, billNo);
                }
                this.addErrorMessage(dataEntity, errorMsg);
                continue;
            }
            String status = advert.getString("advertstatus");
            if (HRStringUtils.equals((String)status, (String)"A")) continue;
            this.addErrorMessage(dataEntity, TSCBaseKDString.dataChangedTip());
        }
    }
}

