/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.advert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.domain.advert.service.AdvertApprovalDataHelper;
import kd.tsc.tsirm.common.enums.advert.AdvertApprovalStateEnum;

public class AdvertApprovalOpValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObject[] dynamicObjects = this.getDbDataEntities(dataEntities);
        Map<Long, DynamicObject> advertApprovalMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject validateDataEntity = dataEntity.getDataEntity();
            long id = validateDataEntity.getLong("id");
            DynamicObject dbObj = advertApprovalMap.get(id);
            String approvalStatus = dbObj.getString("billstatus");
            if (HRStringUtils.equals((String)"A", (String)approvalStatus)) continue;
            this.addErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u7684\u5e7f\u544a\u7533\u8bf7\u5355\u8fdb\u884c\u5220\u9664\u3002", (String)"AdvertApprovalOpValidator_1", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]), AdvertApprovalStateEnum.getDesc((String)dbObj.getString("billstatus"))));
        }
    }

    public DynamicObject[] getDbDataEntities(ExtendedDataEntity[] dataEntities) {
        ArrayList<Long> approvalIds = new ArrayList<Long>(dataEntities.length);
        for (int i = 0; i < dataEntities.length; ++i) {
            approvalIds.add(dataEntities[i].getDataEntity().getLong("id"));
        }
        return AdvertApprovalDataHelper.getInstance().loadApprovalData(approvalIds);
    }
}

