/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.advert;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBizService;
import kd.tsc.tsirm.business.domain.advert.service.AdvertConfigHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertDetailExDataHelper;
import kd.tsc.tsrbd.common.kdstring.TSCBaseKDString;

public class AdvertEditValidator
extends HRDataBaseValidator {
    private AdvertBizService advertBizService = AdvertBizService.getInstance();

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            this.checkAdvBeforeOperation(dataEntity);
        }
    }

    private void checkAdvBeforeOperation(ExtendedDataEntity dataEntity) {
        DynamicObject advert = dataEntity.getDataEntity();
        advert = AdvertDetailExDataHelper.getInstance().queryAdvertDetail(Long.valueOf(advert.getLong("id")));
        Boolean isNeedAudit = AdvertConfigHelper.needAuditByChannel((DynamicObject)advert);
        String errorMsg = this.advertBizService.checkAdvPub(advert);
        if (HRStringUtils.isNotEmpty((String)errorMsg)) {
            this.addErrorMessage(dataEntity, errorMsg);
            return;
        }
        errorMsg = this.advertBizService.checkAdvAuditStatus(advert, isNeedAudit == false);
        if (HRStringUtils.isNotEmpty((String)errorMsg)) {
            this.addErrorMessage(dataEntity, errorMsg);
            return;
        }
        String status = advert.getString("advertstatus");
        if (!(HRStringUtils.equals((String)status, (String)"S") || HRStringUtils.equals((String)status, (String)"A") || HRStringUtils.equals((String)status, (String)"K"))) {
            this.addErrorMessage(dataEntity, TSCBaseKDString.dataChangedTip());
        }
    }
}

