/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.advert;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ValidateResult;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.domain.advert.service.AdvertApprovalDataHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBizService;
import kd.tsc.tsirm.business.domain.advert.service.AdvertConfigHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertDetailExDataHelper;
import org.apache.commons.collections.CollectionUtils;

public class AdvertOpValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObject[] dynamicObjects = this.getDbDataEntities(dataEntities);
        Map<Long, DynamicObject> advertMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(xVal -> xVal.getLong("id"), xVal -> xVal));
        block19: for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject validateDataEntity = dataEntity.getDataEntity();
            long id = validateDataEntity.getLong("id");
            DynamicObject dbObj = advertMap.get(id);
            String advertStatus = dbObj.getString("advertstatus");
            String advertReleaseMethod = this.getAdvertPublishType(dbObj);
            boolean isTop = dbObj.getBoolean("istop");
            boolean isUrgent = dbObj.getBoolean("isurgent");
            switch (operateKey) {
                case "refreashadvert": {
                    this.refresh(dataEntity, advertReleaseMethod, advertStatus);
                    continue block19;
                }
                case "top": {
                    this.top(dataEntity, advertReleaseMethod, advertStatus, isTop);
                    continue block19;
                }
                case "untop": {
                    if (isTop) continue block19;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5e7f\u544a\u672a\u7f6e\u9876\u3002", (String)"AdvertOpValidator_5", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
                    continue block19;
                }
                case "urgent": {
                    this.expedited(dataEntity, advertReleaseMethod, advertStatus, isUrgent);
                    continue block19;
                }
                case "unurgent": {
                    if (isUrgent) continue block19;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5e7f\u544a\u672a\u6025\u62db\u3002", (String)"AdvertOpValidator_9", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
                    continue block19;
                }
                case "stopadvertall": 
                case "stopadvert": {
                    this.disable(dataEntity, dbObj);
                    continue block19;
                }
                case "startadvert": {
                    this.checkCanEnable(dbObj, dataEntity);
                    continue block19;
                }
            }
        }
        List<Object> errPkIds = this.getValidateErrPkIds();
        if (HRStringUtils.equals((String)"top", (String)operateKey)) {
            Tuple adTopNumConf = AdvertConfigHelper.getAdTopNumConf();
            int topNumNow = AdvertDetailExDataHelper.getInstance().getTopNumByUser(RequestContext.getOrCreate().getCurrUserId());
            this.validateLimitNum(errPkIds, (Tuple<Boolean, Integer>)adTopNumConf, topNumNow, ResManager.loadKDString((String)"\u7f6e\u9876\u6570\u91cf\u9650\u5236{0}\u4e2a\u3002", (String)"AdvertOpValidator_18", (String)"tsc-tsirm-opplugin", (Object[])new Object[]{adTopNumConf.item2}));
        } else if (HRStringUtils.equals((String)"urgent", (String)operateKey)) {
            Tuple adUrgentNumConf = AdvertConfigHelper.getAdUrgentNumConf();
            int urgentNumNow = AdvertDetailExDataHelper.getInstance().getUrgentNumByUser(RequestContext.getOrCreate().getCurrUserId());
            this.validateLimitNum(errPkIds, (Tuple<Boolean, Integer>)adUrgentNumConf, urgentNumNow, ResManager.loadKDString((String)"\u6025\u62db\u6570\u91cf\u9650\u5236{0}\u4e2a\u3002", (String)"AdvertOpValidator_19", (String)"tsc-tsirm-opplugin", (Object[])new Object[]{adUrgentNumConf.item2}));
        }
    }

    private void validateLimitNum(List<Object> errPkIds, Tuple<Boolean, Integer> adNumConf, int adNumNow, String errMsg) {
        if (((Boolean)adNumConf.item1).booleanValue()) {
            return;
        }
        int remainingNum = (Integer)adNumConf.item2 - adNumNow;
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            if (errPkIds.contains(dataEntity.getBillPkId())) continue;
            if (remainingNum > 0) {
                --remainingNum;
                continue;
            }
            this.addErrorMessage(dataEntity, errMsg);
        }
    }

    private List<Object> getValidateErrPkIds() {
        ValidateResult validateResult = this.getValidateResult();
        if (!validateResult.isSuccess() && CollectionUtils.isEmpty((Collection)validateResult.getAllErrorInfo())) {
            return Arrays.stream(this.getDataEntities()).map(ExtendedDataEntity::getBillPkId).collect(Collectors.toList());
        }
        return this.getFalseDataEntities().stream().map(ExtendedDataEntity::getBillPkId).collect(Collectors.toList());
    }

    private void disable(ExtendedDataEntity dataEntity, DynamicObject dbObj) {
        String advertStatus = dbObj.getString("advertstatus");
        String advertReleaseMethod = this.getAdvertPublishType(dbObj);
        String approvalStatus = dbObj.getString("approvestatus");
        if (!"S".equals(advertStatus)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u72b6\u6001\u4e3a\u201c\u5df2\u53d1\u5e03\u201d\u7684\u5e7f\u544a\u8fdb\u884c\u505c\u7528\u3002", (String)"AdvertOpValidator_10", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
        } else if ("C".equals(advertReleaseMethod)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d2\u4ef6\u53d1\u5e03\u5e7f\u544a\u7684\u505c\u7528\u4ec5\u505a\u5185\u90e8\u8bb0\u5f55\uff0c\u8bf7\u60a8\u524d\u5f80{0}\u6e20\u9053\u624b\u52a8\u505c\u7528\u3002", (String)"AdvertOpValidator_20", (String)"tsc-tsirm-opplugin", (Object[])new Object[]{this.getAdvertChannelName(dbObj)}));
        } else {
            this.checkAuditBill(dataEntity, approvalStatus, false);
        }
    }

    private void expedited(ExtendedDataEntity dataEntity, String advertReleaseMethod, String advertStatus, boolean isUrgent) {
        this.addChannelErrorMessage(dataEntity);
        if ("D".equals(advertReleaseMethod)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u53d1\u5e03\u65b9\u5f0f\u201d\u4e3a\u201c\u7ebf\u4e0a\u53d1\u5e03\u201d\u7684\u5e7f\u544a\u8fdb\u884c\u6025\u62db\u64cd\u4f5c\u3002", (String)"AdvertOpValidator_6", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
        } else if (!"S".equals(advertStatus)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u72b6\u6001\u4e3a\u201c\u5df2\u53d1\u5e03\u201d\u7684\u5e7f\u544a\u8fdb\u884c\u6025\u62db\u3002", (String)"AdvertOpValidator_7", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
        } else if (isUrgent) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u672a\u6025\u62db\u7684\u5e7f\u544a\u8fdb\u884c\u6025\u62db\u3002", (String)"AdvertOpValidator_8", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
        }
    }

    private void top(ExtendedDataEntity dataEntity, String advertReleaseMethod, String advertStatus, boolean isTop) {
        this.addChannelErrorMessage(dataEntity);
        if ("D".equals(advertReleaseMethod)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u53d1\u5e03\u65b9\u5f0f\u201d\u4e3a\u201c\u7ebf\u4e0a\u53d1\u5e03\u201d\u7684\u5e7f\u544a\u8fdb\u884c\u7f6e\u9876\u64cd\u4f5c\u3002", (String)"AdvertOpValidator_2", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
        } else if (!"S".equals(advertStatus)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u72b6\u6001\u4e3a\u201c\u5df2\u53d1\u5e03\u201d\u7684\u5e7f\u544a\u8fdb\u884c\u7f6e\u9876\u3002", (String)"AdvertOpValidator_3", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
        } else if (isTop) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u672a\u7f6e\u9876\u7684\u5e7f\u544a\u8fdb\u884c\u7f6e\u9876\u3002", (String)"AdvertOpValidator_4", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
        }
    }

    private void refresh(ExtendedDataEntity dataEntity, String advertReleaseMethod, String advertStatus) {
        this.addChannelErrorMessage(dataEntity);
        if ("D".equals(advertReleaseMethod)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u53d1\u5e03\u65b9\u5f0f\u201d\u4e3a\u201c\u7ebf\u4e0a\u53d1\u5e03\u201d\u7684\u5e7f\u544a\u8fdb\u884c\u5237\u65b0\u64cd\u4f5c\u3002", (String)"AdvertOpValidator_0", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
        } else if (!"S".equals(advertStatus)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u72b6\u6001\u4e3a\u201c\u5df2\u53d1\u5e03\u201d\u7684\u5e7f\u544a\u8fdb\u884c\u5237\u65b0\u3002", (String)"AdvertOpValidator_1", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
        }
    }

    private void addChannelErrorMessage(ExtendedDataEntity dataEntity) {
        long id = dataEntity.getDataEntity().getLong("id");
        DynamicObject advertDetail = AdvertDetailExDataHelper.getInstance().queryAdvertDetail(Long.valueOf(id));
        long channelId = advertDetail.getLong("channel.id");
        boolean channelIdIsEnable = AdvertBizService.getInstance().getChannelIdIsEnable(Long.valueOf(channelId));
        if (!channelIdIsEnable) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6e20\u9053\u88ab\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"AdvertOpValidator_21", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkCanEnable(DynamicObject dbObj, ExtendedDataEntity dataEntity) {
        this.addChannelErrorMessage(dataEntity);
        String advertStatus = dbObj.getString("advertstatus");
        DynamicObject position = dbObj.getDynamicObject("position");
        long channelId = dbObj.getLong("channel_id");
        String posStatus = HRObjectUtils.isEmpty((Object)position) ? null : position.getString("positionstatus");
        Date endDate = dbObj.getDate("enddate");
        String checkEndDate = AdvertBizService.getInstance().checkAdvEndDate(endDate);
        if ("D".equals(posStatus) || "G".equals(posStatus)) {
            this.addErrorMessage(dataEntity, AdvertBizService.getInstance().posCloseTip());
        } else if (!"D".equals(advertStatus) && !"E".equals(advertStatus)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u72b6\u6001\u4e3a\u201c\u5df2\u505c\u7528/\u53d1\u5e03\u5931\u8d25\u201d\u7684\u5e7f\u544a\u8fdb\u884c\u542f\u7528\u3002", (String)"AdvertOpValidator_12", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
        } else if (HRStringUtils.isNotEmpty((String)checkEndDate)) {
            this.addErrorMessage(dataEntity, checkEndDate);
        } else if (AdvertConfigHelper.needAuditByChannel((Long)channelId).booleanValue()) {
            if (!AdvertConfigHelper.isHasAdvertWorkFlow().booleanValue()) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u5de5\u4f5c\u6d41\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u3002", (String)"AdvertOpValidator_15", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
            } else {
                this.checkAuditBill(dataEntity, advertStatus, true);
            }
        }
    }

    private void checkAuditBill(ExtendedDataEntity dataEntity, String approvalStatus, boolean isEnable) {
        if (!HRStringUtils.equals((String)"Z", (String)approvalStatus)) {
            DynamicObject validateDataEntity = dataEntity.getDataEntity();
            long id = validateDataEntity.getLong("id");
            Object[] noStopAdvert = AdvertApprovalDataHelper.getInstance().getNoEndApproval(Long.valueOf(id));
            if (!HRArrayUtils.isEmpty((Object[])noStopAdvert)) {
                String tip = isEnable ? ResManager.loadKDString((String)"\u5f53\u524d\u5e7f\u544a\u5b58\u5728\u672a\u5b8c\u7ed3\u7684\u5ba1\u6279\u5355%s\uff0c\u65e0\u6cd5\u63d0\u4ea4\u65b0\u7684\u542f\u7528\u5e7f\u544a\u7533\u8bf7\u3002", (String)"AdvertOpValidator_22", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f53\u524d\u62db\u8058\u5e7f\u544a\u5b58\u5728\u672a\u5b8c\u7ed3\u7684\u5ba1\u6279\u5355%s\uff0c\u8bf7\u5148\u5c06\u5ba1\u6279\u5355\u64a4\u56de\u3002", (String)"AdvertOpValidator_23", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, String.format(Locale.ROOT, tip, noStopAdvert[0].getString("billno")));
            }
        }
    }

    public DynamicObject[] getDbDataEntities(ExtendedDataEntity[] dataEntities) {
        Long[] ids = new Long[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            ids[i] = dataEntities[i].getDataEntity().getLong("id");
        }
        return AdvertDetailExDataHelper.getInstance().queryAdvertDetail(ids);
    }

    private String getAdvertPublishType(DynamicObject advertObj) {
        DynamicObject channel = advertObj.getDynamicObject("channel");
        String pubType = HRObjectUtils.isEmpty((Object)channel) ? null : channel.getString("advertisement");
        return pubType;
    }

    private String getAdvertChannelName(DynamicObject advertObj) {
        DynamicObject channel = advertObj.getDynamicObject("channel");
        String channelName = HRObjectUtils.isEmpty((Object)channel) ? null : channel.getString("name");
        return channelName;
    }
}

