/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.advert;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBizService;
import kd.tsc.tsirm.business.domain.advert.service.AdvertConfigHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertTplExCommonHelper;
import kd.tsc.tsirm.common.constants.advert.AdvertConstants;
import org.apache.commons.lang3.tuple.Pair;

public class AdvertSubmitValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (!operateKey.equals("submit")) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            boolean hasAdvertWorkFlow;
            DynamicObject advBill = dataEntity.getDataEntity();
            DynamicObjectCollection advSnaps = advBill.getDynamicObjectCollection("entryentity");
            if (AdvertBizService.getInstance().checkPositionClose(Long.valueOf(advBill.getLong("position_id")))) {
                this.addErrorMessage(dataEntity, AdvertBizService.getInstance().posCloseTip());
                return;
            }
            List channelIds = advSnaps.stream().map(snap -> snap.getLong("channel_id")).collect(Collectors.toList());
            Pair confByChannel = AdvertConfigHelper.getConfByChannel(channelIds);
            if (((Boolean)confByChannel.getLeft()).booleanValue() && !(hasAdvertWorkFlow = AdvertConfigHelper.isHasAdvertWorkFlow().booleanValue())) {
                this.addFatalErrorMessage(dataEntity, AdvertConstants.hasNoFlow());
                return;
            }
            String matchErrMsg = AdvertTplExCommonHelper.matchWorkflowCheck((DynamicObject)advBill);
            if (!HRStringUtils.isNotEmpty((String)matchErrMsg)) continue;
            this.addFatalErrorMessage(dataEntity, matchErrMsg);
        }
    }
}

