/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.appfile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tsirm.business.license.TSIRMCertCommonHelper;
import kd.tsc.tsirm.common.constants.appfile.AppFileConstants;

public class AppArchiveValidator
extends HRDataBaseValidator {
    private static final Log LOG = LogFactory.getLog(AppArchiveValidator.class);

    public void validate() {
        ArrayUtils.reverse((Object[])this.dataEntities);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject appFileDy = dataEntity.getDataEntity();
            String fileStatus = appFileDy.getString("filestatus");
            String fileStatusDesc = AppFileHelper.getFileStatusDesc((DynamicObject)appFileDy);
            String name = appFileDy.getString("name");
            if (AppFileConstants.APP_FILE_STATUS_TBEMP.equals(fileStatus)) continue;
            String errorTip = AppFileResManagerHelper.getAppFileStatusErrorTip();
            this.addErrorMessage(dataEntity, String.format(errorTip, name, fileStatusDesc));
        }
        this.validateLicense();
    }

    private boolean validateLicense() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        List appFileIds = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).map(appFile -> appFile.getLong("id")).collect(Collectors.toList());
        List pids = AppFileHelper.getAppFilePid(appFileIds);
        Map resultMap = TSIRMCertCommonHelper.verifyCertByPid((String)"2+TXFE9NU13A", (String)"tsirm_appfile_view", (List)pids);
        if ("FAIL".equals(resultMap.get("STATE").toString())) {
            Map data = (Map)resultMap.get("DATA");
            String message = (String)data.get("infoType");
            if ("FORBIDDEN".equals(message)) {
                return true;
            }
            List nexistids = (List)resultMap.get("NEXISTID");
            List exceptids = (List)resultMap.get("EXCEPTID");
            ArrayList resultList = new ArrayList(16);
            if (nexistids != null && !nexistids.isEmpty()) {
                resultList.addAll(nexistids);
            }
            if (exceptids != null && !exceptids.isEmpty()) {
                resultList.addAll(exceptids);
            }
            Map personByPids = TSIRMCertCommonHelper.getPersonByPids(resultList);
            StringBuilder sbd = new StringBuilder();
            for (Map.Entry dynamicObjectEntry : personByPids.entrySet()) {
                DynamicObject person = (DynamicObject)dynamicObjectEntry.getValue();
                sbd.append(person.getString("name"));
                sbd.append("\u3001");
            }
            String nameTips = sbd.substring(0, sbd.length() - 1);
            LOG.error(nameTips + ResManager.loadKDString((String)"\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"AppArchiveValidator_0", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
        }
        return true;
    }
}

