/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.appfile;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.domain.appfile.AppFileFlowLockHelper;

public class AppFileFlowLockValidator
extends HRDataBaseValidator {
    private final Set<Long> lockedStdRsmIds = Sets.newHashSet();

    public void validate() {
        ArrayUtils.reverse((Object[])this.dataEntities);
        List stdRsmIdList = Arrays.stream(this.dataEntities).map(dyo -> dyo.getDataEntity().getLong("stdrsm.id")).collect(Collectors.toList());
        Map lockInfoMap = AppFileFlowLockHelper.getFlowLockInfosByStdRsmId(stdRsmIdList);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject appFile = dataEntity.getDataEntity();
            Long stdRsmId = appFile.getLong("stdrsm.id");
            if (lockInfoMap.get(stdRsmId) == null && !this.lockedStdRsmIds.contains(stdRsmId)) continue;
            String errorTip = this.getDataEntities().length == 1 ? ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u9501\u5b9a\uff0c\u65e0\u9700\u91cd\u590d\u9501\u5b9a\u3002", (String)"AppFileFlowLockValidator_0", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5019\u9009\u4eba%s\u5df2\u9501\u5b9a\uff0c\u65e0\u9700\u91cd\u590d\u9501\u5b9a\u3002", (String)"AppFileFlowLockValidator_1", (String)"tsc-tsirm-opplugin", (Object[])new Object[]{appFile.getString("name")});
            this.addErrorMessage(dataEntity, errorTip);
        }
    }
}

