/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.appfile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileOpHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tsirm.common.constants.appfile.AppFileConstants;
import kd.tsc.tsirm.common.constants.appfile.AppFileOperateEnum;

public class AppFileInProcessValidator
extends HRDataBaseValidator {
    private static final List<String> allowPassOpNumber_Changed = ImmutableList.of((Object)"printfile");
    private static final List<String> allowPassOpNumber_EXPIRED = ImmutableList.of((Object)"printfile");
    private static final List<String> allowPassOpNumber_Break = ImmutableList.of((Object)"lockright", (Object)"lock", (Object)"unlockright", (Object)"unlock", (Object)"sendmsg", (Object)"regmark", (Object)"printfile");
    private static final List<String> allowPassOpNumber_Changing = ImmutableList.of((Object)"lockright", (Object)"lock", (Object)"unlockright", (Object)"unlock", (Object)"sendmsg", (Object)"regmark", (Object)"printfile");
    private static final List<String> allowPassOpNumber_Wait = ImmutableList.of((Object)"changestageright", (Object)"changestagestatus", (Object)"sendmsg", (Object)"regmark", (Object)"lockright", (Object)"lock", (Object)"unlockright", (Object)"unlock", (Object)"archive", (Object)"archiveright", (Object)"printfile");
    private static final List<String> allowPassOpNumber_Obsolete = ImmutableList.of((Object)"transferposright", (Object)"transferpos", (Object)"sendmsg", (Object)"regmark", (Object)"printfile");
    private static final List<String> allowPassOpNumber_Process = ImmutableList.of((Object)"transferposright", (Object)"transferpos", (Object)"changestageright", (Object)"changestagestatus", (Object)"eliminateright", (Object)"eliminate", (Object)"lockright", (Object)"lock", (Object)"unlockright", (Object)"unlock", (Object)"filter", (Object)"validateappfile", (Object[])new String[]{"sendmsg", "regmark", "arrangeaninterview", "hireapproval", "printfile"});
    private static final Map<String, List<String>> statusToPassOpMap = Maps.newHashMapWithExpectedSize((int)6);

    public void validate() {
        ArrayUtils.reverse((Object[])this.dataEntities);
        String ignoreNumber = this.getOption().getVariableValue("ignorenumber", null);
        String operateKey = this.getOperateKey();
        if ("true".equals(ignoreNumber)) {
            this.setAddBillNoForContent(false);
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject appFile = this.dataEntities.length == 1 ? AppFileHelper.queryOne((long)((Long)dataEntity.getBillPkId())) : dataEntity.getDataEntity();
            String fileStatus = appFile.getString("filestatus");
            List<String> allowedPassOpNumberList = statusToPassOpMap.get(fileStatus);
            if (allowedPassOpNumberList == null || allowedPassOpNumberList.contains(operateKey)) continue;
            this.addBreakMessage(appFile, dataEntity);
        }
    }

    private void addBreakMessage(DynamicObject appFile, ExtendedDataEntity dataEntity) {
        String tipFmt = AppFileResManagerHelper.getFileStatusErrorTip();
        String opDes = AppFileOperateEnum.getAllOpName().contains(this.getOperationName()) ? this.getOperationName() : AppFileOpHelper.getOpName((OperateOption)this.getOption(), (AbstractValidator)this);
        String errorTip = String.format(tipFmt, appFile.getString("name"), AppFileHelper.getFileStatusDesc((DynamicObject)appFile), opDes);
        this.addMessage(dataEntity, "notInProcess", errorTip, ErrorLevel.Error);
    }

    static {
        statusToPassOpMap.put(AppFileConstants.APP_FILE_STATUS_INVALID, allowPassOpNumber_Changed);
        statusToPassOpMap.put(AppFileConstants.APP_FILE_STATUS_ENDEMP, allowPassOpNumber_Break);
        statusToPassOpMap.put(AppFileConstants.APP_FILE_STATUS_EMPED, allowPassOpNumber_Changing);
        statusToPassOpMap.put(AppFileConstants.APP_FILE_STATUS_TBEMP, allowPassOpNumber_Wait);
        statusToPassOpMap.put(AppFileConstants.APP_FILE_STATUS_OUT, allowPassOpNumber_Obsolete);
        statusToPassOpMap.put(AppFileConstants.APP_FILE_STATUS_IN, allowPassOpNumber_Process);
        statusToPassOpMap.put(AppFileConstants.APP_FILE_STATUS_EXPIRED, allowPassOpNumber_EXPIRED);
    }
}

