/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.appfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.domain.appfile.AppFileFlowLockHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileOpHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tsirm.common.constants.appfile.AppFileFlowLockStatusEnum;

public class AppFileLockValidator
extends HRDataBaseValidator {
    private static final Set<String> LOCK_OPS = Sets.newHashSet((Object[])new String[]{"changestagestatus", "changestageright", "filter", "arrangeaninterview", "hirerecomend", "hirejobrank", "hiresalary", "hireapproval", "validateappfile", "addoffer", "lockright", "archive", "archiveright"});
    private String operationName;

    public void validate() {
        this.operationName = AppFileOpHelper.getOpName((OperateOption)this.getOption(), (AbstractValidator)this);
        String ignoreNumber = this.getOption().getVariableValue("ignorenumber", null);
        if ("true".equals(ignoreNumber)) {
            this.setAddBillNoForContent(false);
        }
        if (LOCK_OPS.contains(this.getOperateKey()) || "lock".equals(this.getOperateKey())) {
            ArrayUtils.reverse((Object[])this.dataEntities);
            DynamicObjectCollection appFileColl = this.getFlowLockInfos();
            LinkedHashMap unLockedMap = Maps.newLinkedHashMap();
            Map flowLockInfos = AppFileFlowLockHelper.getFlowLockData((List)appFileColl);
            boolean isShowLockValidateTip = LOCK_OPS.contains(this.getOperateKey());
            this.flowLockValidate(unLockedMap, flowLockInfos, isShowLockValidateTip);
            this.appFileMutexValidate(unLockedMap);
        }
    }

    private void appFileMutexValidate(LinkedHashMap<Long, List<ExtendedDataEntity>> unLockedMap) {
        for (Map.Entry<Long, List<ExtendedDataEntity>> unLockedEntry : unLockedMap.entrySet()) {
            List<ExtendedDataEntity> unLockOneList = unLockedEntry.getValue();
            if (unLockOneList.size() <= 1) continue;
            List appFiles = unLockOneList.stream().map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
            String errorTipFmt = AppFileResManagerHelper.getErrorTipBySameCandidate();
            this.setAddBillNoForContent(false);
            for (ExtendedDataEntity extendedDataEntity : unLockOneList) {
                List otherAppFiles = appFiles.stream().filter(dyo -> !HRObjectUtils.equals((Object)dyo.getPkValue(), (Object)extendedDataEntity.getBillPkId())).collect(Collectors.toList());
                String errorTip = String.format(Locale.ROOT, errorTipFmt, AppFileOpHelper.getNoName((DynamicObject)extendedDataEntity.getDataEntity()) + "\u3001" + AppFileOpHelper.getErrorMulTipHead(otherAppFiles));
                this.addMessage(extendedDataEntity, "lockedStdRsm", errorTip, ErrorLevel.Error);
            }
            this.setAddBillNoForContent(true);
        }
    }

    private void flowLockValidate(LinkedHashMap<Long, List<ExtendedDataEntity>> unLockedMap, Map<Long, String> flowLockInfos, boolean isShowLockValidateTip) {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject appFile = dataEntity.getDataEntity();
            if (this.dataEntities.length == 1) {
                appFile = AppFileHelper.queryOne((long)((Long)dataEntity.getBillPkId()));
            }
            long stdRsmId = appFile.getLong("stdrsm.id");
            long appFileId = appFile.getLong("id");
            String lockInfo = flowLockInfos.get(appFileId);
            if (AppFileFlowLockStatusEnum.GRAY_LOCK.getStatus().equals(lockInfo)) {
                if (!isShowLockValidateTip) continue;
                String errorTip = AppFileResManagerHelper.getLockedWarn((String)this.operationName);
                this.addMessage(dataEntity, "locked", errorTip, ErrorLevel.Error);
                continue;
            }
            if (!AppFileFlowLockStatusEnum.UNLOCK.getStatus().equals(lockInfo) || !AppFileHelper.isInProcessOrEmp((DynamicObject)appFile)) continue;
            List<ExtendedDataEntity> extendedDataEntities = unLockedMap.get(stdRsmId);
            if (extendedDataEntities != null) {
                extendedDataEntities.add(dataEntity);
                continue;
            }
            unLockedMap.put(stdRsmId, Lists.newArrayList((Object[])new ExtendedDataEntity[]{dataEntity}));
        }
    }

    private DynamicObjectCollection getFlowLockInfos() {
        DynamicObjectCollection appFileColl = new DynamicObjectCollection();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject appFile = dataEntity.getDataEntity();
            if (this.dataEntities.length == 1) {
                appFile = AppFileHelper.queryOne((long)((Long)dataEntity.getBillPkId()));
            }
            appFileColl.add((Object)appFile);
        }
        return appFileColl;
    }
}

