/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.appfile;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.domain.appfile.AppFileFlowLockHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class AppFileUnFlowLockValidator
extends HRDataBaseValidator {
    private final Set<Long> lockedStdRsmIds = Sets.newHashSet();

    public void validate() {
        ArrayUtils.reverse((Object[])this.dataEntities);
        List stdRsmIdList = Arrays.stream(this.dataEntities).map(dyo -> dyo.getDataEntity().getLong("stdrsm.id")).collect(Collectors.toList());
        Map lockInfoMap = AppFileFlowLockHelper.getFlowLockInfosByStdRsmId(stdRsmIdList);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            String errorTip;
            DynamicObject appFile = dataEntity.getDataEntity();
            if (this.getDataEntities().length == 1) {
                appFile = AppFileHelper.queryOne((long)((Long)dataEntity.getBillPkId()));
            }
            Long stdRsmId = appFile.getLong("stdrsm.id");
            DynamicObject lockInfo = (DynamicObject)lockInfoMap.get(stdRsmId);
            if (lockInfoMap.get(stdRsmId) == null || this.lockedStdRsmIds.contains(stdRsmId) || !AppFileHelper.isInProcessOrEmp((DynamicObject)appFile)) {
                errorTip = this.getDataEntities().length == 1 ? AppFileResManagerHelper.getUnLockOneWarn() : AppFileResManagerHelper.getUnLockWarn((String)appFile.getString("name"));
                this.addErrorMessage(dataEntity, errorTip);
                continue;
            }
            long lockerId = lockInfo.getLong("locker.id");
            if (TSCRequestContext.getUserId() != lockerId) {
                errorTip = ResManager.loadKDString((String)"\u4f60\u4e0d\u662f\u5019\u9009\u4eba\u201c{0}\u201d\u7684\u9501\u5b9a\u4eba\uff0c\u65e0\u6cd5\u8fdb\u884c\u89e3\u9501\u3002", (String)"AppFileUnFlowLockValidator_0", (String)"tsc-tsirm-opplugin", (Object[])new Object[]{appFile.getString("name")});
                this.addErrorMessage(dataEntity, errorTip);
                continue;
            }
            if (!AppFileHelper.isInProcess((DynamicObject)appFile)) continue;
            this.lockedStdRsmIds.add(stdRsmId);
        }
    }
}

