/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.appfile;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileOfferHelper;
import kd.tsc.tsirm.business.license.TSIRMCertCommonHelper;

public class ChangeStageStatusValidator
extends HRDataBaseValidator {
    private long stageId;

    public ChangeStageStatusValidator(long stageId) {
        this.stageId = stageId;
    }

    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        long processId = extendedDataEntities[0].getDataEntity().getLong("recruproc.id");
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            boolean isOfferStgAndHasInfo;
            boolean isSameProc;
            DynamicObject appFileObject = extendedDataEntity.getDataEntity();
            if (extendedDataEntities.length == 1) {
                String selectProperties = "filestatus,recruproc.id,name,phone,email";
                appFileObject = AppFileHelper.queryOne((long)((Long)extendedDataEntity.getBillPkId()), (String)selectProperties);
            }
            boolean bl = isSameProc = processId != appFileObject.getLong("recruproc.id") && (AppFileHelper.isInProcess((DynamicObject)appFileObject) || AppFileHelper.isInEmpStatus((DynamicObject)appFileObject));
            if (isSameProc) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u76f8\u540c\u6d41\u7a0b\u4e0b\u7684\u5019\u9009\u4eba\u8fdb\u884c\u8f6c\u79fb\u73af\u8282\u72b6\u6001\u3002", (String)"ChangeStageStatusValidator_0", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
            }
            boolean bl2 = isOfferStgAndHasInfo = AppFileOfferHelper.validateInOfferStage((Long)this.stageId) && (HRStringUtils.isEmpty((String)appFileObject.getString("phone")) || HRStringUtils.isEmpty((String)appFileObject.getString("email")));
            if (!isOfferStgAndHasInfo) continue;
            String noPhoneAndEmailTipFmt = AppFileResManagerHelper.getNoPhoneAndEmailTip();
            this.addErrorMessage(extendedDataEntity, String.format(Locale.ROOT, noPhoneAndEmailTipFmt, appFileObject.getString("name")));
        }
        this.validateLicense();
    }

    private boolean validateLicense() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        List appFileIds = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).map(appFile -> appFile.getLong("id")).collect(Collectors.toList());
        List pids = AppFileHelper.getAppFilePid(appFileIds);
        Map resultMap = TSIRMCertCommonHelper.verifyCertByPid((String)"2+TXFE9NU13A", (String)"tsirm_appfile_view", (List)pids);
        if ("FAIL".equals(resultMap.get("STATE").toString())) {
            Map data = (Map)resultMap.get("DATA");
            String message = (String)data.get("infoType");
            if ("FORBIDDEN".equals(message)) {
                return true;
            }
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject appfile;
                Long appid;
                List appFileIdByPid;
                HashSet appids = new HashSet(dataEntities.length);
                List nexistids = (List)resultMap.get("NEXISTID");
                List exceptids = (List)resultMap.get("EXCEPTID");
                if (nexistids != null && nexistids.size() > 0) {
                    appFileIdByPid = AppFileHelper.getAppFileIdByPid((List)nexistids);
                    appids.addAll(appFileIdByPid);
                }
                if (exceptids != null && exceptids.size() > 0) {
                    appFileIdByPid = AppFileHelper.getAppFileIdByPid((List)exceptids);
                    appids.addAll(appFileIdByPid);
                }
                if (!appids.contains(appid = Long.valueOf((appfile = dataEntity.getDataEntity()).getLong("id")))) continue;
                String name = appfile.getString("name");
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"{0}\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"ChangeStageStatusValidator_1", (String)"tsc-tsirm-opplugin", (Object[])new Object[]{name}));
            }
            return true;
        }
        return true;
    }
}

