/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.appfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.common.constants.appfile.AppFileConstants;
import org.apache.commons.lang3.tuple.Pair;

public class RecoverAppFileValidator
extends HRDataBaseValidator {
    private Set<Pair<Long, Long>> midPositionIdSet = null;

    public void validate() {
        ArrayList extendedDataEntities = Lists.newArrayList((Object[])this.getDataEntities());
        Collections.reverse(extendedDataEntities);
        this.setDataEntities(extendedDataEntities.toArray(new ExtendedDataEntity[0]));
        this.validateStatus();
        this.validateStdRsmStatus();
        this.validateIsInProcess();
    }

    private void validateIsInProcess() {
        QFilter recoverFilter = this.getRecoverQFilter();
        if (recoverFilter != null) {
            recoverFilter = new QFilter("filestatus", "=", (Object)AppFileConstants.APP_FILE_STATUS_IN).and(recoverFilter);
            HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_appfilemdl");
            DynamicObjectCollection collection = helper.queryOriginalCollection("id,stdrsm.mid,position.id", new QFilter[]{recoverFilter});
            Set<Pair<Long, Long>> inAppFileIds = collection.stream().map(dyo -> Pair.of((Object)dyo.getLong("stdrsm.mid"), (Object)dyo.getLong("position.id"))).collect(Collectors.toSet());
            if (this.dataEntities.length == 1) {
                DynamicObject appFile = this.dataEntities[0].getDataEntity();
                if (inAppFileIds.contains(Pair.of((Object)appFile.getLong("stdrsm.mid"), (Object)appFile.getLong("position.id")))) {
                    this.addFatalErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u5b58\u5728\u4e8e\u8be5\u804c\u4f4d\u4e2d\uff0c\u6062\u590d\u5931\u8d25\u3002", (String)"RecoverAppFileValidator_5", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
                }
            } else {
                this.validateMultiIsInProcess(inAppFileIds);
            }
        }
    }

    private void validateMultiIsInProcess(Set<Pair<Long, Long>> inAppFileIds) {
        this.midPositionIdSet = Sets.newHashSet();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject appFile = dataEntity.getDataEntity();
            Long mid = appFile.getLong("stdrsm.mid");
            Long positionId = appFile.getLong("position.id");
            Pair filePair = Pair.of((Object)mid, (Object)positionId);
            if (inAppFileIds.contains(Pair.of((Object)appFile.getLong("stdrsm.mid"), (Object)appFile.getLong("position.id"))) || this.midPositionIdSet.contains(filePair)) {
                String name = appFile.getString("name");
                this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u5b58\u5728\u4e8e\u8be5\u804c\u4f4d\u4e2d\uff0c\u6062\u590d\u5931\u8d25\u3002", (String)"RecoverAppFileValidator_3", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]), name));
                continue;
            }
            if (!AppFileConstants.APP_FILE_STATUS_OUT.equals(appFile.getString("filestatus"))) continue;
            this.midPositionIdSet.add((Pair<Long, Long>)filePair);
        }
    }

    private QFilter getRecoverQFilter() {
        QFilter recoverFilter = null;
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject appFile = dataEntity.getDataEntity();
            QFilter qFilter = new QFilter("stdrsm.mid", "=", (Object)appFile.getLong("stdrsm.mid"));
            qFilter.and(new QFilter("position", "=", (Object)appFile.getLong("position.id")));
            qFilter.and(new QFilter("id", "!=", (Object)appFile.getLong("id")));
            if (recoverFilter == null) {
                recoverFilter = qFilter;
                continue;
            }
            recoverFilter.or(qFilter);
        }
        return recoverFilter;
    }

    private void validateStatus() {
        if (this.dataEntities.length == 1) {
            DynamicObject dataEntity = AppFileHelper.queryOne((long)((Long)this.dataEntities[0].getBillPkId()));
            if (!AppFileConstants.APP_FILE_STATUS_OUT.equals(dataEntity.getString("filestatus"))) {
                this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u6dd8\u6c70\u7684\u5019\u9009\u4eba\u8fdb\u884c\u6062\u590d\u3002", (String)"RecoverAppFileValidator_0", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
            }
        } else {
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject appFile = dataEntity.getDataEntity();
                if (AppFileConstants.APP_FILE_STATUS_OUT.equals(appFile.getString("filestatus"))) continue;
                String name = appFile.getString("name");
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u6dd8\u6c70\u7684\u5019\u9009\u4eba\u8fdb\u884c\u6062\u590d\u3002", (String)"RecoverAppFileValidator_0", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void validateStdRsmStatus() {
        if (this.dataEntities.length == 1) {
            DynamicObject appFile = AppFileHelper.queryOne((long)((Long)this.dataEntities[0].getBillPkId()));
            DynamicObject stdRsm = appFile.getDynamicObject("stdrsm");
            if (stdRsm.getString("status").equals("C")) {
                this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u5931\u6548\uff0c\u65e0\u6cd5\u518d\u63a8\u8fdb\u62db\u8058\u6d41\u7a0b\u3002", (String)"RecoverAppFileValidator_4", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
            }
        } else {
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject appFile = dataEntity.getDataEntity();
                DynamicObject stdRsm = appFile.getDynamicObject("stdrsm");
                if (!stdRsm.getString("status").equals("C")) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u5931\u6548\uff0c\u65e0\u6cd5\u518d\u63a8\u8fdb\u62db\u8058\u6d41\u7a0b\u3002", (String)"RecoverAppFileValidator_4", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

