/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.appfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileOpRecordService;
import kd.tsc.tsirm.business.domain.rsm.common.helper.ResumeBoHelper;
import kd.tsc.tsirm.business.domain.rsm.sr.service.AddResumeHandleService;
import kd.tsc.tsirm.business.license.TSIRMCertCommonHelper;
import kd.tsc.tsirm.common.constants.appfile.AppFileConstants;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.entity.SaveCandidateResult;
import kd.tsc.tsrbs.common.enums.OpDefEnum;
import kd.tsc.tsrbs.common.enums.rsm.RsmSourceEnum;

public class TransferPositionValidator
extends HRDataBaseValidator {
    private static final Long APP_METHOD_TRANSFER_POS_ID = 1080L;
    private final DynamicObject position;
    private Set<Long> existStdRsmMids = null;
    private Set<ExtendedDataEntity> transferDataEntitySet = null;
    private Set<ExtendedDataEntity> tpSuccessEntitySet = null;

    public TransferPositionValidator(DynamicObject position) {
        this.position = position;
    }

    public void validate() {
        ArrayList extendedDataEntities = Lists.newArrayList((Object[])this.getDataEntities());
        Collections.reverse(extendedDataEntities);
        this.setDataEntities(extendedDataEntities.toArray(new ExtendedDataEntity[0]));
        this.validateTransferPosRequest();
        if (!this.validateLicense()) {
            return;
        }
        this.transferPosition();
        this.validateEliminate();
    }

    private boolean validateLicense() {
        List appFileIds = this.transferDataEntitySet.stream().map(ExtendedDataEntity::getDataEntity).map(appFile -> appFile.getLong("id")).collect(Collectors.toList());
        if (appFileIds.size() == 0) {
            return true;
        }
        List pids = AppFileHelper.getAppFilePid(appFileIds);
        Map resultMap = TSIRMCertCommonHelper.verifyCertByPid((String)"2+TXFE9NU13A", (String)"tsirm_appfile_view", (List)pids);
        if ("FAIL".equals(resultMap.get("STATE").toString())) {
            Map data = (Map)resultMap.get("DATA");
            String message = (String)data.get("infoType");
            if ("FORBIDDEN".equals(message)) {
                for (ExtendedDataEntity dataEntity : this.transferDataEntitySet) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bb8\u53ef\u5360\u7528\u6570\u91cf\u5df2\u8d85\u8fc7\u8d2d\u4e70\u6570\u91cf\u4e0a\u9650\uff0c\u7cfb\u7edf\u529f\u80fd\u9650\u5236\u4f7f\u7528\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8865\u5145\u8bb8\u53ef\u8d2d\u4e70\u6570\u91cf\u3002", (String)"TransferPositionValidator_10", (String)"tsc-tsirm-opplugin", (Object[])new Object[0]));
                }
                return false;
            }
            HashSet extendedDataEntities = Sets.newHashSet(this.transferDataEntitySet);
            for (ExtendedDataEntity dataEntity : extendedDataEntities) {
                DynamicObject appfile;
                Long appid;
                List appFileIdByPid;
                HashSet appids = new HashSet(extendedDataEntities.size());
                List nexistids = (List)resultMap.get("NEXISTID");
                List exceptids = (List)resultMap.get("EXCEPTID");
                if (nexistids != null && nexistids.size() > 0) {
                    appFileIdByPid = AppFileHelper.getAppFileIdByPid((List)nexistids);
                    appids.addAll(appFileIdByPid);
                }
                if (exceptids != null && exceptids.size() > 0) {
                    appFileIdByPid = AppFileHelper.getAppFileIdByPid((List)exceptids);
                    appids.addAll(appFileIdByPid);
                }
                if (!appids.contains(appid = Long.valueOf((appfile = dataEntity.getDataEntity()).getLong("id")))) continue;
                String name = appfile.getString("name");
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"{0}\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"TransferPositionValidator_11", (String)"tsc-tsirm-opplugin", (Object[])new Object[]{name}));
                this.transferDataEntitySet.remove(dataEntity);
            }
            return true;
        }
        return true;
    }

    private void transferPosition() {
        this.tpSuccessEntitySet = Sets.newHashSetWithExpectedSize((int)this.transferDataEntitySet.size());
        HashSet tpSuccessMidSet = Sets.newHashSetWithExpectedSize((int)this.transferDataEntitySet.size());
        for (ExtendedDataEntity dataEntity : this.transferDataEntitySet) {
            DynamicObject appFile = dataEntity.getDataEntity();
            Long rsmId = appFile.getLong("appres.id");
            Long mid = dataEntity.getDataEntity().getLong("stdrsm.mid");
            if (!tpSuccessMidSet.contains(mid)) {
                AppResumeBo appResumeBo = ResumeBoHelper.getAppResumeBo((Long)rsmId);
                if (appResumeBo == null) continue;
                ResumeBoHelper.loadAllListData((AppResumeBo)appResumeBo);
                AppResumeBo copyRsm = ResumeBoHelper.copy((AppResumeBo)appResumeBo);
                copyRsm.getDelivery().set("appmthd", (Object)APP_METHOD_TRANSFER_POS_ID);
                copyRsm.getRsm().set("rsmsource", (Object)RsmSourceEnum.TP.getCode());
                copyRsm.getRsm().set("stdrsm", (Object)mid);
                SaveCandidateResult handle = AddResumeHandleService.getInstance().handle(copyRsm, this.position, Boolean.TRUE);
                if (!handle.isSuccess()) {
                    this.showRepeatAppMsg(dataEntity);
                    continue;
                }
                this.tpSuccessEntitySet.add(dataEntity);
                tpSuccessMidSet.add(mid);
                continue;
            }
            this.showRepeatAppMsg(dataEntity);
        }
        HashMap params = Maps.newHashMapWithExpectedSize((int)1);
        params.put(OpDefEnum.TSIRM_SWITCH_POSITION.getCode(), this.position.getString("name"));
        List appFileIdList = this.tpSuccessEntitySet.stream().map(dyo -> dyo.getDataEntity().getLong("id")).collect(Collectors.toList());
        AppFileOpRecordService.getInstance().sendOpRecord(AppFileResManagerHelper.getRecRoleName(), OpDefEnum.TSIRM_SWITCH_POSITION, appFileIdList, (Map)params);
    }

    private void showRepeatAppMsg(ExtendedDataEntity dataEntity) {
        if (this.getFalseDataEntities().contains(dataEntity)) {
            return;
        }
        boolean isEliminated = Boolean.parseBoolean(this.getOption().getVariableValue("istpeliminate"));
        String tip = isEliminated ? (this.getDataEntities().length == 1 ? ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u5728\u6b64\u804c\u4f4d\u4e0b\uff0c\u4e0d\u80fd\u8fdb\u884c\u8f6c\u79fb\u4e14\u6dd8\u6c70\u5931\u8d25\u3002", (String)"TransferPositionValidator_0", (String)"tsc-tsrbs-opplugin", (Object[])new Object[0]) : String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5df2\u5728\u6b64\u804c\u4f4d\u4e0b\uff0c\u4e0d\u80fd\u8fdb\u884c\u8f6c\u79fb\u4e14\u6dd8\u6c70\u5931\u8d25\u3002", (String)"TransferPositionValidator_1", (String)"tsc-tsrbs-opplugin", (Object[])new Object[0]), dataEntity.getDataEntity().getString("name"))) : (this.getDataEntities().length == 1 ? ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u5728\u6b64\u804c\u4f4d\u4e0b\uff0c\u4e0d\u80fd\u8fdb\u884c\u8f6c\u79fb\u3002", (String)"TransferPositionValidator_7", (String)"tsc-tsrbs-opplugin", (Object[])new Object[0]) : String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5df2\u5728\u6b64\u804c\u4f4d\u4e0b\uff0c\u4e0d\u80fd\u8fdb\u884c\u8f6c\u79fb\u3002", (String)"TransferPositionValidator_8", (String)"tsc-tsrbs-opplugin", (Object[])new Object[0]), dataEntity.getDataEntity().getString("name")));
        this.addErrorMessage(dataEntity, tip);
    }

    private void validateEliminate() {
        boolean isEliminated = Boolean.parseBoolean(this.getOption().getVariableValue("istpeliminate"));
        if (isEliminated) {
            for (ExtendedDataEntity dataEntity : this.tpSuccessEntitySet) {
                DynamicObject appFile = dataEntity.getDataEntity();
                if (!AppFileConstants.APP_FILE_STATUS_INVALID.equals(appFile.getString("filestatus"))) continue;
                String tip = this.getDataEntities().length == 1 ? ResManager.loadKDString((String)"\u5019\u9009\u4eba\u8f6c\u804c\u4f4d\u6210\u529f\uff0c\u4f46\u5f53\u524d\u804c\u4f4d\u5e94\u8058\u4fe1\u606f\u5df2\u5931\u6548\uff0c\u6dd8\u6c70\u5931\u8d25\u3002", (String)"TransferPositionValidator_5", (String)"tsc-tsrbs-opplugin", (Object[])new Object[0]) : String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u8f6c\u804c\u4f4d\u6210\u529f\uff0c\u4f46\u5f53\u524d\u804c\u4f4d\u5e94\u8058\u4fe1\u606f\u5df2\u5931\u6548\uff0c\u6dd8\u6c70\u5931\u8d25\u3002", (String)"TransferPositionValidator_6", (String)"tsc-tsrbs-opplugin", (Object[])new Object[0]), dataEntity.getDataEntity().getString("name"));
                this.addFatalErrorMessage(dataEntity, tip);
            }
        }
    }

    private void validateTransferPosRequest() {
        Long positionId = Long.valueOf(this.getOption().getVariableValue("position"));
        Object[] dataEntities = this.getDataEntities();
        this.transferDataEntitySet = Sets.newHashSet((Object[])dataEntities);
        this.validateFileStatus((ExtendedDataEntity[])dataEntities);
        this.validateRepeatFile(positionId, (ExtendedDataEntity[])dataEntities);
    }

    private void validateFileStatus(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject appFile = dataEntities.length == 1 ? AppFileHelper.queryOne((long)((Long)dataEntities[0].getBillPkId()), (String)"filestatus,name") : dataEntity.getDataEntity();
            boolean isEmp = AppFileHelper.isInEmpStatus((DynamicObject)appFile);
            if (!isEmp) continue;
            String tipFmt = AppFileResManagerHelper.getFileStatusErrorTip();
            String tip = String.format(tipFmt, appFile.getString("name"), AppFileHelper.getFileStatusDesc((DynamicObject)appFile), this.getOperationName());
            this.addFatalErrorMessage(dataEntity, tip);
            this.transferDataEntitySet.remove(dataEntity);
        }
    }

    private void validateRepeatFile(Long positionId, ExtendedDataEntity[] dataEntities) {
        this.existStdRsmMids = AppFileDataHelper.getAppFileIdsByStdRsmMidsAndPositionId(Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("stdrsm.mid")).filter(num -> 0L != num).collect(Collectors.toSet()), (Long)positionId);
        for (ExtendedDataEntity dataEntity2 : dataEntities) {
            DynamicObject appFile = dataEntity2.getDataEntity();
            if (!this.existStdRsmMids.contains(appFile.getLong("stdrsm.mid"))) continue;
            this.showRepeatAppMsg(dataEntity2);
            this.transferDataEntitySet.remove(dataEntity2);
        }
    }
}

