/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.exam;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.domain.exam.service.ExamKDStringService;
import kd.tsc.tsirm.business.domain.exam.service.ExamWrittenOpService;

public class ExamWrittenValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList pkIds = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            pkIds.add((Long)dataEntity.getBillPkId());
        }
        Map pkIdsAndIsDelete = ExamWrittenOpService.verifyIsDeleteData((List)pkIds);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            Boolean isDelete = (Boolean)pkIdsAndIsDelete.get(dataEntity.getBillPkId());
            if (isDelete == null || !isDelete.booleanValue()) continue;
            this.addFatalErrorMessage(dataEntity, ExamKDStringService.getDataNotFoundMsg());
        }
    }
}

