/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.hire;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.domain.hire.approval.HireApprovalService;
import kd.tsc.tsirm.business.domain.hire.approval.common.HireCommonKDStringHelper;
import kd.tsc.tsirm.common.enums.hire.HireOpEnum;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;

public class HireApprovalAFStasValidator
extends HRDataBaseValidator {
    private Map<Long, Integer> idAndDataEntityIndex;

    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        this.idAndDataEntityIndex = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        for (int i = 0; i < dataEntities.length; ++i) {
            ExtendedDataEntity dataEntity = dataEntities[i];
            this.idAndDataEntityIndex.put(dataEntity.getDataEntity().getLong("id"), i);
        }
        Set idList = Arrays.stream(dataEntities).map(data -> data.getDataEntity().getLong("id")).collect(Collectors.toSet());
        DynamicObject[] hireData = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_hireapprovalsg").loadDynamicObjectArray(idList.toArray());
        if (hireData.length == 0 && dataEntities.length == 1) {
            hireData = new DynamicObject[]{dataEntities[0].getDataEntity()};
        }
        for (DynamicObject dyn : Arrays.asList(hireData)) {
            HireOpEnum anEnum = HireOpEnum.getEnum((String)this.getOperateKey());
            if (anEnum == null) {
                this.addMessage(dataEntities[0], String.format(HireCommonKDStringHelper.opNameNotExistStr(), new Object[0]), ErrorLevel.Error);
                return;
            }
            String opName = anEnum.getText().loadKDString();
            DynamicObject appFileDy = dyn.getDynamicObject("appfile");
            if (appFileDy == null) {
                this.addMessage(dataEntities[0], String.format(HireCommonKDStringHelper.appFileStatusError(), new Object[0]), ErrorLevel.Error);
                continue;
            }
            boolean editShow = HireApprovalService.checkAppFileStatusOfPro(Collections.singletonList(appFileDy.getLong("id")));
            if (editShow) continue;
            this.addFatalErrorMessage(dataEntities[this.idAndDataEntityIndex.get(dyn.get("id"))], String.format(HireCommonKDStringHelper.AppfileStatusStrOfPro(), opName));
        }
    }
}

