/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.hire;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.domain.hire.approval.common.HireCommonKDStringHelper;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;

public class HireApprovalBillStatusValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        this.validateStatus(this.getDataEntities());
    }

    private void validateStatus(ExtendedDataEntity[] dataEntities) {
        if (dataEntities != null && dataEntities.length > 0) {
            HashSet<Long> idSet = new HashSet<Long>(dataEntities.length);
            for (int i = 0; i < dataEntities.length; ++i) {
                ExtendedDataEntity dataEntity = dataEntities[i];
                Long hireId = dataEntity.getDataEntity().getLong("id");
                idSet.add(hireId);
            }
            DynamicObject[] hireData = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_hireapprovalsg").loadDynamicObjectArray(idSet.toArray());
            Map<Long, DynamicObject> hireIdAndDyMap = Arrays.stream(hireData).collect(Collectors.toMap(keyMapper -> keyMapper.getLong("id"), valueMapper -> valueMapper));
            for (ExtendedDataEntity dataEntity : dataEntities) {
                this.validateBillStatus(dataEntity, hireIdAndDyMap);
            }
        }
    }

    private void validateBillStatus(ExtendedDataEntity dataEntity, Map<Long, DynamicObject> hireIdAndDyMap) {
        DynamicObject hireDyo = hireIdAndDyMap.get(dataEntity.getBillPkId());
        String billStatus = hireDyo.getString("billstatus");
        if (!("C".equals(billStatus) || "E".equals(billStatus) || "G".equals(billStatus))) {
            this.addFatalErrorMessage(dataEntity, HireCommonKDStringHelper.getHireBillStatusMsg());
        }
    }
}

