/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.hire;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.domain.hire.approval.HireApprovalService;
import kd.tsc.tsirm.business.domain.hire.approval.common.HireCommonKDStringHelper;
import kd.tsc.tsirm.common.enums.hire.HireOpEnum;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;

public class HireApprovalBlackListValidator
extends HRDataBaseValidator {
    private Map<Long, Integer> idAndDataEntityIndex;

    public void validate() {
        super.validate();
        HireOpEnum anEnum = HireOpEnum.getEnum((String)this.getOperateKey());
        if (anEnum == null) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        this.idAndDataEntityIndex = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        for (int i = 0; i < dataEntities.length; ++i) {
            ExtendedDataEntity dataEntity = dataEntities[i];
            this.idAndDataEntityIndex.put(dataEntity.getDataEntity().getLong("id"), i);
        }
        Set idList = Arrays.stream(dataEntities).map(data -> data.getDataEntity().getLong("id")).collect(Collectors.toSet());
        DynamicObject[] hireData = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_hireapprovalsg").loadDynamicObjectArray(idList.toArray());
        if (hireData.length == 0 && dataEntities.length == 1) {
            hireData = new DynamicObject[]{dataEntities[0].getDataEntity()};
        }
        for (DynamicObject dyn : Arrays.asList(hireData)) {
            String opName = anEnum.getText().loadKDString();
            DynamicObject appFileDy = dyn.getDynamicObject("appfile");
            String name = appFileDy.getString("name");
            Long appFileId = appFileDy.getLong("id");
            Map longBooleanMap = HireApprovalService.checkBlackList(Collections.singletonList(appFileId));
            if (longBooleanMap == null || longBooleanMap.get(appFileId) == null || !((Boolean)longBooleanMap.get(appFileId)).booleanValue()) continue;
            this.addFatalErrorMessage(dataEntities[this.idAndDataEntityIndex.get(dyn.get("id"))], String.format(HireCommonKDStringHelper.AppfileBlackListStr(), name, opName));
        }
    }
}

