/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.hire;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.domain.hire.approval.HireApprovalService;
import kd.tsc.tsirm.common.dto.hire.HireVerifyResult;

public class HireApprovalDuplicateValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        this.handle();
    }

    private void handle() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        int length = dataEntities.length;
        ArrayList<Long> affFilList = new ArrayList<Long>(length);
        ArrayList<Long> hireIdList = new ArrayList<Long>(length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            affFilList.add(dataEntity.getDataEntity().getDynamicObject("appfile").getLong("id"));
            Long pkValue = dataEntity.getDataEntity().getLong("id");
            if (pkValue == null || pkValue <= 0L) continue;
            hireIdList.add(pkValue);
        }
        HireVerifyResult hireVerifyResult = HireApprovalService.verifyHireSave(affFilList, hireIdList);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.addHireErrorMessage(dataEntity, hireVerifyResult);
        }
    }

    private void addHireErrorMessage(ExtendedDataEntity dataEntity, HireVerifyResult verifyResult) {
        DynamicObject appFileDyn = (DynamicObject)dataEntity.getValue("appfile");
        Long appFileId = appFileDyn.getLong("id");
        if (verifyResult.getFailAppFileId().contains(appFileId)) {
            List failReasons = (List)verifyResult.getFailReason().get(appFileId);
            for (String failReason : failReasons) {
                this.addFatalErrorMessage(dataEntity, failReason);
            }
        }
    }
}

