/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.opplugin.web.validator.hire;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tsirm.business.license.TSIRMCertCommonHelper;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;

public class HireApprovalLicenseValidator
extends HRDataBaseValidator {
    private static HRBaseServiceHelper PERSONHELPER = new HRBaseServiceHelper("hrpi_person");
    private static HRBaseServiceHelper EMPHELPER = new HRBaseServiceHelper("hrpi_employee");

    public void validate() {
        ExtendedDataEntity[] hireDataEntities = this.getDataEntities();
        if (hireDataEntities != null && hireDataEntities.length > 0) {
            ArrayList<Long> empIds = new ArrayList<Long>(hireDataEntities.length);
            HashSet<Long> idList = new HashSet<Long>(hireDataEntities.length);
            for (ExtendedDataEntity hireExtendedDataEntity : hireDataEntities) {
                DynamicObject dyo = hireExtendedDataEntity.getDataEntity();
                Long pkValue = dyo.getLong("id");
                if (pkValue == null || pkValue == 0L) continue;
                idList.add(pkValue);
            }
            if (idList != null && !idList.isEmpty()) {
                DynamicObject[] hireData = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_hireapprovalsg").loadDynamicObjectArray(idList.toArray());
                HashMap<Long, DynamicObject> hireMap = new HashMap<Long, DynamicObject>(hireData.length);
                for (DynamicObject hireDynamicObject : hireData) {
                    DynamicObject employee = hireDynamicObject.getDynamicObject("employee");
                    empIds.add((Long)employee.getPkValue());
                    hireMap.put((Long)hireDynamicObject.getPkValue(), hireDynamicObject);
                }
                Map<Long, Long> pidAndEmpIdMap = this.getpidAndEmpIdMap(empIds);
                ArrayList<Long> pids = new ArrayList<Long>(pidAndEmpIdMap.keySet());
                Map licenseMap = TSIRMCertCommonHelper.verifyCertByPid((String)"2+TXFE9NU13A", (String)"tsirm_stdrsm", pids);
                if ("FAIL".equals(licenseMap.get("STATE"))) {
                    Map<Long, Long> empIdAndPidMap = this.getNotExistAndExceptionEmpIds(licenseMap, pidAndEmpIdMap, hireDataEntities.length);
                    Map personDyoMap = TSIRMCertCommonHelper.getPersonByPids(new ArrayList<Long>(empIdAndPidMap.values()));
                    for (ExtendedDataEntity hireDataEntity : hireDataEntities) {
                        this.validateLicense(empIdAndPidMap, personDyoMap, hireDataEntity, hireMap);
                    }
                }
            } else {
                Long empId = (Long)this.getDataEntities()[0].getDataEntity().getDynamicObject("employee").getPkValue();
                empIds.add(empId);
                Map<Long, Long> pidAndEmpIdMap = this.getpidAndEmpIdMap(empIds);
                ArrayList<Long> pids = new ArrayList<Long>(pidAndEmpIdMap.keySet());
                Map licenseMap = TSIRMCertCommonHelper.verifyCertByPid((String)"2+TXFE9NU13A", (String)"tsirm_stdrsm", pids);
                if ("FAIL".equals(licenseMap.get("STATE"))) {
                    Map<Long, Long> empIdAndPidMap = this.getNotExistAndExceptionEmpIds(licenseMap, pidAndEmpIdMap, hireDataEntities.length);
                    Map personDyoMap = TSIRMCertCommonHelper.getPersonByPids(new ArrayList<Long>(empIdAndPidMap.values()));
                    this.validateLicense(empIdAndPidMap, personDyoMap, this.getDataEntities()[0]);
                }
            }
        }
    }

    private void validateLicense(Map<Long, Long> empIdAndPidMap, Map<Long, DynamicObject> personDyoMap, ExtendedDataEntity hireDataEntity, Map<Long, DynamicObject> hireMap) {
        DynamicObject hireDynamicObject = hireMap.get((Long)hireDataEntity.getDataEntity().getPkValue());
        Long empId = (Long)hireDynamicObject.getDynamicObject("employee").getPkValue();
        if (empIdAndPidMap.containsKey(empId)) {
            Long pid = empIdAndPidMap.get(empId);
            DynamicObject person = personDyoMap.get(pid);
            String name = "";
            if (person != null) {
                name = person.getString("name");
            }
            String message = TSIRMCertCommonHelper.getExceptionMsg((String)name);
            this.addFatalErrorMessage(hireDataEntity, message);
        }
    }

    private void validateLicense(Map<Long, Long> empIdAndPidMap, Map<Long, DynamicObject> personDyoMap, ExtendedDataEntity hireDataEntity) {
        DynamicObject hireDynamicObject = hireDataEntity.getDataEntity();
        Long empId = (Long)hireDynamicObject.getDynamicObject("employee").getPkValue();
        if (empIdAndPidMap.containsKey(empId)) {
            Long pid = empIdAndPidMap.get(empId);
            DynamicObject person = personDyoMap.get(pid);
            String name = "";
            if (person != null) {
                name = person.getString("name");
            }
            String message = TSIRMCertCommonHelper.getExceptionMsg((String)name);
            this.addFatalErrorMessage(hireDataEntity, message);
        }
    }

    private Map<Long, Long> getNotExistAndExceptionEmpIds(Map<String, Object> licenseMap, Map<Long, Long> pidAndEmpIdMap, int initialCapacity) {
        HashMap<Long, Long> empIdAndPidMap = new HashMap<Long, Long>(initialCapacity);
        List nexistids = (List)licenseMap.get("NEXISTID");
        List exceptids = (List)licenseMap.get("EXCEPTID");
        if (nexistids != null && nexistids.size() > 0) {
            for (Long pid : nexistids) {
                empIdAndPidMap.put(pidAndEmpIdMap.get(pid), pid);
            }
        }
        if (exceptids != null && exceptids.size() > 0) {
            for (Long pid : exceptids) {
                empIdAndPidMap.put(pidAndEmpIdMap.get(pid), pid);
            }
        }
        return empIdAndPidMap;
    }

    private Map<Long, Long> getpidAndEmpIdMap(List<Long> empIds) {
        DynamicObject[] emps = EMPHELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", empIds)});
        if (emps != null && emps.length > 0) {
            HashMap<Long, Long> pidAndEmpIdMap = new HashMap<Long, Long>(emps.length);
            HashMap<Long, Long> personIdAndEmpIdMap = new HashMap<Long, Long>(emps.length);
            for (DynamicObject emp : emps) {
                Long empId = (Long)emp.getPkValue();
                Long personId = (Long)emp.getDynamicObject("person").getPkValue();
                personIdAndEmpIdMap.put(personId, empId);
            }
            ArrayList personids = new ArrayList(personIdAndEmpIdMap.keySet());
            DynamicObject[] persons = PERSONHELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", personids)});
            if (persons != null && persons.length > 0) {
                for (DynamicObject person : persons) {
                    Long personId = (Long)person.getPkValue();
                    pidAndEmpIdMap.put(person.getLong("personindexid"), (Long)personIdAndEmpIdMap.get(personId));
                }
            }
            return pidAndEmpIdMap;
        }
        return new HashMap<Long, Long>(1);
    }
}

